// python wrapper for vtkPVPlugin
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkPVPlugin.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkPVPlugin(PyObject *dict); }

static PyObject *
PyvtkPVPlugin_GetFileName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFileName");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkPVPlugin *op = static_cast<vtkPVPlugin *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const char *tempr = op->GetFileName();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlugin_GetPluginName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPluginName");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkPVPlugin *op = static_cast<vtkPVPlugin *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const char *tempr = op->GetPluginName();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlugin_GetPluginVersionString(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPluginVersionString");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkPVPlugin *op = static_cast<vtkPVPlugin *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const char *tempr = op->GetPluginVersionString();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlugin_GetRequiredOnServer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRequiredOnServer");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkPVPlugin *op = static_cast<vtkPVPlugin *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = op->GetRequiredOnServer();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlugin_GetRequiredOnClient(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRequiredOnClient");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkPVPlugin *op = static_cast<vtkPVPlugin *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = op->GetRequiredOnClient();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlugin_GetRequiredPlugins(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRequiredPlugins");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkPVPlugin *op = static_cast<vtkPVPlugin *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const char *tempr = op->GetRequiredPlugins();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlugin_GetDescription(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDescription");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkPVPlugin *op = static_cast<vtkPVPlugin *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const char *tempr = op->GetDescription();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlugin_GetEULA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetEULA");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkPVPlugin *op = static_cast<vtkPVPlugin *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const char *tempr = op->GetEULA();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPlugin_GetBinaryResources(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetBinaryResources");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkPVPlugin *op = static_cast<vtkPVPlugin *>(vp);

  std::vector<std::string> temp0(ap.GetArgSize(0));
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0.data(), temp0.size()))
  {
    op->GetBinaryResources(temp0);

    if (!ap.ErrorOccurred())
    {
      PyObject *vec = (temp0.empty() ?
        PyTuple_New(0) :
        vtkPythonArgs::BuildTuple(temp0.data(), temp0.size()));
      ap.SetContents(0, vec);
      Py_DECREF(vec);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkPVPlugin_Methods[] = {
  {"GetFileName", PyvtkPVPlugin_GetFileName, METH_VARARGS,
   "GetFileName(self) -> str\nC++: const char *GetFileName()\n\n"},
  {"GetPluginName", PyvtkPVPlugin_GetPluginName, METH_VARARGS,
   "GetPluginName(self) -> str\nC++: virtual const char *GetPluginName()\n\nReturns the name for this plugin.\n"},
  {"GetPluginVersionString", PyvtkPVPlugin_GetPluginVersionString, METH_VARARGS,
   "GetPluginVersionString(self) -> str\nC++: virtual const char *GetPluginVersionString()\n\nReturns the version for this plugin.\n"},
  {"GetRequiredOnServer", PyvtkPVPlugin_GetRequiredOnServer, METH_VARARGS,
   "GetRequiredOnServer(self) -> bool\nC++: virtual bool GetRequiredOnServer()\n\nReturns true if this plugin is required on the server.\n"},
  {"GetRequiredOnClient", PyvtkPVPlugin_GetRequiredOnClient, METH_VARARGS,
   "GetRequiredOnClient(self) -> bool\nC++: virtual bool GetRequiredOnClient()\n\nReturns true if this plugin is required on the client.\n"},
  {"GetRequiredPlugins", PyvtkPVPlugin_GetRequiredPlugins, METH_VARARGS,
   "GetRequiredPlugins(self) -> str\nC++: virtual const char *GetRequiredPlugins()\n\nReturns a ';' separated list of plugin names required by this\nplugin.\n"},
  {"GetDescription", PyvtkPVPlugin_GetDescription, METH_VARARGS,
   "GetDescription(self) -> str\nC++: virtual const char *GetDescription()\n\nReturns a description of this plugin.\n"},
  {"GetEULA", PyvtkPVPlugin_GetEULA, METH_VARARGS,
   "GetEULA(self) -> str\nC++: virtual const char *GetEULA()\n\nReturns EULA for the plugin, if any. If none, this will return\nnullptr.\n"},
  {"GetBinaryResources", PyvtkPVPlugin_GetBinaryResources, METH_VARARGS,
   "GetBinaryResources(self, resources:[str, ...]) -> None\nC++: virtual void GetBinaryResources(\n    std::vector<std::string> &resources)\n\nProvides access to binary resources compiled into the plugin.\nThis is primarily used to compile in icons and compressed help\nproject (qch) files into plugins.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkPVPlugin_GetSets[] = {
  {
    /*name=*/pystr("file_name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVPlugin_GetFileName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetFileName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("plugin_name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVPlugin_GetPluginName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetPluginName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("plugin_version_string"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVPlugin_GetPluginVersionString(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetPluginVersionString\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("required_on_server"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVPlugin_GetRequiredOnServer(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetRequiredOnServer\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("required_on_client"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVPlugin_GetRequiredOnClient(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetRequiredOnClient\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("required_plugins"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVPlugin_GetRequiredPlugins(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetRequiredPlugins\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("description"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVPlugin_GetDescription(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetDescription\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("eula"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVPlugin_GetEULA(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetEULA\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};

static const char *PyvtkPVPlugin_Doc =
  "vtkPVPlugin - defines the core interface for any ParaView plugin.\n\n"
  "vtkPVPlugin defines the core interface for any ParaView plugin. A\n"
  "plugin implementing merely this interface is pretty much useless. The\n"
  "header file also defines few import macros that are required for\n"
  "exporting/importing plugins.\n\n"
  "When debugging issues with plugins try setting the\n"
  "`PARAVIEW_LOG_PLUGIN_VERBOSITY=`  environment variable on all the\n"
  "processes where you are trying to load the plugin. That will print\n"
  "extra information as the plugin is being loaded. See\n"
  "`vtkPVLogger::SetPluginVerbosity` for details.\n\n";

static PyObject *
PyvtkPVPlugin_New(PyTypeObject * /*unused*/, PyObject * /*unused*/, PyObject * /*unused*/)
{
  PyErr_SetString(PyExc_TypeError,
                  "this class cannot be instantiated");

  return nullptr;
}

static void PyvtkPVPlugin_Delete(PyObject *self)
{
  PyVTKSpecialObject *obj = (PyVTKSpecialObject *)self;
  delete static_cast<vtkPVPlugin *>(obj->vtk_ptr);
  PyObject_Del(self);
}

static Py_hash_t PyvtkPVPlugin_Hash(PyObject *self)
{
  return PyObject_HashNotImplemented(self);
}

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPVPlugin_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingCore.vtkPVPlugin", // tp_name
  sizeof(PyVTKSpecialObject), // tp_basicsize
  0, // tp_itemsize
  PyvtkPVPlugin_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKSpecialObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  PyvtkPVPlugin_Hash, // tp_hash
  nullptr, // tp_call
  nullptr, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  nullptr, // tp_setattro
  nullptr, // tp_as_buffer
  Py_TPFLAGS_DEFAULT, // tp_flags
  PyvtkPVPlugin_Doc, // tp_doc
  nullptr, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  0, // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  nullptr, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  0, // tp_dictoffset
  nullptr, // tp_init
  nullptr, // tp_alloc
  PyvtkPVPlugin_New, // tp_new
  PyObject_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

#ifndef DECLARED_PyvtkPVPlugin_TypeNew
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkPVPlugin_TypeNew(); }
#define DECLARED_PyvtkPVPlugin_TypeNew
#endif

PyObject *PyvtkPVPlugin_TypeNew()
{
  PyTypeObject *pytype = PyVTKSpecialType_Add(
    &PyvtkPVPlugin_Type,
    PyvtkPVPlugin_Methods,
    PyvtkPVPlugin_GetSets,
    nullptr,
    nullptr);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkPVPlugin(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkPVPlugin_TypeNew();

  if (o && PyDict_SetItemString(dict, "vtkPVPlugin", o) != 0)
  {
    Py_DECREF(o);
  }

}

