#include "vtkABI.h"
#include "vtkClientServerInterpreter.h"

extern "C" { void vtkCompositeDataReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkCompositeDataWriter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkDataObjectReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkDataObjectWriter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkDataReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkDataSetReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkDataSetWriter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkDataWriter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkGenericDataObjectReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkGenericDataObjectWriter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkGraphReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkGraphWriter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkLegacyCellGridReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkLegacyCellGridWriter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPixelExtentIO_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPolyDataReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPolyDataWriter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkRectilinearGridReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkRectilinearGridWriter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkSimplePointsReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkSimplePointsWriter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkStructuredGridReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkStructuredGridWriter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkStructuredPointsReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkStructuredPointsWriter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkTableReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkTableWriter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkTreeReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkTreeWriter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkUnstructuredGridReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkUnstructuredGridWriter_Init(vtkClientServerInterpreter*); }

extern "C" VTK_ABI_EXPORT void vtkIOLegacyCS_Initialize(vtkClientServerInterpreter* csi)
{
  (void)csi;
  vtkCompositeDataReader_Init(csi);
  vtkCompositeDataWriter_Init(csi);
  vtkDataObjectReader_Init(csi);
  vtkDataObjectWriter_Init(csi);
  vtkDataReader_Init(csi);
  vtkDataSetReader_Init(csi);
  vtkDataSetWriter_Init(csi);
  vtkDataWriter_Init(csi);
  vtkGenericDataObjectReader_Init(csi);
  vtkGenericDataObjectWriter_Init(csi);
  vtkGraphReader_Init(csi);
  vtkGraphWriter_Init(csi);
  vtkLegacyCellGridReader_Init(csi);
  vtkLegacyCellGridWriter_Init(csi);
  vtkPixelExtentIO_Init(csi);
  vtkPolyDataReader_Init(csi);
  vtkPolyDataWriter_Init(csi);
  vtkRectilinearGridReader_Init(csi);
  vtkRectilinearGridWriter_Init(csi);
  vtkSimplePointsReader_Init(csi);
  vtkSimplePointsWriter_Init(csi);
  vtkStructuredGridReader_Init(csi);
  vtkStructuredGridWriter_Init(csi);
  vtkStructuredPointsReader_Init(csi);
  vtkStructuredPointsWriter_Init(csi);
  vtkTableReader_Init(csi);
  vtkTableWriter_Init(csi);
  vtkTreeReader_Init(csi);
  vtkTreeWriter_Init(csi);
  vtkUnstructuredGridReader_Init(csi);
  vtkUnstructuredGridWriter_Init(csi);
}
