#include "vtkABI.h"
#include "vtkClientServerInterpreter.h"

extern "C" { void vtkToAffineArrayStrategy_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkToConstantArrayStrategy_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkToImplicitArrayFilter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkToImplicitRamerDouglasPeuckerStrategy_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkToImplicitStrategy_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkToImplicitTypeErasureStrategy_Init(vtkClientServerInterpreter*); }

extern "C" VTK_ABI_EXPORT void vtkFiltersReductionCS_Initialize(vtkClientServerInterpreter* csi)
{
  (void)csi;
  vtkToAffineArrayStrategy_Init(csi);
  vtkToConstantArrayStrategy_Init(csi);
  vtkToImplicitArrayFilter_Init(csi);
  vtkToImplicitRamerDouglasPeuckerStrategy_Init(csi);
  vtkToImplicitStrategy_Init(csi);
  vtkToImplicitTypeErasureStrategy_Init(csi);
}
