
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kjobwidgets_python.h"

// main header
#include "kabstractwidgetjobtracker_wrapper.h"

// Wrappers providing overrides
#include "knotificationjobuidelegate_wrapper.h"
#include "kuiserverv2jobtracker_wrapper.h"

// Argument includes
#include <QString>
#include <kjob.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <utility>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KAbstractWidgetJobTracker_Type = nullptr;
static PyTypeObject *Sbk_KAbstractWidgetJobTracker_TypeF(void)
{
    return _Sbk_KAbstractWidgetJobTracker_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KAbstractWidgetJobTrackerWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KAbstractWidgetJobTrackerWrapper::KAbstractWidgetJobTrackerWrapper(::QWidget * parent) : KAbstractWidgetJobTracker(parent)
{
}

void KAbstractWidgetJobTrackerWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAbstractWidgetJobTracker_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    KNotificationJobUiDelegateWrapper::sbk_o_childEvent("KAbstractWidgetJobTracker", funcName, gil, pyOverride, event);
}

void KAbstractWidgetJobTrackerWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAbstractWidgetJobTracker_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    KNotificationJobUiDelegateWrapper::sbk_o_connectNotify("KAbstractWidgetJobTracker", funcName, gil, pyOverride, signal);
}

void KAbstractWidgetJobTrackerWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAbstractWidgetJobTracker_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    KNotificationJobUiDelegateWrapper::sbk_o_customEvent("KAbstractWidgetJobTracker", funcName, gil, pyOverride, event);
}

void KAbstractWidgetJobTrackerWrapper::description(::KJob * job, const ::QString & title, const ::std::pair<QString,QString> & field1, const ::std::pair<QString,QString> & field2)
{
    static const char *funcName = "description";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAbstractWidgetJobTracker_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::KJobTrackerInterface::description(job, title, field1, field2);
    }
    KUiServerV2JobTrackerWrapper::sbk_o_description("KAbstractWidgetJobTracker", funcName, gil, pyOverride, job, title, field1, field2);
}

void KAbstractWidgetJobTrackerWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAbstractWidgetJobTracker_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KNotificationJobUiDelegateWrapper::sbk_o_connectNotify("KAbstractWidgetJobTracker", funcName, gil, pyOverride, signal);
}

bool KAbstractWidgetJobTrackerWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAbstractWidgetJobTracker_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::event(event);
    }
    return KNotificationJobUiDelegateWrapper::sbk_o_event("KAbstractWidgetJobTracker", funcName, gil, pyOverride, event);
}

bool KAbstractWidgetJobTrackerWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAbstractWidgetJobTracker_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return KNotificationJobUiDelegateWrapper::sbk_o_eventFilter("KAbstractWidgetJobTracker", funcName, gil, pyOverride, watched, event);
}

void KAbstractWidgetJobTrackerWrapper::finished(::KJob * job)
{
    static const char *funcName = "finished";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAbstractWidgetJobTracker_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::KAbstractWidgetJobTracker::finished(job);
    }
    KUiServerV2JobTrackerWrapper::sbk_o_finished("KAbstractWidgetJobTracker", funcName, gil, pyOverride, job);
}

void KAbstractWidgetJobTrackerWrapper::infoMessage(::KJob * job, const ::QString & message)
{
    static const char *funcName = "infoMessage";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAbstractWidgetJobTracker_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::KJobTrackerInterface::infoMessage(job, message);
    }
    KNotificationJobUiDelegateWrapper::sbk_o_slotWarning("KAbstractWidgetJobTracker", funcName, gil, pyOverride, job, message);
}

void KAbstractWidgetJobTrackerWrapper::percent(::KJob * job, unsigned long percent)
{
    static const char *funcName = "percent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAbstractWidgetJobTracker_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::KJobTrackerInterface::percent(job, percent);
    }
    KUiServerV2JobTrackerWrapper::sbk_o_percent("KAbstractWidgetJobTracker", funcName, gil, pyOverride, job, percent);
}

void KAbstractWidgetJobTrackerWrapper::processedAmount(::KJob * job, ::KJob::Unit unit, qulonglong amount)
{
    static const char *funcName = "processedAmount";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAbstractWidgetJobTracker_TypeF(), gil, funcName, m_PyMethodCache[10], nameCache));
    if (pyOverride.isNull()) {
        return this->::KJobTrackerInterface::processedAmount(job, unit, amount);
    }
    KUiServerV2JobTrackerWrapper::sbk_o_processedAmount("KAbstractWidgetJobTracker", funcName, gil, pyOverride, job, unit, amount);
}

void KAbstractWidgetJobTrackerWrapper::registerJob(::KJob * job)
{
    static const char *funcName = "registerJob";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAbstractWidgetJobTracker_TypeF(), gil, funcName, m_PyMethodCache[11], nameCache));
    if (pyOverride.isNull()) {
        return this->::KAbstractWidgetJobTracker::registerJob(job);
    }
    KUiServerV2JobTrackerWrapper::sbk_o_finished("KAbstractWidgetJobTracker", funcName, gil, pyOverride, job);
}

void KAbstractWidgetJobTrackerWrapper::resumed(::KJob * job)
{
    static const char *funcName = "resumed";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAbstractWidgetJobTracker_TypeF(), gil, funcName, m_PyMethodCache[12], nameCache));
    if (pyOverride.isNull()) {
        return this->::KJobTrackerInterface::resumed(job);
    }
    KUiServerV2JobTrackerWrapper::sbk_o_finished("KAbstractWidgetJobTracker", funcName, gil, pyOverride, job);
}

void KAbstractWidgetJobTrackerWrapper::slotClean(::KJob * job)
{
    static const char *funcName = "slotClean";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAbstractWidgetJobTracker_TypeF(), gil, funcName, m_PyMethodCache[13], nameCache));
    if (pyOverride.isNull()) {
        return this->::KAbstractWidgetJobTracker::slotClean(job);
    }
    KUiServerV2JobTrackerWrapper::sbk_o_finished("KAbstractWidgetJobTracker", funcName, gil, pyOverride, job);
}

void KAbstractWidgetJobTrackerWrapper::slotResume(::KJob * job)
{
    static const char *funcName = "slotResume";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAbstractWidgetJobTracker_TypeF(), gil, funcName, m_PyMethodCache[14], nameCache));
    if (pyOverride.isNull()) {
        return this->::KAbstractWidgetJobTracker::slotResume(job);
    }
    KUiServerV2JobTrackerWrapper::sbk_o_finished("KAbstractWidgetJobTracker", funcName, gil, pyOverride, job);
}

void KAbstractWidgetJobTrackerWrapper::slotStop(::KJob * job)
{
    static const char *funcName = "slotStop";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAbstractWidgetJobTracker_TypeF(), gil, funcName, m_PyMethodCache[15], nameCache));
    if (pyOverride.isNull()) {
        return this->::KAbstractWidgetJobTracker::slotStop(job);
    }
    KUiServerV2JobTrackerWrapper::sbk_o_finished("KAbstractWidgetJobTracker", funcName, gil, pyOverride, job);
}

void KAbstractWidgetJobTrackerWrapper::slotSuspend(::KJob * job)
{
    static const char *funcName = "slotSuspend";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAbstractWidgetJobTracker_TypeF(), gil, funcName, m_PyMethodCache[16], nameCache));
    if (pyOverride.isNull()) {
        return this->::KAbstractWidgetJobTracker::slotSuspend(job);
    }
    KUiServerV2JobTrackerWrapper::sbk_o_finished("KAbstractWidgetJobTracker", funcName, gil, pyOverride, job);
}

void KAbstractWidgetJobTrackerWrapper::speed(::KJob * job, unsigned long value)
{
    static const char *funcName = "speed";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAbstractWidgetJobTracker_TypeF(), gil, funcName, m_PyMethodCache[17], nameCache));
    if (pyOverride.isNull()) {
        return this->::KJobTrackerInterface::speed(job, value);
    }
    KUiServerV2JobTrackerWrapper::sbk_o_percent("KAbstractWidgetJobTracker", funcName, gil, pyOverride, job, value);
}

void KAbstractWidgetJobTrackerWrapper::suspended(::KJob * job)
{
    static const char *funcName = "suspended";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAbstractWidgetJobTracker_TypeF(), gil, funcName, m_PyMethodCache[18], nameCache));
    if (pyOverride.isNull()) {
        return this->::KJobTrackerInterface::suspended(job);
    }
    KUiServerV2JobTrackerWrapper::sbk_o_finished("KAbstractWidgetJobTracker", funcName, gil, pyOverride, job);
}

void KAbstractWidgetJobTrackerWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAbstractWidgetJobTracker_TypeF(), gil, funcName, m_PyMethodCache[19], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    KNotificationJobUiDelegateWrapper::sbk_o_timerEvent("KAbstractWidgetJobTracker", funcName, gil, pyOverride, event);
}

void KAbstractWidgetJobTrackerWrapper::totalAmount(::KJob * job, ::KJob::Unit unit, qulonglong amount)
{
    static const char *funcName = "totalAmount";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAbstractWidgetJobTracker_TypeF(), gil, funcName, m_PyMethodCache[20], nameCache));
    if (pyOverride.isNull()) {
        return this->::KJobTrackerInterface::totalAmount(job, unit, amount);
    }
    KUiServerV2JobTrackerWrapper::sbk_o_processedAmount("KAbstractWidgetJobTracker", funcName, gil, pyOverride, job, unit, amount);
}

void KAbstractWidgetJobTrackerWrapper::unregisterJob(::KJob * job)
{
    static const char *funcName = "unregisterJob";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAbstractWidgetJobTracker_TypeF(), gil, funcName, m_PyMethodCache[21], nameCache));
    if (pyOverride.isNull()) {
        return this->::KAbstractWidgetJobTracker::unregisterJob(job);
    }
    KUiServerV2JobTrackerWrapper::sbk_o_finished("KAbstractWidgetJobTracker", funcName, gil, pyOverride, job);
}

void KAbstractWidgetJobTrackerWrapper::warning(::KJob * job, const ::QString & message)
{
    static const char *funcName = "warning";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAbstractWidgetJobTracker_TypeF(), gil, funcName, m_PyMethodCache[22], nameCache));
    if (pyOverride.isNull()) {
        return this->::KJobTrackerInterface::warning(job, message);
    }
    KNotificationJobUiDelegateWrapper::sbk_o_slotWarning("KAbstractWidgetJobTracker", funcName, gil, pyOverride, job, message);
}

::QWidget * KAbstractWidgetJobTrackerWrapper::widget(::KJob * job)
{
    static const char *funcName = "widget";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAbstractWidgetJobTracker_TypeF(), gil, funcName, m_PyMethodCache[23], nameCache));
    if (pyOverride.isNull()) {
        gil.acquire();
        Shiboken::Errors::setPureVirtualMethodError("KAbstractWidgetJobTracker.widget");
        return nullptr;
    }
    return sbk_o_widget("KAbstractWidgetJobTracker", funcName, gil, pyOverride, job);
}

::QWidget * KAbstractWidgetJobTrackerWrapper::sbk_o_widget(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::KJob * job)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), job)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), job)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return nullptr;
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, PepType_GetFullyQualifiedNameStr(Shiboken::SbkType< QWidget >()), Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QWidget *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

const QMetaObject *KAbstractWidgetJobTrackerWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KAbstractWidgetJobTracker::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KAbstractWidgetJobTrackerWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KAbstractWidgetJobTracker::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KAbstractWidgetJobTrackerWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KAbstractWidgetJobTrackerWrapper *>(this));
    }
    return KAbstractWidgetJobTracker::qt_metacast(_clname);
}

KAbstractWidgetJobTrackerWrapper::~KAbstractWidgetJobTrackerWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KAbstractWidgetJobTracker_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KAbstractWidgetJobTracker_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(args)
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PyTypeObject *type = self->ob_type;
    PyTypeObject *myType = Shiboken::Module::get(SbkKJobWidgetsTypeStructs[SBK_KAbstractWidgetJobTracker_IDX]);
    if (type == myType) {
        Shiboken::Errors::setInstantiateAbstractClass("KAbstractWidgetJobTracker");
        return -1;
    }

    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KAbstractWidgetJobTracker >()))
        return -1;

    KAbstractWidgetJobTrackerWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|O:KAbstractWidgetJobTracker", &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KAbstractWidgetJobTracker::KAbstractWidgetJobTracker(QWidget*=)
    if (numArgs == 0) {
        overloadId = 0; // KAbstractWidgetJobTracker(QWidget*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0])))) {
        overloadId = 0; // KAbstractWidgetJobTracker(QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKJobWidgetsTypeStructs[SBK_KAbstractWidgetJobTracker_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKJobWidgetsTypeStructs[SBK_KAbstractWidgetJobTracker_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
            if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKJobWidgetsTypeStructs[SBK_KAbstractWidgetJobTracker_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QWidget *cppArg0 = nullptr;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // KAbstractWidgetJobTracker(QWidget*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) KAbstractWidgetJobTrackerWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new KAbstractWidgetJobTrackerWrapper(cppArg0);
            }

        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KAbstractWidgetJobTracker >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKJobWidgetsTypeStructs[SBK_KAbstractWidgetJobTracker_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKJobWidgetsTypeStructs[SBK_KAbstractWidgetJobTracker_IDX]);
    };


    return 1;
}

static PyObject *Sbk_KAbstractWidgetJobTrackerFunc_autoDelete(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAbstractWidgetJobTracker *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKJobWidgetsTypeStructs[SBK_KAbstractWidgetJobTracker_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KAbstractWidgetJobTracker::autoDelete(KJob*)const->bool
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), (pyArg)))) {
        overloadId = 0; // autoDelete(KJob*)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "autoDelete", errInfo, SbkKJobWidgetsTypeStructs[SBK_KAbstractWidgetJobTracker_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::KJob *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // autoDelete(KJob*)const
            bool cppResult = const_cast<const ::KAbstractWidgetJobTracker *>(cppSelf)->autoDelete(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KAbstractWidgetJobTrackerFunc_finished(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAbstractWidgetJobTracker *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKJobWidgetsTypeStructs[SBK_KAbstractWidgetJobTracker_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KJobTrackerInterface::finished(KJob*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), (pyArg)))) {
        overloadId = 0; // finished(KJob*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "finished", errInfo, SbkKJobWidgetsTypeStructs[SBK_KAbstractWidgetJobTracker_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::KJob *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // finished(KJob*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KAbstractWidgetJobTracker::finished(cppArg0)
                : cppSelf->finished(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KAbstractWidgetJobTrackerFunc_registerJob(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAbstractWidgetJobTracker *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKJobWidgetsTypeStructs[SBK_KAbstractWidgetJobTracker_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KJobTrackerInterface::registerJob(KJob*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), (pyArg)))) {
        overloadId = 0; // registerJob(KJob*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "registerJob", errInfo, SbkKJobWidgetsTypeStructs[SBK_KAbstractWidgetJobTracker_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::KJob *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // registerJob(KJob*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KAbstractWidgetJobTracker::registerJob(cppArg0)
                : cppSelf->registerJob(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KAbstractWidgetJobTrackerFunc_setAutoDelete(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAbstractWidgetJobTracker *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKJobWidgetsTypeStructs[SBK_KAbstractWidgetJobTracker_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "setAutoDelete", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KAbstractWidgetJobTracker::setAutoDelete(KJob*,bool)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1])))) {
        overloadId = 0; // setAutoDelete(KJob*,bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setAutoDelete", errInfo, SbkKJobWidgetsTypeStructs[SBK_KAbstractWidgetJobTracker_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::KJob *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        bool cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setAutoDelete(KJob*,bool)
            cppSelf->setAutoDelete(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KAbstractWidgetJobTrackerFunc_setStopOnClose(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAbstractWidgetJobTracker *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKJobWidgetsTypeStructs[SBK_KAbstractWidgetJobTracker_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "setStopOnClose", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KAbstractWidgetJobTracker::setStopOnClose(KJob*,bool)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1])))) {
        overloadId = 0; // setStopOnClose(KJob*,bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setStopOnClose", errInfo, SbkKJobWidgetsTypeStructs[SBK_KAbstractWidgetJobTracker_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::KJob *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        bool cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setStopOnClose(KJob*,bool)
            cppSelf->setStopOnClose(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KAbstractWidgetJobTrackerFunc_slotClean(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAbstractWidgetJobTracker *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKJobWidgetsTypeStructs[SBK_KAbstractWidgetJobTracker_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KAbstractWidgetJobTracker::slotClean(KJob*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), (pyArg)))) {
        overloadId = 0; // slotClean(KJob*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "slotClean", errInfo, SbkKJobWidgetsTypeStructs[SBK_KAbstractWidgetJobTracker_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::KJob *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // slotClean(KJob*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KAbstractWidgetJobTracker::slotClean(cppArg0)
                : cppSelf->slotClean(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KAbstractWidgetJobTrackerFunc_slotResume(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAbstractWidgetJobTracker *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKJobWidgetsTypeStructs[SBK_KAbstractWidgetJobTracker_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KAbstractWidgetJobTracker::slotResume(KJob*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), (pyArg)))) {
        overloadId = 0; // slotResume(KJob*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "slotResume", errInfo, SbkKJobWidgetsTypeStructs[SBK_KAbstractWidgetJobTracker_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::KJob *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // slotResume(KJob*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KAbstractWidgetJobTracker::slotResume(cppArg0)
                : cppSelf->slotResume(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KAbstractWidgetJobTrackerFunc_slotStop(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAbstractWidgetJobTracker *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKJobWidgetsTypeStructs[SBK_KAbstractWidgetJobTracker_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KAbstractWidgetJobTracker::slotStop(KJob*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), (pyArg)))) {
        overloadId = 0; // slotStop(KJob*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "slotStop", errInfo, SbkKJobWidgetsTypeStructs[SBK_KAbstractWidgetJobTracker_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::KJob *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // slotStop(KJob*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KAbstractWidgetJobTracker::slotStop(cppArg0)
                : cppSelf->slotStop(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KAbstractWidgetJobTrackerFunc_slotSuspend(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAbstractWidgetJobTracker *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKJobWidgetsTypeStructs[SBK_KAbstractWidgetJobTracker_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KAbstractWidgetJobTracker::slotSuspend(KJob*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), (pyArg)))) {
        overloadId = 0; // slotSuspend(KJob*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "slotSuspend", errInfo, SbkKJobWidgetsTypeStructs[SBK_KAbstractWidgetJobTracker_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::KJob *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // slotSuspend(KJob*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KAbstractWidgetJobTracker::slotSuspend(cppArg0)
                : cppSelf->slotSuspend(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KAbstractWidgetJobTrackerFunc_stopOnClose(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAbstractWidgetJobTracker *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKJobWidgetsTypeStructs[SBK_KAbstractWidgetJobTracker_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KAbstractWidgetJobTracker::stopOnClose(KJob*)const->bool
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), (pyArg)))) {
        overloadId = 0; // stopOnClose(KJob*)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "stopOnClose", errInfo, SbkKJobWidgetsTypeStructs[SBK_KAbstractWidgetJobTracker_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::KJob *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // stopOnClose(KJob*)const
            bool cppResult = const_cast<const ::KAbstractWidgetJobTracker *>(cppSelf)->stopOnClose(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KAbstractWidgetJobTrackerFunc_unregisterJob(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAbstractWidgetJobTracker *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKJobWidgetsTypeStructs[SBK_KAbstractWidgetJobTracker_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KJobTrackerInterface::unregisterJob(KJob*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), (pyArg)))) {
        overloadId = 0; // unregisterJob(KJob*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "unregisterJob", errInfo, SbkKJobWidgetsTypeStructs[SBK_KAbstractWidgetJobTracker_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::KJob *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // unregisterJob(KJob*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KAbstractWidgetJobTracker::unregisterJob(cppArg0)
                : cppSelf->unregisterJob(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KAbstractWidgetJobTrackerFunc_widget(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAbstractWidgetJobTracker *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKJobWidgetsTypeStructs[SBK_KAbstractWidgetJobTracker_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KAbstractWidgetJobTracker::widget(KJob*)->QWidget*
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), (pyArg)))) {
        overloadId = 0; // widget(KJob*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "widget", errInfo, SbkKJobWidgetsTypeStructs[SBK_KAbstractWidgetJobTracker_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::KJob *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // widget(KJob*)
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                Shiboken::Errors::setPureVirtualMethodError("KAbstractWidgetJobTracker.widget");
                return {};
            }
            QWidget * cppResult = cppSelf->widget(cppArg0);
            pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_KAbstractWidgetJobTracker_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_KAbstractWidgetJobTracker_methods[] = {
    {"autoDelete", reinterpret_cast<PyCFunction>(Sbk_KAbstractWidgetJobTrackerFunc_autoDelete), METH_O, nullptr},
    {"finished", reinterpret_cast<PyCFunction>(Sbk_KAbstractWidgetJobTrackerFunc_finished), METH_O, nullptr},
    {"registerJob", reinterpret_cast<PyCFunction>(Sbk_KAbstractWidgetJobTrackerFunc_registerJob), METH_O, nullptr},
    {"setAutoDelete", reinterpret_cast<PyCFunction>(Sbk_KAbstractWidgetJobTrackerFunc_setAutoDelete), METH_VARARGS, nullptr},
    {"setStopOnClose", reinterpret_cast<PyCFunction>(Sbk_KAbstractWidgetJobTrackerFunc_setStopOnClose), METH_VARARGS, nullptr},
    {"slotClean", reinterpret_cast<PyCFunction>(Sbk_KAbstractWidgetJobTrackerFunc_slotClean), METH_O, nullptr},
    {"slotResume", reinterpret_cast<PyCFunction>(Sbk_KAbstractWidgetJobTrackerFunc_slotResume), METH_O, nullptr},
    {"slotStop", reinterpret_cast<PyCFunction>(Sbk_KAbstractWidgetJobTrackerFunc_slotStop), METH_O, nullptr},
    {"slotSuspend", reinterpret_cast<PyCFunction>(Sbk_KAbstractWidgetJobTrackerFunc_slotSuspend), METH_O, nullptr},
    {"stopOnClose", reinterpret_cast<PyCFunction>(Sbk_KAbstractWidgetJobTrackerFunc_stopOnClose), METH_O, nullptr},
    {"unregisterJob", reinterpret_cast<PyCFunction>(Sbk_KAbstractWidgetJobTrackerFunc_unregisterJob), METH_O, nullptr},
    {"widget", reinterpret_cast<PyCFunction>(Sbk_KAbstractWidgetJobTrackerFunc_widget), METH_O, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KAbstractWidgetJobTracker_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KAbstractWidgetJobTracker *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKJobWidgetsTypeStructs[SBK_KAbstractWidgetJobTracker_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KAbstractWidgetJobTrackerWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KAbstractWidgetJobTracker_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KAbstractWidgetJobTracker_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KAbstractWidgetJobTracker_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KAbstractWidgetJobTracker_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KAbstractWidgetJobTracker_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KAbstractWidgetJobTracker_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KAbstractWidgetJobTracker_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KAbstractWidgetJobTracker_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KAbstractWidgetJobTracker_spec = {
    "1:KJobWidgets.KAbstractWidgetJobTracker",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KAbstractWidgetJobTracker_slots
};

} //extern "C"

static void *Sbk_KAbstractWidgetJobTracker_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KAbstractWidgetJobTracker *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KAbstractWidgetJobTracker_PythonToCpp_KAbstractWidgetJobTracker_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KAbstractWidgetJobTracker_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KAbstractWidgetJobTracker_PythonToCpp_KAbstractWidgetJobTracker_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KAbstractWidgetJobTracker_TypeF()))
        return KAbstractWidgetJobTracker_PythonToCpp_KAbstractWidgetJobTracker_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KAbstractWidgetJobTracker_PTR_CppToPython_KAbstractWidgetJobTracker(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KAbstractWidgetJobTracker *>(const_cast<void *>(cppIn)), Sbk_KAbstractWidgetJobTracker_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KAbstractWidgetJobTracker_SignatureStrings[] = {
    "KJobWidgets.KAbstractWidgetJobTracker(self,parent:PySide6.QtWidgets.QWidget=nullptr)",
    "KJobWidgets.KAbstractWidgetJobTracker.autoDelete(self,job:KCoreAddons.KJob)->bool",
    "KJobWidgets.KAbstractWidgetJobTracker.finished(self,job:KCoreAddons.KJob)",
    "KJobWidgets.KAbstractWidgetJobTracker.registerJob(self,job:KCoreAddons.KJob)",
    "KJobWidgets.KAbstractWidgetJobTracker.setAutoDelete(self,job:KCoreAddons.KJob,autoDelete:bool)",
    "KJobWidgets.KAbstractWidgetJobTracker.setStopOnClose(self,job:KCoreAddons.KJob,stopOnClose:bool)",
    "KJobWidgets.KAbstractWidgetJobTracker.slotClean(self,job:KCoreAddons.KJob)",
    "KJobWidgets.KAbstractWidgetJobTracker.slotResume(self,job:KCoreAddons.KJob)",
    "KJobWidgets.KAbstractWidgetJobTracker.slotStop(self,job:KCoreAddons.KJob)",
    "KJobWidgets.KAbstractWidgetJobTracker.slotSuspend(self,job:KCoreAddons.KJob)",
    "KJobWidgets.KAbstractWidgetJobTracker.stopOnClose(self,job:KCoreAddons.KJob)->bool",
    "KJobWidgets.KAbstractWidgetJobTracker.unregisterJob(self,job:KCoreAddons.KJob)",
    "KJobWidgets.KAbstractWidgetJobTracker.widget(self,job:KCoreAddons.KJob)->PySide6.QtWidgets.QWidget",
    nullptr}; // Sentinel
#else
static constexpr size_t KAbstractWidgetJobTracker_SignatureByteSize = 220;
static constexpr uint8_t KAbstractWidgetJobTracker_SignatureBytes[220] = {
    0x78, 0xda, 0xad, 0x93, 0x31, 0x4f, 0xc3, 0x30, 0x10, 0x85, 0xf7, 0xfc, 0x12, 0x22, 0x95, 0x8c,
    0x1d, 0x22, 0x15, 0x29, 0x0a, 0x13, 0x19, 0x20, 0x14, 0x89, 0x39, 0xa9, 0x5f, 0x52, 0xb7, 0xc6,
    0x17, 0xf9, 0xce, 0xaa, 0xf8, 0xf7, 0xb8, 0x44, 0x55, 0x27, 0x22, 0x47, 0x78, 0xb3, 0xcf, 0x77,
    0xdf, 0xf9, 0x9d, 0x9f, 0x9b, 0x17, 0xea, 0x3f, 0xb5, 0x1a, 0x21, 0x5c, 0x34, 0x55, 0xcf, 0xe2,
    0xba, 0x83, 0xcc, 0x81, 0x70, 0xf2, 0x11, 0x76, 0x67, 0xb8, 0x07, 0x86, 0x19, 0x36, 0x53, 0xe7,
    0x60, 0xa5, 0x7c, 0xfb, 0xde, 0x6b, 0x85, 0x6d, 0xd1, 0xca, 0xad, 0xae, 0x9d, 0x17, 0x3b, 0xeb,
    0x8d, 0x99, 0xc4, 0xe5, 0x59, 0x13, 0x03, 0x2d, 0x3a, 0x2f, 0xf4, 0x0c, 0x03, 0xc1, 0xcc, 0x3f,
    0x51, 0x5f, 0x36, 0x35, 0x39, 0x54, 0x4a, 0x91, 0x0d, 0x95, 0x21, 0x37, 0x7f, 0x7c, 0xea, 0x89,
    0x4c, 0x24, 0x71, 0xd0, 0x56, 0xf3, 0x11, 0x6a, 0x81, 0x17, 0x49, 0x72, 0x18, 0x35, 0x0b, 0x5c,
    0x08, 0xfd, 0x1f, 0xc6, 0x90, 0x2a, 0x42, 0xeb, 0xe6, 0x3e, 0x90, 0xf2, 0x2a, 0x7a, 0x05, 0x7e,
    0x2f, 0x34, 0xbd, 0xda, 0xda, 0x10, 0x2f, 0xf1, 0xf9, 0x9e, 0xb5, 0xae, 0x81, 0x21, 0xa9, 0x0d,
    0x3a, 0x9b, 0x60, 0x14, 0x01, 0xf5, 0x0e, 0xf6, 0x5f, 0x48, 0xc3, 0xba, 0x0a, 0x4f, 0x44, 0xf2,
    0x3c, 0xc1, 0x26, 0xb0, 0x0e, 0xc7, 0xbc, 0xc5, 0x3a, 0x5f, 0x7b, 0x9b, 0xd4, 0x8f, 0x97, 0xdf,
    0xc0, 0xe2, 0xe5, 0xfe, 0xfc, 0xe4, 0xd9, 0x0f, 0xa8, 0x65, 0x8a, 0x9b
};
#endif

PyTypeObject *init_KAbstractWidgetJobTracker(PyObject *module)
{
    if (SbkKJobWidgetsTypeStructs[SBK_KAbstractWidgetJobTracker_IDX].type != nullptr)
        return SbkKJobWidgetsTypeStructs[SBK_KAbstractWidgetJobTracker_IDX].type;

    Shiboken::AutoDecRef Sbk_KAbstractWidgetJobTracker_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJobTrackerInterface_IDX]))));

    _Sbk_KAbstractWidgetJobTracker_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KAbstractWidgetJobTracker",
        "KAbstractWidgetJobTracker*",
        &Sbk_KAbstractWidgetJobTracker_spec,
        &Shiboken::callCppDestructor< KAbstractWidgetJobTracker >,
        Sbk_KAbstractWidgetJobTracker_Type_bases.object(),
        0);
    auto *pyType = _Sbk_KAbstractWidgetJobTracker_Type; // references _Sbk_KAbstractWidgetJobTracker_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KAbstractWidgetJobTracker_SignatureStrings);
#else
    InitSignatureBytes(pyType, KAbstractWidgetJobTracker_SignatureBytes, KAbstractWidgetJobTracker_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KAbstractWidgetJobTracker_PropertyStrings);
    SbkKJobWidgetsTypeStructs[SBK_KAbstractWidgetJobTracker_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KAbstractWidgetJobTracker_PythonToCpp_KAbstractWidgetJobTracker_PTR,
        is_KAbstractWidgetJobTracker_PythonToCpp_KAbstractWidgetJobTracker_PTR_Convertible,
        KAbstractWidgetJobTracker_PTR_CppToPython_KAbstractWidgetJobTracker);

    Shiboken::Conversions::registerConverterName(converter, "KAbstractWidgetJobTracker");
    Shiboken::Conversions::registerConverterName(converter, "KAbstractWidgetJobTracker*");
    Shiboken::Conversions::registerConverterName(converter, "KAbstractWidgetJobTracker&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KAbstractWidgetJobTracker).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KAbstractWidgetJobTrackerWrapper).name());

    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KAbstractWidgetJobTracker_TypeF(), &Sbk_KAbstractWidgetJobTracker_typeDiscovery);

    PySide::Signal::registerSignals(pyType, &::KAbstractWidgetJobTracker::staticMetaObject);
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KAbstractWidgetJobTracker::staticMetaObject, sizeof(KAbstractWidgetJobTrackerWrapper));

    return pyType;
}
