#ifndef itkImageSwigInterface_h
#define itkImageSwigInterface_h
#include "itkCommand.h"
#include "itkOffset.h"
#include "itkVector.h"
#include "itkCovariantVector.h"
#include "itkContinuousIndex.h"
#include "itkArray.h"
#include "itkFixedArray.h"
#include "itkRGBPixel.h"
#include "itkRGBAPixel.h"
#include "complex"
#include "itkSymmetricSecondRankTensor.h"
#include "itkImage.h"
#include "itkVectorImage.h"
#include "itkVariableLengthVector.h"
#include "itkPoint.h"
#include "itkImageBase.h"

using itkImageBase2 = itk::ImageBase< 2 >;
using itkImageBase2_Pointer = itk::ImageBase< 2 >::Pointer;
using itkImageBase3 = itk::ImageBase< 3 >;
using itkImageBase3_Pointer = itk::ImageBase< 3 >::Pointer;
using itkImageBase4 = itk::ImageBase< 4 >;
using itkImageBase4_Pointer = itk::ImageBase< 4 >::Pointer;
using itkImageBase5 = itk::ImageBase< 5 >;
using itkImageBase5_Pointer = itk::ImageBase< 5 >::Pointer;
using itkImageRGBUC2 = itk::Image< itk::RGBPixel< unsigned char >,2 >;
using itkImageRGBUC2_Pointer = itk::Image< itk::RGBPixel< unsigned char >,2 >::Pointer;
using itkImageRGBUS2 = itk::Image< itk::RGBPixel< unsigned short >,2 >;
using itkImageRGBUS2_Pointer = itk::Image< itk::RGBPixel< unsigned short >,2 >::Pointer;
using itkImageRGBAUC2 = itk::Image< itk::RGBAPixel< unsigned char >,2 >;
using itkImageRGBAUC2_Pointer = itk::Image< itk::RGBAPixel< unsigned char >,2 >::Pointer;
using itkImageRGBAUS2 = itk::Image< itk::RGBAPixel< unsigned short >,2 >;
using itkImageRGBAUS2_Pointer = itk::Image< itk::RGBAPixel< unsigned short >,2 >::Pointer;
using itkImageVD22 = itk::Image< itk::Vector< double,2 >,2 >;
using itkImageVD22_Pointer = itk::Image< itk::Vector< double,2 >,2 >::Pointer;
using itkImageVD32 = itk::Image< itk::Vector< double,3 >,2 >;
using itkImageVD32_Pointer = itk::Image< itk::Vector< double,3 >,2 >::Pointer;
using itkImageVD42 = itk::Image< itk::Vector< double,4 >,2 >;
using itkImageVD42_Pointer = itk::Image< itk::Vector< double,4 >,2 >::Pointer;
using itkImageVF22 = itk::Image< itk::Vector< float,2 >,2 >;
using itkImageVF22_Pointer = itk::Image< itk::Vector< float,2 >,2 >::Pointer;
using itkImageVF32 = itk::Image< itk::Vector< float,3 >,2 >;
using itkImageVF32_Pointer = itk::Image< itk::Vector< float,3 >,2 >::Pointer;
using itkImageVF42 = itk::Image< itk::Vector< float,4 >,2 >;
using itkImageVF42_Pointer = itk::Image< itk::Vector< float,4 >,2 >::Pointer;
using itkImageCVD22 = itk::Image< itk::CovariantVector< double,2 >,2 >;
using itkImageCVD22_Pointer = itk::Image< itk::CovariantVector< double,2 >,2 >::Pointer;
using itkImageCVD32 = itk::Image< itk::CovariantVector< double,3 >,2 >;
using itkImageCVD32_Pointer = itk::Image< itk::CovariantVector< double,3 >,2 >::Pointer;
using itkImageCVD42 = itk::Image< itk::CovariantVector< double,4 >,2 >;
using itkImageCVD42_Pointer = itk::Image< itk::CovariantVector< double,4 >,2 >::Pointer;
using itkImageCVF22 = itk::Image< itk::CovariantVector< float,2 >,2 >;
using itkImageCVF22_Pointer = itk::Image< itk::CovariantVector< float,2 >,2 >::Pointer;
using itkImageCVF32 = itk::Image< itk::CovariantVector< float,3 >,2 >;
using itkImageCVF32_Pointer = itk::Image< itk::CovariantVector< float,3 >,2 >::Pointer;
using itkImageCVF42 = itk::Image< itk::CovariantVector< float,4 >,2 >;
using itkImageCVF42_Pointer = itk::Image< itk::CovariantVector< float,4 >,2 >::Pointer;
using itkImageSC2 = itk::Image< signed char,2 >;
using itkImageSC2_Pointer = itk::Image< signed char,2 >::Pointer;
using itkImageSS2 = itk::Image< signed short,2 >;
using itkImageSS2_Pointer = itk::Image< signed short,2 >::Pointer;
using itkImageUC2 = itk::Image< unsigned char,2 >;
using itkImageUC2_Pointer = itk::Image< unsigned char,2 >::Pointer;
using itkImageULL2 = itk::Image< unsigned long long,2 >;
using itkImageULL2_Pointer = itk::Image< unsigned long long,2 >::Pointer;
using itkImageUS2 = itk::Image< unsigned short,2 >;
using itkImageUS2_Pointer = itk::Image< unsigned short,2 >::Pointer;
using itkImageF2 = itk::Image< float,2 >;
using itkImageF2_Pointer = itk::Image< float,2 >::Pointer;
using itkImageD2 = itk::Image< double,2 >;
using itkImageD2_Pointer = itk::Image< double,2 >::Pointer;
using itkImageCD2 = itk::Image< std::complex< double >,2 >;
using itkImageCD2_Pointer = itk::Image< std::complex< double >,2 >::Pointer;
using itkImageCF2 = itk::Image< std::complex< float >,2 >;
using itkImageCF2_Pointer = itk::Image< std::complex< float >,2 >::Pointer;
using itkImageSI2 = itk::Image< signed int,2 >;
using itkImageSI2_Pointer = itk::Image< signed int,2 >::Pointer;
using itkImageUI2 = itk::Image< unsigned int,2 >;
using itkImageUI2_Pointer = itk::Image< unsigned int,2 >::Pointer;
using itkImageUL2 = itk::Image< unsigned long,2 >;
using itkImageUL2_Pointer = itk::Image< unsigned long,2 >::Pointer;
using itkImageB2 = itk::Image< bool,2 >;
using itkImageB2_Pointer = itk::Image< bool,2 >::Pointer;
using itkImageFAF22 = itk::Image< itk::FixedArray< float,2 >,2 >;
using itkImageFAF22_Pointer = itk::Image< itk::FixedArray< float,2 >,2 >::Pointer;
using itkImageFAD22 = itk::Image< itk::FixedArray< double,2 >,2 >;
using itkImageFAD22_Pointer = itk::Image< itk::FixedArray< double,2 >,2 >::Pointer;
using itkImageO22 = itk::Image< itk::Offset< 2 >,2 >;
using itkImageO22_Pointer = itk::Image< itk::Offset< 2 >,2 >::Pointer;
using itkImageSSRTD22 = itk::Image< itk::SymmetricSecondRankTensor< double, 2 >, 2 >;
using itkImageSSRTD22_Pointer = itk::Image< itk::SymmetricSecondRankTensor< double, 2 >, 2 >::Pointer;
using itkImageSSRTF22 = itk::Image< itk::SymmetricSecondRankTensor< float, 2 >, 2 >;
using itkImageSSRTF22_Pointer = itk::Image< itk::SymmetricSecondRankTensor< float, 2 >, 2 >::Pointer;
using itkImageRGBUC3 = itk::Image< itk::RGBPixel< unsigned char >,3 >;
using itkImageRGBUC3_Pointer = itk::Image< itk::RGBPixel< unsigned char >,3 >::Pointer;
using itkImageRGBUS3 = itk::Image< itk::RGBPixel< unsigned short >,3 >;
using itkImageRGBUS3_Pointer = itk::Image< itk::RGBPixel< unsigned short >,3 >::Pointer;
using itkImageRGBAUC3 = itk::Image< itk::RGBAPixel< unsigned char >,3 >;
using itkImageRGBAUC3_Pointer = itk::Image< itk::RGBAPixel< unsigned char >,3 >::Pointer;
using itkImageRGBAUS3 = itk::Image< itk::RGBAPixel< unsigned short >,3 >;
using itkImageRGBAUS3_Pointer = itk::Image< itk::RGBAPixel< unsigned short >,3 >::Pointer;
using itkImageVD23 = itk::Image< itk::Vector< double,2 >,3 >;
using itkImageVD23_Pointer = itk::Image< itk::Vector< double,2 >,3 >::Pointer;
using itkImageVD33 = itk::Image< itk::Vector< double,3 >,3 >;
using itkImageVD33_Pointer = itk::Image< itk::Vector< double,3 >,3 >::Pointer;
using itkImageVD43 = itk::Image< itk::Vector< double,4 >,3 >;
using itkImageVD43_Pointer = itk::Image< itk::Vector< double,4 >,3 >::Pointer;
using itkImageVF23 = itk::Image< itk::Vector< float,2 >,3 >;
using itkImageVF23_Pointer = itk::Image< itk::Vector< float,2 >,3 >::Pointer;
using itkImageVF33 = itk::Image< itk::Vector< float,3 >,3 >;
using itkImageVF33_Pointer = itk::Image< itk::Vector< float,3 >,3 >::Pointer;
using itkImageVF43 = itk::Image< itk::Vector< float,4 >,3 >;
using itkImageVF43_Pointer = itk::Image< itk::Vector< float,4 >,3 >::Pointer;
using itkImageCVD23 = itk::Image< itk::CovariantVector< double,2 >,3 >;
using itkImageCVD23_Pointer = itk::Image< itk::CovariantVector< double,2 >,3 >::Pointer;
using itkImageCVD33 = itk::Image< itk::CovariantVector< double,3 >,3 >;
using itkImageCVD33_Pointer = itk::Image< itk::CovariantVector< double,3 >,3 >::Pointer;
using itkImageCVD43 = itk::Image< itk::CovariantVector< double,4 >,3 >;
using itkImageCVD43_Pointer = itk::Image< itk::CovariantVector< double,4 >,3 >::Pointer;
using itkImageCVF23 = itk::Image< itk::CovariantVector< float,2 >,3 >;
using itkImageCVF23_Pointer = itk::Image< itk::CovariantVector< float,2 >,3 >::Pointer;
using itkImageCVF33 = itk::Image< itk::CovariantVector< float,3 >,3 >;
using itkImageCVF33_Pointer = itk::Image< itk::CovariantVector< float,3 >,3 >::Pointer;
using itkImageCVF43 = itk::Image< itk::CovariantVector< float,4 >,3 >;
using itkImageCVF43_Pointer = itk::Image< itk::CovariantVector< float,4 >,3 >::Pointer;
using itkImageSC3 = itk::Image< signed char,3 >;
using itkImageSC3_Pointer = itk::Image< signed char,3 >::Pointer;
using itkImageSS3 = itk::Image< signed short,3 >;
using itkImageSS3_Pointer = itk::Image< signed short,3 >::Pointer;
using itkImageUC3 = itk::Image< unsigned char,3 >;
using itkImageUC3_Pointer = itk::Image< unsigned char,3 >::Pointer;
using itkImageULL3 = itk::Image< unsigned long long,3 >;
using itkImageULL3_Pointer = itk::Image< unsigned long long,3 >::Pointer;
using itkImageUS3 = itk::Image< unsigned short,3 >;
using itkImageUS3_Pointer = itk::Image< unsigned short,3 >::Pointer;
using itkImageF3 = itk::Image< float,3 >;
using itkImageF3_Pointer = itk::Image< float,3 >::Pointer;
using itkImageD3 = itk::Image< double,3 >;
using itkImageD3_Pointer = itk::Image< double,3 >::Pointer;
using itkImageCD3 = itk::Image< std::complex< double >,3 >;
using itkImageCD3_Pointer = itk::Image< std::complex< double >,3 >::Pointer;
using itkImageCF3 = itk::Image< std::complex< float >,3 >;
using itkImageCF3_Pointer = itk::Image< std::complex< float >,3 >::Pointer;
using itkImageSI3 = itk::Image< signed int,3 >;
using itkImageSI3_Pointer = itk::Image< signed int,3 >::Pointer;
using itkImageUI3 = itk::Image< unsigned int,3 >;
using itkImageUI3_Pointer = itk::Image< unsigned int,3 >::Pointer;
using itkImageUL3 = itk::Image< unsigned long,3 >;
using itkImageUL3_Pointer = itk::Image< unsigned long,3 >::Pointer;
using itkImageB3 = itk::Image< bool,3 >;
using itkImageB3_Pointer = itk::Image< bool,3 >::Pointer;
using itkImageFAF33 = itk::Image< itk::FixedArray< float,3 >,3 >;
using itkImageFAF33_Pointer = itk::Image< itk::FixedArray< float,3 >,3 >::Pointer;
using itkImageFAD33 = itk::Image< itk::FixedArray< double,3 >,3 >;
using itkImageFAD33_Pointer = itk::Image< itk::FixedArray< double,3 >,3 >::Pointer;
using itkImageO33 = itk::Image< itk::Offset< 3 >,3 >;
using itkImageO33_Pointer = itk::Image< itk::Offset< 3 >,3 >::Pointer;
using itkImageSSRTD33 = itk::Image< itk::SymmetricSecondRankTensor< double, 3 >, 3 >;
using itkImageSSRTD33_Pointer = itk::Image< itk::SymmetricSecondRankTensor< double, 3 >, 3 >::Pointer;
using itkImageSSRTF33 = itk::Image< itk::SymmetricSecondRankTensor< float, 3 >, 3 >;
using itkImageSSRTF33_Pointer = itk::Image< itk::SymmetricSecondRankTensor< float, 3 >, 3 >::Pointer;
using itkImageRGBUC4 = itk::Image< itk::RGBPixel< unsigned char >,4 >;
using itkImageRGBUC4_Pointer = itk::Image< itk::RGBPixel< unsigned char >,4 >::Pointer;
using itkImageRGBUS4 = itk::Image< itk::RGBPixel< unsigned short >,4 >;
using itkImageRGBUS4_Pointer = itk::Image< itk::RGBPixel< unsigned short >,4 >::Pointer;
using itkImageRGBAUC4 = itk::Image< itk::RGBAPixel< unsigned char >,4 >;
using itkImageRGBAUC4_Pointer = itk::Image< itk::RGBAPixel< unsigned char >,4 >::Pointer;
using itkImageRGBAUS4 = itk::Image< itk::RGBAPixel< unsigned short >,4 >;
using itkImageRGBAUS4_Pointer = itk::Image< itk::RGBAPixel< unsigned short >,4 >::Pointer;
using itkImageVD24 = itk::Image< itk::Vector< double,2 >,4 >;
using itkImageVD24_Pointer = itk::Image< itk::Vector< double,2 >,4 >::Pointer;
using itkImageVD34 = itk::Image< itk::Vector< double,3 >,4 >;
using itkImageVD34_Pointer = itk::Image< itk::Vector< double,3 >,4 >::Pointer;
using itkImageVD44 = itk::Image< itk::Vector< double,4 >,4 >;
using itkImageVD44_Pointer = itk::Image< itk::Vector< double,4 >,4 >::Pointer;
using itkImageVF24 = itk::Image< itk::Vector< float,2 >,4 >;
using itkImageVF24_Pointer = itk::Image< itk::Vector< float,2 >,4 >::Pointer;
using itkImageVF34 = itk::Image< itk::Vector< float,3 >,4 >;
using itkImageVF34_Pointer = itk::Image< itk::Vector< float,3 >,4 >::Pointer;
using itkImageVF44 = itk::Image< itk::Vector< float,4 >,4 >;
using itkImageVF44_Pointer = itk::Image< itk::Vector< float,4 >,4 >::Pointer;
using itkImageCVD24 = itk::Image< itk::CovariantVector< double,2 >,4 >;
using itkImageCVD24_Pointer = itk::Image< itk::CovariantVector< double,2 >,4 >::Pointer;
using itkImageCVD34 = itk::Image< itk::CovariantVector< double,3 >,4 >;
using itkImageCVD34_Pointer = itk::Image< itk::CovariantVector< double,3 >,4 >::Pointer;
using itkImageCVD44 = itk::Image< itk::CovariantVector< double,4 >,4 >;
using itkImageCVD44_Pointer = itk::Image< itk::CovariantVector< double,4 >,4 >::Pointer;
using itkImageCVF24 = itk::Image< itk::CovariantVector< float,2 >,4 >;
using itkImageCVF24_Pointer = itk::Image< itk::CovariantVector< float,2 >,4 >::Pointer;
using itkImageCVF34 = itk::Image< itk::CovariantVector< float,3 >,4 >;
using itkImageCVF34_Pointer = itk::Image< itk::CovariantVector< float,3 >,4 >::Pointer;
using itkImageCVF44 = itk::Image< itk::CovariantVector< float,4 >,4 >;
using itkImageCVF44_Pointer = itk::Image< itk::CovariantVector< float,4 >,4 >::Pointer;
using itkImageSC4 = itk::Image< signed char,4 >;
using itkImageSC4_Pointer = itk::Image< signed char,4 >::Pointer;
using itkImageSS4 = itk::Image< signed short,4 >;
using itkImageSS4_Pointer = itk::Image< signed short,4 >::Pointer;
using itkImageUC4 = itk::Image< unsigned char,4 >;
using itkImageUC4_Pointer = itk::Image< unsigned char,4 >::Pointer;
using itkImageULL4 = itk::Image< unsigned long long,4 >;
using itkImageULL4_Pointer = itk::Image< unsigned long long,4 >::Pointer;
using itkImageUS4 = itk::Image< unsigned short,4 >;
using itkImageUS4_Pointer = itk::Image< unsigned short,4 >::Pointer;
using itkImageF4 = itk::Image< float,4 >;
using itkImageF4_Pointer = itk::Image< float,4 >::Pointer;
using itkImageD4 = itk::Image< double,4 >;
using itkImageD4_Pointer = itk::Image< double,4 >::Pointer;
using itkImageCD4 = itk::Image< std::complex< double >,4 >;
using itkImageCD4_Pointer = itk::Image< std::complex< double >,4 >::Pointer;
using itkImageCF4 = itk::Image< std::complex< float >,4 >;
using itkImageCF4_Pointer = itk::Image< std::complex< float >,4 >::Pointer;
using itkImageSI4 = itk::Image< signed int,4 >;
using itkImageSI4_Pointer = itk::Image< signed int,4 >::Pointer;
using itkImageUI4 = itk::Image< unsigned int,4 >;
using itkImageUI4_Pointer = itk::Image< unsigned int,4 >::Pointer;
using itkImageUL4 = itk::Image< unsigned long,4 >;
using itkImageUL4_Pointer = itk::Image< unsigned long,4 >::Pointer;
using itkImageB4 = itk::Image< bool,4 >;
using itkImageB4_Pointer = itk::Image< bool,4 >::Pointer;
using itkImageFAF44 = itk::Image< itk::FixedArray< float,4 >,4 >;
using itkImageFAF44_Pointer = itk::Image< itk::FixedArray< float,4 >,4 >::Pointer;
using itkImageFAD44 = itk::Image< itk::FixedArray< double,4 >,4 >;
using itkImageFAD44_Pointer = itk::Image< itk::FixedArray< double,4 >,4 >::Pointer;
using itkImageO44 = itk::Image< itk::Offset< 4 >,4 >;
using itkImageO44_Pointer = itk::Image< itk::Offset< 4 >,4 >::Pointer;
using itkImageSSRTD44 = itk::Image< itk::SymmetricSecondRankTensor< double, 4 >, 4 >;
using itkImageSSRTD44_Pointer = itk::Image< itk::SymmetricSecondRankTensor< double, 4 >, 4 >::Pointer;
using itkImageSSRTF44 = itk::Image< itk::SymmetricSecondRankTensor< float, 4 >, 4 >;
using itkImageSSRTF44_Pointer = itk::Image< itk::SymmetricSecondRankTensor< float, 4 >, 4 >::Pointer;
using itkImageVF12 = itk::Image< itk::Vector< float,1 >,2 >;
using itkImageVF12_Pointer = itk::Image< itk::Vector< float,1 >,2 >::Pointer;
using itkImageVF13 = itk::Image< itk::Vector< float,1 >,3 >;
using itkImageVF13_Pointer = itk::Image< itk::Vector< float,1 >,3 >::Pointer;
using itkImageVD25 = itk::Image< itk::Vector< double,2 >,5 >;
using itkImageVD25_Pointer = itk::Image< itk::Vector< double,2 >,5 >::Pointer;
using itkImageVD35 = itk::Image< itk::Vector< double,3 >,5 >;
using itkImageVD35_Pointer = itk::Image< itk::Vector< double,3 >,5 >::Pointer;
using itkImageVD45 = itk::Image< itk::Vector< double,4 >,5 >;
using itkImageVD45_Pointer = itk::Image< itk::Vector< double,4 >,5 >::Pointer;
using itkImageVF14 = itk::Image< itk::Vector< float,1 >,4 >;
using itkImageVF14_Pointer = itk::Image< itk::Vector< float,1 >,4 >::Pointer;


#include "itkSymmetricSecondRankTensorSwigInterface.h"
#include "stdcomplexSwigInterface.h"
#include "ITKCommonBaseSwigInterface.h"
#include "itkImageSwigInterface.h"
#include "itkFixedArraySwigInterface.h"
#include "itkVectorSwigInterface.h"
#include "itkImageRegionSwigInterface.h"
#include "itkRGBPixelSwigInterface.h"
#include "itkSizeSwigInterface.h"
#include "itkCovariantVectorSwigInterface.h"
#include "itkOffsetSwigInterface.h"
#include "itkPointSwigInterface.h"
#include "itkMatrixSwigInterface.h"
#include "itkIndexSwigInterface.h"
#include "itkRGBAPixelSwigInterface.h"
#endif
