#ifndef itkImageSinkSwigInterface_h
#define itkImageSinkSwigInterface_h
#include "itkCommand.h"
#include "itkOffset.h"
#include "itkVector.h"
#include "itkCovariantVector.h"
#include "itkContinuousIndex.h"
#include "itkArray.h"
#include "itkFixedArray.h"
#include "itkRGBPixel.h"
#include "itkRGBAPixel.h"
#include "complex"
#include "itkSymmetricSecondRankTensor.h"
#include "itkImage.h"
#include "itkVectorImage.h"
#include "itkVariableLengthVector.h"
#include "itkPoint.h"
#include "itkImageSink.h"

using itkImageSinkIRGBUC2 = itk::ImageSink< itk::Image< itk::RGBPixel< unsigned char >,2 > >;
using itkImageSinkIRGBUC2_Pointer = itk::ImageSink< itk::Image< itk::RGBPixel< unsigned char >,2 > >::Pointer;
using itkImageSinkIRGBUC3 = itk::ImageSink< itk::Image< itk::RGBPixel< unsigned char >,3 > >;
using itkImageSinkIRGBUC3_Pointer = itk::ImageSink< itk::Image< itk::RGBPixel< unsigned char >,3 > >::Pointer;
using itkImageSinkIRGBUC4 = itk::ImageSink< itk::Image< itk::RGBPixel< unsigned char >,4 > >;
using itkImageSinkIRGBUC4_Pointer = itk::ImageSink< itk::Image< itk::RGBPixel< unsigned char >,4 > >::Pointer;
using itkImageSinkIRGBUS2 = itk::ImageSink< itk::Image< itk::RGBPixel< unsigned short >,2 > >;
using itkImageSinkIRGBUS2_Pointer = itk::ImageSink< itk::Image< itk::RGBPixel< unsigned short >,2 > >::Pointer;
using itkImageSinkIRGBUS3 = itk::ImageSink< itk::Image< itk::RGBPixel< unsigned short >,3 > >;
using itkImageSinkIRGBUS3_Pointer = itk::ImageSink< itk::Image< itk::RGBPixel< unsigned short >,3 > >::Pointer;
using itkImageSinkIRGBUS4 = itk::ImageSink< itk::Image< itk::RGBPixel< unsigned short >,4 > >;
using itkImageSinkIRGBUS4_Pointer = itk::ImageSink< itk::Image< itk::RGBPixel< unsigned short >,4 > >::Pointer;
using itkImageSinkIRGBAUC2 = itk::ImageSink< itk::Image< itk::RGBAPixel< unsigned char >,2 > >;
using itkImageSinkIRGBAUC2_Pointer = itk::ImageSink< itk::Image< itk::RGBAPixel< unsigned char >,2 > >::Pointer;
using itkImageSinkIRGBAUC3 = itk::ImageSink< itk::Image< itk::RGBAPixel< unsigned char >,3 > >;
using itkImageSinkIRGBAUC3_Pointer = itk::ImageSink< itk::Image< itk::RGBAPixel< unsigned char >,3 > >::Pointer;
using itkImageSinkIRGBAUC4 = itk::ImageSink< itk::Image< itk::RGBAPixel< unsigned char >,4 > >;
using itkImageSinkIRGBAUC4_Pointer = itk::ImageSink< itk::Image< itk::RGBAPixel< unsigned char >,4 > >::Pointer;
using itkImageSinkIRGBAUS2 = itk::ImageSink< itk::Image< itk::RGBAPixel< unsigned short >,2 > >;
using itkImageSinkIRGBAUS2_Pointer = itk::ImageSink< itk::Image< itk::RGBAPixel< unsigned short >,2 > >::Pointer;
using itkImageSinkIRGBAUS3 = itk::ImageSink< itk::Image< itk::RGBAPixel< unsigned short >,3 > >;
using itkImageSinkIRGBAUS3_Pointer = itk::ImageSink< itk::Image< itk::RGBAPixel< unsigned short >,3 > >::Pointer;
using itkImageSinkIRGBAUS4 = itk::ImageSink< itk::Image< itk::RGBAPixel< unsigned short >,4 > >;
using itkImageSinkIRGBAUS4_Pointer = itk::ImageSink< itk::Image< itk::RGBAPixel< unsigned short >,4 > >::Pointer;
using itkImageSinkIVD22 = itk::ImageSink< itk::Image< itk::Vector< double,2 >,2 > >;
using itkImageSinkIVD22_Pointer = itk::ImageSink< itk::Image< itk::Vector< double,2 >,2 > >::Pointer;
using itkImageSinkIVD23 = itk::ImageSink< itk::Image< itk::Vector< double,2 >,3 > >;
using itkImageSinkIVD23_Pointer = itk::ImageSink< itk::Image< itk::Vector< double,2 >,3 > >::Pointer;
using itkImageSinkIVD24 = itk::ImageSink< itk::Image< itk::Vector< double,2 >,4 > >;
using itkImageSinkIVD24_Pointer = itk::ImageSink< itk::Image< itk::Vector< double,2 >,4 > >::Pointer;
using itkImageSinkIVD32 = itk::ImageSink< itk::Image< itk::Vector< double,3 >,2 > >;
using itkImageSinkIVD32_Pointer = itk::ImageSink< itk::Image< itk::Vector< double,3 >,2 > >::Pointer;
using itkImageSinkIVD33 = itk::ImageSink< itk::Image< itk::Vector< double,3 >,3 > >;
using itkImageSinkIVD33_Pointer = itk::ImageSink< itk::Image< itk::Vector< double,3 >,3 > >::Pointer;
using itkImageSinkIVD34 = itk::ImageSink< itk::Image< itk::Vector< double,3 >,4 > >;
using itkImageSinkIVD34_Pointer = itk::ImageSink< itk::Image< itk::Vector< double,3 >,4 > >::Pointer;
using itkImageSinkIVD42 = itk::ImageSink< itk::Image< itk::Vector< double,4 >,2 > >;
using itkImageSinkIVD42_Pointer = itk::ImageSink< itk::Image< itk::Vector< double,4 >,2 > >::Pointer;
using itkImageSinkIVD43 = itk::ImageSink< itk::Image< itk::Vector< double,4 >,3 > >;
using itkImageSinkIVD43_Pointer = itk::ImageSink< itk::Image< itk::Vector< double,4 >,3 > >::Pointer;
using itkImageSinkIVD44 = itk::ImageSink< itk::Image< itk::Vector< double,4 >,4 > >;
using itkImageSinkIVD44_Pointer = itk::ImageSink< itk::Image< itk::Vector< double,4 >,4 > >::Pointer;
using itkImageSinkIVF22 = itk::ImageSink< itk::Image< itk::Vector< float,2 >,2 > >;
using itkImageSinkIVF22_Pointer = itk::ImageSink< itk::Image< itk::Vector< float,2 >,2 > >::Pointer;
using itkImageSinkIVF23 = itk::ImageSink< itk::Image< itk::Vector< float,2 >,3 > >;
using itkImageSinkIVF23_Pointer = itk::ImageSink< itk::Image< itk::Vector< float,2 >,3 > >::Pointer;
using itkImageSinkIVF24 = itk::ImageSink< itk::Image< itk::Vector< float,2 >,4 > >;
using itkImageSinkIVF24_Pointer = itk::ImageSink< itk::Image< itk::Vector< float,2 >,4 > >::Pointer;
using itkImageSinkIVF32 = itk::ImageSink< itk::Image< itk::Vector< float,3 >,2 > >;
using itkImageSinkIVF32_Pointer = itk::ImageSink< itk::Image< itk::Vector< float,3 >,2 > >::Pointer;
using itkImageSinkIVF33 = itk::ImageSink< itk::Image< itk::Vector< float,3 >,3 > >;
using itkImageSinkIVF33_Pointer = itk::ImageSink< itk::Image< itk::Vector< float,3 >,3 > >::Pointer;
using itkImageSinkIVF34 = itk::ImageSink< itk::Image< itk::Vector< float,3 >,4 > >;
using itkImageSinkIVF34_Pointer = itk::ImageSink< itk::Image< itk::Vector< float,3 >,4 > >::Pointer;
using itkImageSinkIVF42 = itk::ImageSink< itk::Image< itk::Vector< float,4 >,2 > >;
using itkImageSinkIVF42_Pointer = itk::ImageSink< itk::Image< itk::Vector< float,4 >,2 > >::Pointer;
using itkImageSinkIVF43 = itk::ImageSink< itk::Image< itk::Vector< float,4 >,3 > >;
using itkImageSinkIVF43_Pointer = itk::ImageSink< itk::Image< itk::Vector< float,4 >,3 > >::Pointer;
using itkImageSinkIVF44 = itk::ImageSink< itk::Image< itk::Vector< float,4 >,4 > >;
using itkImageSinkIVF44_Pointer = itk::ImageSink< itk::Image< itk::Vector< float,4 >,4 > >::Pointer;
using itkImageSinkICVD22 = itk::ImageSink< itk::Image< itk::CovariantVector< double,2 >,2 > >;
using itkImageSinkICVD22_Pointer = itk::ImageSink< itk::Image< itk::CovariantVector< double,2 >,2 > >::Pointer;
using itkImageSinkICVD23 = itk::ImageSink< itk::Image< itk::CovariantVector< double,2 >,3 > >;
using itkImageSinkICVD23_Pointer = itk::ImageSink< itk::Image< itk::CovariantVector< double,2 >,3 > >::Pointer;
using itkImageSinkICVD24 = itk::ImageSink< itk::Image< itk::CovariantVector< double,2 >,4 > >;
using itkImageSinkICVD24_Pointer = itk::ImageSink< itk::Image< itk::CovariantVector< double,2 >,4 > >::Pointer;
using itkImageSinkICVD32 = itk::ImageSink< itk::Image< itk::CovariantVector< double,3 >,2 > >;
using itkImageSinkICVD32_Pointer = itk::ImageSink< itk::Image< itk::CovariantVector< double,3 >,2 > >::Pointer;
using itkImageSinkICVD33 = itk::ImageSink< itk::Image< itk::CovariantVector< double,3 >,3 > >;
using itkImageSinkICVD33_Pointer = itk::ImageSink< itk::Image< itk::CovariantVector< double,3 >,3 > >::Pointer;
using itkImageSinkICVD34 = itk::ImageSink< itk::Image< itk::CovariantVector< double,3 >,4 > >;
using itkImageSinkICVD34_Pointer = itk::ImageSink< itk::Image< itk::CovariantVector< double,3 >,4 > >::Pointer;
using itkImageSinkICVD42 = itk::ImageSink< itk::Image< itk::CovariantVector< double,4 >,2 > >;
using itkImageSinkICVD42_Pointer = itk::ImageSink< itk::Image< itk::CovariantVector< double,4 >,2 > >::Pointer;
using itkImageSinkICVD43 = itk::ImageSink< itk::Image< itk::CovariantVector< double,4 >,3 > >;
using itkImageSinkICVD43_Pointer = itk::ImageSink< itk::Image< itk::CovariantVector< double,4 >,3 > >::Pointer;
using itkImageSinkICVD44 = itk::ImageSink< itk::Image< itk::CovariantVector< double,4 >,4 > >;
using itkImageSinkICVD44_Pointer = itk::ImageSink< itk::Image< itk::CovariantVector< double,4 >,4 > >::Pointer;
using itkImageSinkICVF22 = itk::ImageSink< itk::Image< itk::CovariantVector< float,2 >,2 > >;
using itkImageSinkICVF22_Pointer = itk::ImageSink< itk::Image< itk::CovariantVector< float,2 >,2 > >::Pointer;
using itkImageSinkICVF23 = itk::ImageSink< itk::Image< itk::CovariantVector< float,2 >,3 > >;
using itkImageSinkICVF23_Pointer = itk::ImageSink< itk::Image< itk::CovariantVector< float,2 >,3 > >::Pointer;
using itkImageSinkICVF24 = itk::ImageSink< itk::Image< itk::CovariantVector< float,2 >,4 > >;
using itkImageSinkICVF24_Pointer = itk::ImageSink< itk::Image< itk::CovariantVector< float,2 >,4 > >::Pointer;
using itkImageSinkICVF32 = itk::ImageSink< itk::Image< itk::CovariantVector< float,3 >,2 > >;
using itkImageSinkICVF32_Pointer = itk::ImageSink< itk::Image< itk::CovariantVector< float,3 >,2 > >::Pointer;
using itkImageSinkICVF33 = itk::ImageSink< itk::Image< itk::CovariantVector< float,3 >,3 > >;
using itkImageSinkICVF33_Pointer = itk::ImageSink< itk::Image< itk::CovariantVector< float,3 >,3 > >::Pointer;
using itkImageSinkICVF34 = itk::ImageSink< itk::Image< itk::CovariantVector< float,3 >,4 > >;
using itkImageSinkICVF34_Pointer = itk::ImageSink< itk::Image< itk::CovariantVector< float,3 >,4 > >::Pointer;
using itkImageSinkICVF42 = itk::ImageSink< itk::Image< itk::CovariantVector< float,4 >,2 > >;
using itkImageSinkICVF42_Pointer = itk::ImageSink< itk::Image< itk::CovariantVector< float,4 >,2 > >::Pointer;
using itkImageSinkICVF43 = itk::ImageSink< itk::Image< itk::CovariantVector< float,4 >,3 > >;
using itkImageSinkICVF43_Pointer = itk::ImageSink< itk::Image< itk::CovariantVector< float,4 >,3 > >::Pointer;
using itkImageSinkICVF44 = itk::ImageSink< itk::Image< itk::CovariantVector< float,4 >,4 > >;
using itkImageSinkICVF44_Pointer = itk::ImageSink< itk::Image< itk::CovariantVector< float,4 >,4 > >::Pointer;
using itkImageSinkISC2 = itk::ImageSink< itk::Image< signed char,2 > >;
using itkImageSinkISC2_Pointer = itk::ImageSink< itk::Image< signed char,2 > >::Pointer;
using itkImageSinkISC3 = itk::ImageSink< itk::Image< signed char,3 > >;
using itkImageSinkISC3_Pointer = itk::ImageSink< itk::Image< signed char,3 > >::Pointer;
using itkImageSinkISC4 = itk::ImageSink< itk::Image< signed char,4 > >;
using itkImageSinkISC4_Pointer = itk::ImageSink< itk::Image< signed char,4 > >::Pointer;
using itkImageSinkISS2 = itk::ImageSink< itk::Image< signed short,2 > >;
using itkImageSinkISS2_Pointer = itk::ImageSink< itk::Image< signed short,2 > >::Pointer;
using itkImageSinkISS3 = itk::ImageSink< itk::Image< signed short,3 > >;
using itkImageSinkISS3_Pointer = itk::ImageSink< itk::Image< signed short,3 > >::Pointer;
using itkImageSinkISS4 = itk::ImageSink< itk::Image< signed short,4 > >;
using itkImageSinkISS4_Pointer = itk::ImageSink< itk::Image< signed short,4 > >::Pointer;
using itkImageSinkIUC2 = itk::ImageSink< itk::Image< unsigned char,2 > >;
using itkImageSinkIUC2_Pointer = itk::ImageSink< itk::Image< unsigned char,2 > >::Pointer;
using itkImageSinkIUC3 = itk::ImageSink< itk::Image< unsigned char,3 > >;
using itkImageSinkIUC3_Pointer = itk::ImageSink< itk::Image< unsigned char,3 > >::Pointer;
using itkImageSinkIUC4 = itk::ImageSink< itk::Image< unsigned char,4 > >;
using itkImageSinkIUC4_Pointer = itk::ImageSink< itk::Image< unsigned char,4 > >::Pointer;
using itkImageSinkIULL2 = itk::ImageSink< itk::Image< unsigned long long,2 > >;
using itkImageSinkIULL2_Pointer = itk::ImageSink< itk::Image< unsigned long long,2 > >::Pointer;
using itkImageSinkIULL3 = itk::ImageSink< itk::Image< unsigned long long,3 > >;
using itkImageSinkIULL3_Pointer = itk::ImageSink< itk::Image< unsigned long long,3 > >::Pointer;
using itkImageSinkIULL4 = itk::ImageSink< itk::Image< unsigned long long,4 > >;
using itkImageSinkIULL4_Pointer = itk::ImageSink< itk::Image< unsigned long long,4 > >::Pointer;
using itkImageSinkIUS2 = itk::ImageSink< itk::Image< unsigned short,2 > >;
using itkImageSinkIUS2_Pointer = itk::ImageSink< itk::Image< unsigned short,2 > >::Pointer;
using itkImageSinkIUS3 = itk::ImageSink< itk::Image< unsigned short,3 > >;
using itkImageSinkIUS3_Pointer = itk::ImageSink< itk::Image< unsigned short,3 > >::Pointer;
using itkImageSinkIUS4 = itk::ImageSink< itk::Image< unsigned short,4 > >;
using itkImageSinkIUS4_Pointer = itk::ImageSink< itk::Image< unsigned short,4 > >::Pointer;
using itkImageSinkIF2 = itk::ImageSink< itk::Image< float,2 > >;
using itkImageSinkIF2_Pointer = itk::ImageSink< itk::Image< float,2 > >::Pointer;
using itkImageSinkIF3 = itk::ImageSink< itk::Image< float,3 > >;
using itkImageSinkIF3_Pointer = itk::ImageSink< itk::Image< float,3 > >::Pointer;
using itkImageSinkIF4 = itk::ImageSink< itk::Image< float,4 > >;
using itkImageSinkIF4_Pointer = itk::ImageSink< itk::Image< float,4 > >::Pointer;
using itkImageSinkID2 = itk::ImageSink< itk::Image< double,2 > >;
using itkImageSinkID2_Pointer = itk::ImageSink< itk::Image< double,2 > >::Pointer;
using itkImageSinkID3 = itk::ImageSink< itk::Image< double,3 > >;
using itkImageSinkID3_Pointer = itk::ImageSink< itk::Image< double,3 > >::Pointer;
using itkImageSinkID4 = itk::ImageSink< itk::Image< double,4 > >;
using itkImageSinkID4_Pointer = itk::ImageSink< itk::Image< double,4 > >::Pointer;
using itkImageSinkICD2 = itk::ImageSink< itk::Image< std::complex< double >,2 > >;
using itkImageSinkICD2_Pointer = itk::ImageSink< itk::Image< std::complex< double >,2 > >::Pointer;
using itkImageSinkICD3 = itk::ImageSink< itk::Image< std::complex< double >,3 > >;
using itkImageSinkICD3_Pointer = itk::ImageSink< itk::Image< std::complex< double >,3 > >::Pointer;
using itkImageSinkICD4 = itk::ImageSink< itk::Image< std::complex< double >,4 > >;
using itkImageSinkICD4_Pointer = itk::ImageSink< itk::Image< std::complex< double >,4 > >::Pointer;
using itkImageSinkICF2 = itk::ImageSink< itk::Image< std::complex< float >,2 > >;
using itkImageSinkICF2_Pointer = itk::ImageSink< itk::Image< std::complex< float >,2 > >::Pointer;
using itkImageSinkICF3 = itk::ImageSink< itk::Image< std::complex< float >,3 > >;
using itkImageSinkICF3_Pointer = itk::ImageSink< itk::Image< std::complex< float >,3 > >::Pointer;
using itkImageSinkICF4 = itk::ImageSink< itk::Image< std::complex< float >,4 > >;
using itkImageSinkICF4_Pointer = itk::ImageSink< itk::Image< std::complex< float >,4 > >::Pointer;
using itkImageSinkVISC2 = itk::ImageSink< itk::VectorImage< signed char,2 > >;
using itkImageSinkVISC2_Pointer = itk::ImageSink< itk::VectorImage< signed char,2 > >::Pointer;
using itkImageSinkVISS2 = itk::ImageSink< itk::VectorImage< signed short,2 > >;
using itkImageSinkVISS2_Pointer = itk::ImageSink< itk::VectorImage< signed short,2 > >::Pointer;
using itkImageSinkVIUC2 = itk::ImageSink< itk::VectorImage< unsigned char,2 > >;
using itkImageSinkVIUC2_Pointer = itk::ImageSink< itk::VectorImage< unsigned char,2 > >::Pointer;
using itkImageSinkVIULL2 = itk::ImageSink< itk::VectorImage< unsigned long long,2 > >;
using itkImageSinkVIULL2_Pointer = itk::ImageSink< itk::VectorImage< unsigned long long,2 > >::Pointer;
using itkImageSinkVIUS2 = itk::ImageSink< itk::VectorImage< unsigned short,2 > >;
using itkImageSinkVIUS2_Pointer = itk::ImageSink< itk::VectorImage< unsigned short,2 > >::Pointer;
using itkImageSinkVIF2 = itk::ImageSink< itk::VectorImage< float,2 > >;
using itkImageSinkVIF2_Pointer = itk::ImageSink< itk::VectorImage< float,2 > >::Pointer;
using itkImageSinkVID2 = itk::ImageSink< itk::VectorImage< double,2 > >;
using itkImageSinkVID2_Pointer = itk::ImageSink< itk::VectorImage< double,2 > >::Pointer;
using itkImageSinkVISC3 = itk::ImageSink< itk::VectorImage< signed char,3 > >;
using itkImageSinkVISC3_Pointer = itk::ImageSink< itk::VectorImage< signed char,3 > >::Pointer;
using itkImageSinkVISS3 = itk::ImageSink< itk::VectorImage< signed short,3 > >;
using itkImageSinkVISS3_Pointer = itk::ImageSink< itk::VectorImage< signed short,3 > >::Pointer;
using itkImageSinkVIUC3 = itk::ImageSink< itk::VectorImage< unsigned char,3 > >;
using itkImageSinkVIUC3_Pointer = itk::ImageSink< itk::VectorImage< unsigned char,3 > >::Pointer;
using itkImageSinkVIULL3 = itk::ImageSink< itk::VectorImage< unsigned long long,3 > >;
using itkImageSinkVIULL3_Pointer = itk::ImageSink< itk::VectorImage< unsigned long long,3 > >::Pointer;
using itkImageSinkVIUS3 = itk::ImageSink< itk::VectorImage< unsigned short,3 > >;
using itkImageSinkVIUS3_Pointer = itk::ImageSink< itk::VectorImage< unsigned short,3 > >::Pointer;
using itkImageSinkVIF3 = itk::ImageSink< itk::VectorImage< float,3 > >;
using itkImageSinkVIF3_Pointer = itk::ImageSink< itk::VectorImage< float,3 > >::Pointer;
using itkImageSinkVID3 = itk::ImageSink< itk::VectorImage< double,3 > >;
using itkImageSinkVID3_Pointer = itk::ImageSink< itk::VectorImage< double,3 > >::Pointer;
using itkImageSinkVISC4 = itk::ImageSink< itk::VectorImage< signed char,4 > >;
using itkImageSinkVISC4_Pointer = itk::ImageSink< itk::VectorImage< signed char,4 > >::Pointer;
using itkImageSinkVISS4 = itk::ImageSink< itk::VectorImage< signed short,4 > >;
using itkImageSinkVISS4_Pointer = itk::ImageSink< itk::VectorImage< signed short,4 > >::Pointer;
using itkImageSinkVIUC4 = itk::ImageSink< itk::VectorImage< unsigned char,4 > >;
using itkImageSinkVIUC4_Pointer = itk::ImageSink< itk::VectorImage< unsigned char,4 > >::Pointer;
using itkImageSinkVIULL4 = itk::ImageSink< itk::VectorImage< unsigned long long,4 > >;
using itkImageSinkVIULL4_Pointer = itk::ImageSink< itk::VectorImage< unsigned long long,4 > >::Pointer;
using itkImageSinkVIUS4 = itk::ImageSink< itk::VectorImage< unsigned short,4 > >;
using itkImageSinkVIUS4_Pointer = itk::ImageSink< itk::VectorImage< unsigned short,4 > >::Pointer;
using itkImageSinkVIF4 = itk::ImageSink< itk::VectorImage< float,4 > >;
using itkImageSinkVIF4_Pointer = itk::ImageSink< itk::VectorImage< float,4 > >::Pointer;
using itkImageSinkVID4 = itk::ImageSink< itk::VectorImage< double,4 > >;
using itkImageSinkVID4_Pointer = itk::ImageSink< itk::VectorImage< double,4 > >::Pointer;


#include "ITKCommonBaseSwigInterface.h"
#include "itkImageSwigInterface.h"
#include "itkImageSinkSwigInterface.h"
#include "itkVectorImageSwigInterface.h"
#include "itkImageRegionSwigInterface.h"
#include "itkImageToImageFilterCommonSwigInterface.h"
#endif
