/*
Copyright (c) 2015 - 2021 Advanced Micro Devices, Inc. All rights reserved.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

#pragma once

// This header file is partially copied from
//   https://github.com/llvm/llvm-project/blob/main/llvm/include/llvm/BinaryFormat/ELF.h

// AMDGPU OS for HSA compatible compute kernels.
enum { ELFOSABI_AMDGPU_HSA = 64, ELFOSABI_AMDGPU_PAL = 65, ELFOSABI_AMDGPU_MESA3D = 66 };

enum {
  ELFABIVERSION_AMDGPU_HSA_V2 = 0,
  ELFABIVERSION_AMDGPU_HSA_V3 = 1,
  ELFABIVERSION_AMDGPU_HSA_V4 = 2,
  ELFABIVERSION_AMDGPU_HSA_V5 = 3,
  ELFABIVERSION_AMDGPU_HSA_V6 = 4,
};

// AMDGPU specific e_flags
enum : unsigned {
  EF_AMDGPU_MACH = 0x0ff,
  // AMDGPU processors
  EF_AMDGPU_MACH_NONE = 0x000,
  EF_AMDGPU_MACH_R600_R600 = 0x001,
  EF_AMDGPU_MACH_R600_R630 = 0x002,
  EF_AMDGPU_MACH_R600_RS880 = 0x003,
  EF_AMDGPU_MACH_R600_RV670 = 0x004,
  EF_AMDGPU_MACH_R600_RV710 = 0x005,
  EF_AMDGPU_MACH_R600_RV730 = 0x006,
  EF_AMDGPU_MACH_R600_RV770 = 0x007,
  EF_AMDGPU_MACH_R600_CEDAR = 0x008,
  EF_AMDGPU_MACH_R600_CYPRESS = 0x009,
  EF_AMDGPU_MACH_R600_JUNIPER = 0x00a,
  EF_AMDGPU_MACH_R600_REDWOOD = 0x00b,
  EF_AMDGPU_MACH_R600_SUMO = 0x00c,
  EF_AMDGPU_MACH_R600_BARTS = 0x00d,
  EF_AMDGPU_MACH_R600_CAICOS = 0x00e,
  EF_AMDGPU_MACH_R600_CAYMAN = 0x00f,
  EF_AMDGPU_MACH_R600_TURKS = 0x010,
  EF_AMDGPU_MACH_R600_RESERVED_FIRST = 0x011,
  EF_AMDGPU_MACH_R600_RESERVED_LAST = 0x01f,
  EF_AMDGPU_MACH_R600_FIRST = EF_AMDGPU_MACH_R600_R600,
  EF_AMDGPU_MACH_R600_LAST = EF_AMDGPU_MACH_R600_TURKS,

  // AMDGCN-based processors.
  EF_AMDGPU_MACH_AMDGCN_GFX600 = 0x020,
  EF_AMDGPU_MACH_AMDGCN_GFX601 = 0x021,
  EF_AMDGPU_MACH_AMDGCN_GFX700 = 0x022,
  EF_AMDGPU_MACH_AMDGCN_GFX701 = 0x023,
  EF_AMDGPU_MACH_AMDGCN_GFX702 = 0x024,
  EF_AMDGPU_MACH_AMDGCN_GFX703 = 0x025,
  EF_AMDGPU_MACH_AMDGCN_GFX704 = 0x026,
  EF_AMDGPU_MACH_AMDGCN_RESERVED_0X27 = 0x027,
  EF_AMDGPU_MACH_AMDGCN_GFX801 = 0x028,
  EF_AMDGPU_MACH_AMDGCN_GFX802 = 0x029,
  EF_AMDGPU_MACH_AMDGCN_GFX803 = 0x02a,
  EF_AMDGPU_MACH_AMDGCN_GFX810 = 0x02b,
  EF_AMDGPU_MACH_AMDGCN_GFX900 = 0x02c,
  EF_AMDGPU_MACH_AMDGCN_GFX902 = 0x02d,
  EF_AMDGPU_MACH_AMDGCN_GFX904 = 0x02e,
  EF_AMDGPU_MACH_AMDGCN_GFX906 = 0x02f,
  EF_AMDGPU_MACH_AMDGCN_GFX908 = 0x030,
  EF_AMDGPU_MACH_AMDGCN_GFX909 = 0x031,
  EF_AMDGPU_MACH_AMDGCN_GFX90C = 0x032,
  EF_AMDGPU_MACH_AMDGCN_GFX1010 = 0x033,
  EF_AMDGPU_MACH_AMDGCN_GFX1011 = 0x034,
  EF_AMDGPU_MACH_AMDGCN_GFX1012 = 0x035,
  EF_AMDGPU_MACH_AMDGCN_GFX1030 = 0x036,
  EF_AMDGPU_MACH_AMDGCN_GFX1031 = 0x037,
  EF_AMDGPU_MACH_AMDGCN_GFX1032 = 0x038,
  EF_AMDGPU_MACH_AMDGCN_GFX1033 = 0x039,
  EF_AMDGPU_MACH_AMDGCN_GFX602 = 0x03a,
  EF_AMDGPU_MACH_AMDGCN_GFX705 = 0x03b,
  EF_AMDGPU_MACH_AMDGCN_GFX805 = 0x03c,
  EF_AMDGPU_MACH_AMDGCN_GFX1035 = 0x03d,
  EF_AMDGPU_MACH_AMDGCN_GFX1034 = 0x03e,
  EF_AMDGPU_MACH_AMDGCN_GFX90A = 0x03f,
  EF_AMDGPU_MACH_AMDGCN_GFX940 = 0x040,
  EF_AMDGPU_MACH_AMDGCN_GFX1100 = 0x041,
  EF_AMDGPU_MACH_AMDGCN_GFX1013 = 0x042,
  EF_AMDGPU_MACH_AMDGCN_GFX1150 = 0x043,
  EF_AMDGPU_MACH_AMDGCN_GFX1103 = 0x044,
  EF_AMDGPU_MACH_AMDGCN_GFX1036 = 0x045,
  EF_AMDGPU_MACH_AMDGCN_GFX1101 = 0x046,
  EF_AMDGPU_MACH_AMDGCN_GFX1102 = 0x047,
  EF_AMDGPU_MACH_AMDGCN_GFX1200 = 0x048,
  EF_AMDGPU_MACH_AMDGCN_RESERVED_0X49 = 0x049,
  EF_AMDGPU_MACH_AMDGCN_GFX1151 = 0x04a,
  EF_AMDGPU_MACH_AMDGCN_GFX941 = 0x04b,
  EF_AMDGPU_MACH_AMDGCN_GFX942 = 0x04c,
  EF_AMDGPU_MACH_AMDGCN_RESERVED_0X4D = 0x04d,
  EF_AMDGPU_MACH_AMDGCN_GFX1201 = 0x04e,
  EF_AMDGPU_MACH_AMDGCN_GFX950 = 0x04f,
  EF_AMDGPU_MACH_AMDGCN_RESERVED_0X50 = 0x050,
  EF_AMDGPU_MACH_AMDGCN_GFX9_GENERIC = 0x051,
  EF_AMDGPU_MACH_AMDGCN_GFX10_1_GENERIC = 0x052,
  EF_AMDGPU_MACH_AMDGCN_GFX10_3_GENERIC = 0x053,
  EF_AMDGPU_MACH_AMDGCN_GFX11_GENERIC = 0x054,
  EF_AMDGPU_MACH_AMDGCN_GFX1152 = 0x055,
  EF_AMDGPU_MACH_AMDGCN_RESERVED_0X56 = 0x056,
  EF_AMDGPU_MACH_AMDGCN_RESERVED_0X57 = 0x057,
  EF_AMDGPU_MACH_AMDGCN_RESERVED_0X58 = 0x058,
  EF_AMDGPU_MACH_AMDGCN_GFX12_GENERIC = 0x059,
  EF_AMDGPU_MACH_AMDGCN_GFX9_4_GENERIC = 0x05f,

  EF_AMDGPU_MACH_AMDGCN_FIRST = EF_AMDGPU_MACH_AMDGCN_GFX600,
  EF_AMDGPU_MACH_AMDGCN_LAST = EF_AMDGPU_MACH_AMDGCN_GFX9_4_GENERIC,

  // Indicates if the "xnack" target feature is enabled for all code contained
  // in the object.
  //
  // Only valid for ELFOSABI_AMDGPU_HSA and ELFABIVERSION_AMDGPU_HSA_V3.
  EF_AMDGPU_FEATURE_XNACK_V3 = 0x100,
  // Indicates if the "sramecc" target feature is enabled for all code
  // contained in the object.
  //
  // Only valid for ELFOSABI_AMDGPU_HSA and ELFABIVERSION_AMDGPU_HSA_V3.
  EF_AMDGPU_FEATURE_SRAMECC_V3 = 0x200,

  // Only valid for ELFOSABI_AMDGPU_HSA and ELFABIVERSION_AMDGPU_HSA_V4,
  // ELFABIVERSION_AMDGPU_HSA_V5 and ELFABIVERSION_AMDGPU_HSA_V6.
  EF_AMDGPU_FEATURE_XNACK_V4 = 0x300,
  EF_AMDGPU_FEATURE_XNACK_UNSUPPORTED_V4 = 0x000,
  EF_AMDGPU_FEATURE_XNACK_ANY_V4 = 0x100,
  EF_AMDGPU_FEATURE_XNACK_OFF_V4 = 0x200,
  EF_AMDGPU_FEATURE_XNACK_ON_V4 = 0x300,

  // SRAMECC selection mask for EF_AMDGPU_FEATURE_SRAMECC_* values.
  // Only valid for ELFOSABI_AMDGPU_HSA and ELFABIVERSION_AMDGPU_HSA_V4,
  // ELFABIVERSION_AMDGPU_HSA_V5 and ELFABIVERSION_AMDGPU_HSA_V6.
  EF_AMDGPU_FEATURE_SRAMECC_V4 = 0xc00,
  EF_AMDGPU_FEATURE_SRAMECC_UNSUPPORTED_V4 = 0x000,
  EF_AMDGPU_FEATURE_SRAMECC_ANY_V4 = 0x400,
  EF_AMDGPU_FEATURE_SRAMECC_OFF_V4 = 0x800,
  EF_AMDGPU_FEATURE_SRAMECC_ON_V4 = 0xc00,

  // Generic target versioning. This is contained in the list byte of EFLAGS.
  EF_AMDGPU_GENERIC_VERSION = 0xff000000,
  EF_AMDGPU_GENERIC_VERSION_OFFSET = 24,
  EF_AMDGPU_GENERIC_VERSION_MIN = 1,
  EF_AMDGPU_GENERIC_VERSION_MAX = 0xff,
};
