const char *sphere_ao_depth_vs =
  "//////////////////////////////////////////////////////////////////////\n"
  "//\n"
  "// Ambient occlusion shader for sphere impostors\n"
  "//\n"
  "// This vertex shader is used for rendering the depth texture from\n"
  "// the light source's view.\n"
  "//\n"
  "//////////////////////////////////////////////////////////////////////\n"
  "\n"
  "//\n"
  "// Input\n"
  "//\n"
  "\n"
  "// sphere position: model coordinates\n"
  "attribute vec3 a_pos;\n"
  "// sphere corner: [-r, -r], [r, -r], [r, r], [-r, r]\n"
  "attribute vec2 a_corner;\n"
  "\n"
  "//\n"
  "// Output\n"
  "//\n"
  "\n"
  "// normalized corner: [-1, 1]\n"
  "varying vec2 v_corner;\n"
  "\n"
  "//\n"
  "// Uniforms\n"
  "//\n"
  "\n"
  "// model-view matrix of the current light direction\n"
  "uniform mat4 u_modelView;\n"
  "// projection matrix\n"
  "uniform mat4 u_projection;\n"
  "\n"
  "void main()\n"
  "{\n"
  "  // extract radius from unnormalized corner attribute\n"
  "  float radius = abs(a_corner.s);\n"
  "  // normalize corner to be in [-1, 1] range\n"
  "  v_corner = a_corner / radius;\n"
  "\n"
  "  // model coords -> eye coords\n"
  "  vec4 pos = u_modelView * vec4(a_pos, 1.0);\n"
  "  // translate position to corner taking radius into account\n"
  "  pos.xy += a_corner;\n"
  "  // eye coords -> clip coords\n"
  "  gl_Position = u_projection * pos;\n"
  "}\n"
  "\n";
