// java wrapper for vtkOpenGLRenderUtilities object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkOpenGLRenderUtilities.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkOpenGLRenderUtilities_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkOpenGLRenderUtilities",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOpenGLRenderUtilities_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkOpenGLRenderUtilities* op = static_cast<vtkOpenGLRenderUtilities*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOpenGLRenderUtilities_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkOpenGLRenderUtilities* op = static_cast<vtkOpenGLRenderUtilities*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkOpenGLRenderUtilities_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkOpenGLRenderUtilities* op = static_cast<vtkOpenGLRenderUtilities*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkOpenGLRenderUtilities_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkOpenGLRenderUtilities* op = static_cast<vtkOpenGLRenderUtilities*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkOpenGLRenderUtilities_GetFullScreenQuadVertexShader_14(JNIEnv* env, jobject obj)
{
  std::string   temp20;

  vtkOpenGLRenderUtilities* op = static_cast<vtkOpenGLRenderUtilities*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFullScreenQuadVertexShader();
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkOpenGLRenderUtilities_GetFullScreenQuadFragmentShaderTemplate_15(JNIEnv* env, jobject obj)
{
  std::string   temp20;

  vtkOpenGLRenderUtilities* op = static_cast<vtkOpenGLRenderUtilities*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFullScreenQuadFragmentShaderTemplate();
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkOpenGLRenderUtilities_GetFullScreenQuadGeometryShader_16(JNIEnv* env, jobject obj)
{
  std::string   temp20;

  vtkOpenGLRenderUtilities* op = static_cast<vtkOpenGLRenderUtilities*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFullScreenQuadGeometryShader();
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkOpenGLRenderUtilities_PrepFullScreenVAO_17(JNIEnv* env, jobject obj,jobject id0,jobject id1,jobject id2)
{
  vtkOpenGLRenderWindow * temp0;
  vtkOpenGLVertexArrayObject * temp1;
  vtkShaderProgram * temp2;
  bool   temp20;
  temp0 = static_cast<vtkOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkOpenGLVertexArrayObject*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkShaderProgram*>(vtkJavaGetPointerFromObject(env, id2));

  vtkOpenGLRenderUtilities* op = static_cast<vtkOpenGLRenderUtilities*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->PrepFullScreenVAO(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenGLRenderUtilities_DrawFullScreenQuad_18(JNIEnv* env, jobject obj)
{

  vtkOpenGLRenderUtilities* op = static_cast<vtkOpenGLRenderUtilities*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawFullScreenQuad();

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkOpenGLRenderUtilities_PrepFullScreenVAO_19(JNIEnv* env, jobject obj,jobject id0,jobject id1,jobject id2)
{
  vtkOpenGLBufferObject * temp0;
  vtkOpenGLVertexArrayObject * temp1;
  vtkShaderProgram * temp2;
  bool   temp20;
  temp0 = static_cast<vtkOpenGLBufferObject*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkOpenGLVertexArrayObject*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkShaderProgram*>(vtkJavaGetPointerFromObject(env, id2));

  vtkOpenGLRenderUtilities* op = static_cast<vtkOpenGLRenderUtilities*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->PrepFullScreenVAO(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenGLRenderUtilities_MarkDebugEvent_110(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  std::string temp0;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);

  vtkOpenGLRenderUtilities* op = static_cast<vtkOpenGLRenderUtilities*>(vtkJavaGetPointerFromObject(env, obj));
  op->MarkDebugEvent(temp0);

}
