// java wrapper for vtkShaderProperty object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkShaderProperty.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkShaderProperty_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkShaderProperty",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkShaderProperty_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkShaderProperty* op = static_cast<vtkShaderProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkShaderProperty_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkShaderProperty* op = static_cast<vtkShaderProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkShaderProperty_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkShaderProperty* op = static_cast<vtkShaderProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkShaderProperty_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkShaderProperty* op = static_cast<vtkShaderProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkShaderProperty_DeepCopy_14(JNIEnv* env, jobject obj,jobject id0)
{
  vtkShaderProperty * temp0;
  temp0 = static_cast<vtkShaderProperty*>(vtkJavaGetPointerFromObject(env, id0));

  vtkShaderProperty* op = static_cast<vtkShaderProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->DeepCopy(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkShaderProperty_GetShaderMTime_15(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkShaderProperty* op = static_cast<vtkShaderProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetShaderMTime();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkShaderProperty_HasVertexShaderCode_16(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkShaderProperty* op = static_cast<vtkShaderProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasVertexShaderCode();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkShaderProperty_HasFragmentShaderCode_17(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkShaderProperty* op = static_cast<vtkShaderProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasFragmentShaderCode();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkShaderProperty_HasGeometryShaderCode_18(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkShaderProperty* op = static_cast<vtkShaderProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasGeometryShaderCode();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkShaderProperty_HasTessControlShaderCode_19(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkShaderProperty* op = static_cast<vtkShaderProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasTessControlShaderCode();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkShaderProperty_HasTessEvalShaderCode_110(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkShaderProperty* op = static_cast<vtkShaderProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasTessEvalShaderCode();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkShaderProperty_SetVertexShaderCode_111(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkShaderProperty* op = static_cast<vtkShaderProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetVertexShaderCode(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkShaderProperty_GetVertexShaderCode_112(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkShaderProperty* op = static_cast<vtkShaderProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetVertexShaderCode();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkShaderProperty_SetFragmentShaderCode_113(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkShaderProperty* op = static_cast<vtkShaderProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFragmentShaderCode(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkShaderProperty_GetFragmentShaderCode_114(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkShaderProperty* op = static_cast<vtkShaderProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFragmentShaderCode();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkShaderProperty_SetGeometryShaderCode_115(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkShaderProperty* op = static_cast<vtkShaderProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGeometryShaderCode(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkShaderProperty_GetGeometryShaderCode_116(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkShaderProperty* op = static_cast<vtkShaderProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGeometryShaderCode();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkShaderProperty_SetTessControlShaderCode_117(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkShaderProperty* op = static_cast<vtkShaderProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTessControlShaderCode(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkShaderProperty_GetTessControlShaderCode_118(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkShaderProperty* op = static_cast<vtkShaderProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTessControlShaderCode();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkShaderProperty_SetTessEvaluationShaderCode_119(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkShaderProperty* op = static_cast<vtkShaderProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTessEvaluationShaderCode(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkShaderProperty_GetTessEvaluationShaderCode_120(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkShaderProperty* op = static_cast<vtkShaderProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTessEvaluationShaderCode();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkShaderProperty_GetFragmentCustomUniforms_121(JNIEnv* env, jobject obj)
{
  vtkUniforms * temp20;

  vtkShaderProperty* op = static_cast<vtkShaderProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFragmentCustomUniforms();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkShaderProperty_GetVertexCustomUniforms_122(JNIEnv* env, jobject obj)
{
  vtkUniforms * temp20;

  vtkShaderProperty* op = static_cast<vtkShaderProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetVertexCustomUniforms();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkShaderProperty_GetGeometryCustomUniforms_123(JNIEnv* env, jobject obj)
{
  vtkUniforms * temp20;

  vtkShaderProperty* op = static_cast<vtkShaderProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGeometryCustomUniforms();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkShaderProperty_GetTessControlCustomUniforms_124(JNIEnv* env, jobject obj)
{
  vtkUniforms * temp20;

  vtkShaderProperty* op = static_cast<vtkShaderProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTessControlCustomUniforms();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkShaderProperty_GetTessEvaluationCustomUniforms_125(JNIEnv* env, jobject obj)
{
  vtkUniforms * temp20;

  vtkShaderProperty* op = static_cast<vtkShaderProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTessEvaluationCustomUniforms();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkShaderProperty_AddVertexShaderReplacement_126(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jboolean id1, jbyteArray id2, jint len2,jboolean id3)
{
  std::string temp0;
  bool   temp1;
  std::string temp2;
  bool   temp3;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);
  temp1 = (id1 != 0) ? true : false;
  temp2 = vtkJavaUTF8ToString(env, id2, len2);
  temp3 = (id3 != 0) ? true : false;

  vtkShaderProperty* op = static_cast<vtkShaderProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddVertexShaderReplacement(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkShaderProperty_AddFragmentShaderReplacement_127(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jboolean id1, jbyteArray id2, jint len2,jboolean id3)
{
  std::string temp0;
  bool   temp1;
  std::string temp2;
  bool   temp3;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);
  temp1 = (id1 != 0) ? true : false;
  temp2 = vtkJavaUTF8ToString(env, id2, len2);
  temp3 = (id3 != 0) ? true : false;

  vtkShaderProperty* op = static_cast<vtkShaderProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddFragmentShaderReplacement(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkShaderProperty_AddGeometryShaderReplacement_128(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jboolean id1, jbyteArray id2, jint len2,jboolean id3)
{
  std::string temp0;
  bool   temp1;
  std::string temp2;
  bool   temp3;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);
  temp1 = (id1 != 0) ? true : false;
  temp2 = vtkJavaUTF8ToString(env, id2, len2);
  temp3 = (id3 != 0) ? true : false;

  vtkShaderProperty* op = static_cast<vtkShaderProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddGeometryShaderReplacement(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkShaderProperty_AddTessControlShaderReplacement_129(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jboolean id1, jbyteArray id2, jint len2,jboolean id3)
{
  std::string temp0;
  bool   temp1;
  std::string temp2;
  bool   temp3;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);
  temp1 = (id1 != 0) ? true : false;
  temp2 = vtkJavaUTF8ToString(env, id2, len2);
  temp3 = (id3 != 0) ? true : false;

  vtkShaderProperty* op = static_cast<vtkShaderProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddTessControlShaderReplacement(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkShaderProperty_AddTessEvaluationShaderReplacement_130(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jboolean id1, jbyteArray id2, jint len2,jboolean id3)
{
  std::string temp0;
  bool   temp1;
  std::string temp2;
  bool   temp3;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);
  temp1 = (id1 != 0) ? true : false;
  temp2 = vtkJavaUTF8ToString(env, id2, len2);
  temp3 = (id3 != 0) ? true : false;

  vtkShaderProperty* op = static_cast<vtkShaderProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddTessEvaluationShaderReplacement(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkShaderProperty_GetNumberOfShaderReplacements_131(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkShaderProperty* op = static_cast<vtkShaderProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfShaderReplacements();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkShaderProperty_GetNthShaderReplacementTypeAsString_132(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  std::string   temp20;
  temp0 = id0;

  vtkShaderProperty* op = static_cast<vtkShaderProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNthShaderReplacementTypeAsString(temp0);
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkShaderProperty_ClearVertexShaderReplacement_133(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jboolean id1)
{
  std::string temp0;
  bool   temp1;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);
  temp1 = (id1 != 0) ? true : false;

  vtkShaderProperty* op = static_cast<vtkShaderProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->ClearVertexShaderReplacement(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkShaderProperty_ClearFragmentShaderReplacement_134(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jboolean id1)
{
  std::string temp0;
  bool   temp1;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);
  temp1 = (id1 != 0) ? true : false;

  vtkShaderProperty* op = static_cast<vtkShaderProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->ClearFragmentShaderReplacement(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkShaderProperty_ClearGeometryShaderReplacement_135(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jboolean id1)
{
  std::string temp0;
  bool   temp1;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);
  temp1 = (id1 != 0) ? true : false;

  vtkShaderProperty* op = static_cast<vtkShaderProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->ClearGeometryShaderReplacement(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkShaderProperty_ClearTessControlShaderReplacement_136(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jboolean id1)
{
  std::string temp0;
  bool   temp1;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);
  temp1 = (id1 != 0) ? true : false;

  vtkShaderProperty* op = static_cast<vtkShaderProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->ClearTessControlShaderReplacement(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkShaderProperty_ClearTessEvaluationShaderReplacement_137(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jboolean id1)
{
  std::string temp0;
  bool   temp1;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);
  temp1 = (id1 != 0) ? true : false;

  vtkShaderProperty* op = static_cast<vtkShaderProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->ClearTessEvaluationShaderReplacement(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkShaderProperty_ClearAllVertexShaderReplacements_138(JNIEnv* env, jobject obj)
{

  vtkShaderProperty* op = static_cast<vtkShaderProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->ClearAllVertexShaderReplacements();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkShaderProperty_ClearAllFragmentShaderReplacements_139(JNIEnv* env, jobject obj)
{

  vtkShaderProperty* op = static_cast<vtkShaderProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->ClearAllFragmentShaderReplacements();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkShaderProperty_ClearAllGeometryShaderReplacements_140(JNIEnv* env, jobject obj)
{

  vtkShaderProperty* op = static_cast<vtkShaderProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->ClearAllGeometryShaderReplacements();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkShaderProperty_ClearAllTessControlShaderReplacements_141(JNIEnv* env, jobject obj)
{

  vtkShaderProperty* op = static_cast<vtkShaderProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->ClearAllTessControlShaderReplacements();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkShaderProperty_ClearAllTessEvalShaderReplacements_142(JNIEnv* env, jobject obj)
{

  vtkShaderProperty* op = static_cast<vtkShaderProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->ClearAllTessEvalShaderReplacements();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkShaderProperty_ClearAllShaderReplacements_143(JNIEnv* env, jobject obj)
{

  vtkShaderProperty* op = static_cast<vtkShaderProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->ClearAllShaderReplacements();

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkShaderProperty_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkShaderProperty::New());
}
