// java wrapper for vtkConvertSelection object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkConvertSelection.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkSelectionAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkConvertSelection_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkConvertSelection",dType)) { return me; }
  if ((res= vtkSelectionAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkConvertSelection_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkConvertSelection* op = static_cast<vtkConvertSelection*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkConvertSelection_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkConvertSelection* op = static_cast<vtkConvertSelection*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkConvertSelection_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkConvertSelection* op = static_cast<vtkConvertSelection*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkConvertSelection_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkConvertSelection* op = static_cast<vtkConvertSelection*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkConvertSelection_SetDataObjectConnection_14(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAlgorithmOutput * temp0;
  temp0 = static_cast<vtkAlgorithmOutput*>(vtkJavaGetPointerFromObject(env, id0));

  vtkConvertSelection* op = static_cast<vtkConvertSelection*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataObjectConnection(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkConvertSelection_SetInputFieldType_15(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkConvertSelection* op = static_cast<vtkConvertSelection*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInputFieldType(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkConvertSelection_GetInputFieldType_16(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkConvertSelection* op = static_cast<vtkConvertSelection*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInputFieldType();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkConvertSelection_SetOutputType_17(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkConvertSelection* op = static_cast<vtkConvertSelection*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOutputType(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkConvertSelection_GetOutputType_18(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkConvertSelection* op = static_cast<vtkConvertSelection*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOutputType();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkConvertSelection_SetArrayName_19(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkConvertSelection* op = static_cast<vtkConvertSelection*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetArrayName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkConvertSelection_GetArrayName_110(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkConvertSelection* op = static_cast<vtkConvertSelection*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetArrayName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkConvertSelection_SetArrayNames_111(JNIEnv* env, jobject obj,jobject id0)
{
  vtkStringArray * temp0;
  temp0 = static_cast<vtkStringArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkConvertSelection* op = static_cast<vtkConvertSelection*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetArrayNames(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkConvertSelection_GetArrayNames_112(JNIEnv* env, jobject obj)
{
  vtkStringArray * temp20;

  vtkConvertSelection* op = static_cast<vtkConvertSelection*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetArrayNames();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkConvertSelection_AddArrayName_113(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkConvertSelection* op = static_cast<vtkConvertSelection*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddArrayName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkConvertSelection_ClearArrayNames_114(JNIEnv* env, jobject obj)
{

  vtkConvertSelection* op = static_cast<vtkConvertSelection*>(vtkJavaGetPointerFromObject(env, obj));
  op->ClearArrayNames();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkConvertSelection_SetMatchAnyValues_115(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkConvertSelection* op = static_cast<vtkConvertSelection*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMatchAnyValues(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkConvertSelection_GetMatchAnyValues_116(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkConvertSelection* op = static_cast<vtkConvertSelection*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMatchAnyValues();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkConvertSelection_MatchAnyValuesOn_117(JNIEnv* env, jobject obj)
{

  vtkConvertSelection* op = static_cast<vtkConvertSelection*>(vtkJavaGetPointerFromObject(env, obj));
  op->MatchAnyValuesOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkConvertSelection_MatchAnyValuesOff_118(JNIEnv* env, jobject obj)
{

  vtkConvertSelection* op = static_cast<vtkConvertSelection*>(vtkJavaGetPointerFromObject(env, obj));
  op->MatchAnyValuesOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkConvertSelection_SetAllowMissingArray_119(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkConvertSelection* op = static_cast<vtkConvertSelection*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAllowMissingArray(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkConvertSelection_GetAllowMissingArray_120(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkConvertSelection* op = static_cast<vtkConvertSelection*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAllowMissingArray();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkConvertSelection_AllowMissingArrayOn_121(JNIEnv* env, jobject obj)
{

  vtkConvertSelection* op = static_cast<vtkConvertSelection*>(vtkJavaGetPointerFromObject(env, obj));
  op->AllowMissingArrayOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkConvertSelection_AllowMissingArrayOff_122(JNIEnv* env, jobject obj)
{

  vtkConvertSelection* op = static_cast<vtkConvertSelection*>(vtkJavaGetPointerFromObject(env, obj));
  op->AllowMissingArrayOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkConvertSelection_SetSelectionExtractor_123(JNIEnv* env, jobject obj,jobject id0)
{
  vtkExtractSelection * temp0;
  temp0 = static_cast<vtkExtractSelection*>(vtkJavaGetPointerFromObject(env, id0));

  vtkConvertSelection* op = static_cast<vtkConvertSelection*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSelectionExtractor(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkConvertSelection_GetSelectionExtractor_124(JNIEnv* env, jobject obj)
{
  vtkExtractSelection * temp20;

  vtkConvertSelection* op = static_cast<vtkConvertSelection*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSelectionExtractor();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkConvertSelection_ToIndexSelection_125(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkSelection * temp0;
  vtkDataObject * temp1;
  vtkSelection * temp20;
  temp0 = static_cast<vtkSelection*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id1));

  vtkConvertSelection* op = static_cast<vtkConvertSelection*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ToIndexSelection(temp0,temp1);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkConvertSelection_ToGlobalIdSelection_126(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkSelection * temp0;
  vtkDataObject * temp1;
  vtkSelection * temp20;
  temp0 = static_cast<vtkSelection*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id1));

  vtkConvertSelection* op = static_cast<vtkConvertSelection*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ToGlobalIdSelection(temp0,temp1);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkConvertSelection_ToPedigreeIdSelection_127(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkSelection * temp0;
  vtkDataObject * temp1;
  vtkSelection * temp20;
  temp0 = static_cast<vtkSelection*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id1));

  vtkConvertSelection* op = static_cast<vtkConvertSelection*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ToPedigreeIdSelection(temp0,temp1);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkConvertSelection_ToValueSelection_128(JNIEnv* env, jobject obj,jobject id0,jobject id1, jbyteArray id2, jint len2)
{
  vtkSelection * temp0;
  vtkDataObject * temp1;
  char * temp2;
  vtkSelection * temp20;
  temp0 = static_cast<vtkSelection*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = vtkJavaUTF8ToChars(env, id2, len2);

  vtkConvertSelection* op = static_cast<vtkConvertSelection*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ToValueSelection(temp0,temp1,temp2);
  delete[] temp2;
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkConvertSelection_ToValueSelection_129(JNIEnv* env, jobject obj,jobject id0,jobject id1,jobject id2)
{
  vtkSelection * temp0;
  vtkDataObject * temp1;
  vtkStringArray * temp2;
  vtkSelection * temp20;
  temp0 = static_cast<vtkSelection*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkStringArray*>(vtkJavaGetPointerFromObject(env, id2));

  vtkConvertSelection* op = static_cast<vtkConvertSelection*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ToValueSelection(temp0,temp1,temp2);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkConvertSelection_GetSelectedItems_130(JNIEnv* env, jobject obj,jobject id0,jobject id1,jint id2,jobject id3)
{
  vtkSelection * temp0;
  vtkDataObject * temp1;
  int   temp2;
  vtkIdTypeArray * temp3;
  temp0 = static_cast<vtkSelection*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = id2;
  temp3 = static_cast<vtkIdTypeArray*>(vtkJavaGetPointerFromObject(env, id3));

  vtkConvertSelection* op = static_cast<vtkConvertSelection*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetSelectedItems(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkConvertSelection_GetSelectedVertices_131(JNIEnv* env, jobject obj,jobject id0,jobject id1,jobject id2)
{
  vtkSelection * temp0;
  vtkGraph * temp1;
  vtkIdTypeArray * temp2;
  temp0 = static_cast<vtkSelection*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkGraph*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkIdTypeArray*>(vtkJavaGetPointerFromObject(env, id2));

  vtkConvertSelection* op = static_cast<vtkConvertSelection*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetSelectedVertices(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkConvertSelection_GetSelectedEdges_132(JNIEnv* env, jobject obj,jobject id0,jobject id1,jobject id2)
{
  vtkSelection * temp0;
  vtkGraph * temp1;
  vtkIdTypeArray * temp2;
  temp0 = static_cast<vtkSelection*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkGraph*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkIdTypeArray*>(vtkJavaGetPointerFromObject(env, id2));

  vtkConvertSelection* op = static_cast<vtkConvertSelection*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetSelectedEdges(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkConvertSelection_GetSelectedPoints_133(JNIEnv* env, jobject obj,jobject id0,jobject id1,jobject id2)
{
  vtkSelection * temp0;
  vtkDataSet * temp1;
  vtkIdTypeArray * temp2;
  temp0 = static_cast<vtkSelection*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkIdTypeArray*>(vtkJavaGetPointerFromObject(env, id2));

  vtkConvertSelection* op = static_cast<vtkConvertSelection*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetSelectedPoints(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkConvertSelection_GetSelectedCells_134(JNIEnv* env, jobject obj,jobject id0,jobject id1,jobject id2)
{
  vtkSelection * temp0;
  vtkDataSet * temp1;
  vtkIdTypeArray * temp2;
  temp0 = static_cast<vtkSelection*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkIdTypeArray*>(vtkJavaGetPointerFromObject(env, id2));

  vtkConvertSelection* op = static_cast<vtkConvertSelection*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetSelectedCells(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkConvertSelection_GetSelectedRows_135(JNIEnv* env, jobject obj,jobject id0,jobject id1,jobject id2)
{
  vtkSelection * temp0;
  vtkTable * temp1;
  vtkIdTypeArray * temp2;
  temp0 = static_cast<vtkSelection*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkTable*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkIdTypeArray*>(vtkJavaGetPointerFromObject(env, id2));

  vtkConvertSelection* op = static_cast<vtkConvertSelection*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetSelectedRows(temp0,temp1,temp2);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkConvertSelection_ToSelectionType_136(JNIEnv* env, jobject obj,jobject id0,jobject id1,jint id2,jobject id3,jint id4,jboolean id5)
{
  vtkSelection * temp0;
  vtkDataObject * temp1;
  int   temp2;
  vtkStringArray * temp3;
  int   temp4;
  bool   temp5;
  vtkSelection * temp20;
  temp0 = static_cast<vtkSelection*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = id2;
  temp3 = static_cast<vtkStringArray*>(vtkJavaGetPointerFromObject(env, id3));
  temp4 = id4;
  temp5 = (id5 != 0) ? true : false;

  vtkConvertSelection* op = static_cast<vtkConvertSelection*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ToSelectionType(temp0,temp1,temp2,temp3,temp4,temp5);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkConvertSelection_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkConvertSelection::New());
}
