// java wrapper for vtkUnstructuredGrid object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkUnstructuredGrid.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkUnstructuredGridBase_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkUnstructuredGrid_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkUnstructuredGrid",dType)) { return me; }
  if ((res= vtkUnstructuredGridBase_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkUnstructuredGrid_ExtendedNew_10(JNIEnv* env, jobject obj)
{
  vtkUnstructuredGrid * temp20;

  vtkUnstructuredGrid* op = static_cast<vtkUnstructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ExtendedNew();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkUnstructuredGrid_IsTypeOf_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkUnstructuredGrid* op = static_cast<vtkUnstructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkUnstructuredGrid_IsA_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkUnstructuredGrid* op = static_cast<vtkUnstructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkUnstructuredGrid_GetNumberOfGenerationsFromBaseType_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkUnstructuredGrid* op = static_cast<vtkUnstructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkUnstructuredGrid_GetNumberOfGenerationsFromBase_14(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkUnstructuredGrid* op = static_cast<vtkUnstructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkUnstructuredGrid_GetDataObjectType_15(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkUnstructuredGrid* op = static_cast<vtkUnstructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataObjectType();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkUnstructuredGrid_AllocateEstimate_16(JNIEnv* env, jobject obj,jlong id0,jlong id1)
{
  long long   temp0;
  long long   temp1;
  bool   temp20;
  temp0 = id0;
  temp1 = id1;

  vtkUnstructuredGrid* op = static_cast<vtkUnstructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AllocateEstimate(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkUnstructuredGrid_AllocateExact_17(JNIEnv* env, jobject obj,jlong id0,jlong id1)
{
  long long   temp0;
  long long   temp1;
  bool   temp20;
  temp0 = id0;
  temp1 = id1;

  vtkUnstructuredGrid* op = static_cast<vtkUnstructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AllocateExact(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkUnstructuredGrid_Allocate_18(JNIEnv* env, jobject obj,jlong id0,jint id1)
{
  long long   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkUnstructuredGrid* op = static_cast<vtkUnstructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->Allocate(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkUnstructuredGrid_Reset_19(JNIEnv* env, jobject obj)
{

  vtkUnstructuredGrid* op = static_cast<vtkUnstructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->Reset();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkUnstructuredGrid_CopyStructure_110(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataSet * temp0;
  temp0 = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, id0));

  vtkUnstructuredGrid* op = static_cast<vtkUnstructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyStructure(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkUnstructuredGrid_GetNumberOfCells_111(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkUnstructuredGrid* op = static_cast<vtkUnstructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfCells();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkUnstructuredGrid_GetCell_112(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  vtkCell * temp20;
  temp0 = id0;

  vtkUnstructuredGrid* op = static_cast<vtkUnstructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCell(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkUnstructuredGrid_GetCell_113(JNIEnv* env, jobject obj,jlong id0,jobject id1)
{
  long long   temp0;
  vtkGenericCell * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, id1));

  vtkUnstructuredGrid* op = static_cast<vtkUnstructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetCell(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkUnstructuredGrid_GetCellBounds_114(JNIEnv* env, jobject obj,jlong id0,jdoubleArray id1)
{
  long long   temp0;
  double temp1[6];
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 6, &temp1[0]);

  vtkUnstructuredGrid* op = static_cast<vtkUnstructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetCellBounds(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 6, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkUnstructuredGrid_GetCellPoints_115(JNIEnv* env, jobject obj,jlong id0,jobject id1)
{
  long long   temp0;
  vtkIdList * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id1));

  vtkUnstructuredGrid* op = static_cast<vtkUnstructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetCellPoints(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkUnstructuredGrid_GetPointCells_116(JNIEnv* env, jobject obj,jlong id0,jobject id1)
{
  long long   temp0;
  vtkIdList * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id1));

  vtkUnstructuredGrid* op = static_cast<vtkUnstructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetPointCells(temp0,temp1);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkUnstructuredGrid_NewCellIterator_117(JNIEnv* env, jobject obj)
{
  vtkCellIterator * temp20;

  vtkUnstructuredGrid* op = static_cast<vtkUnstructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->NewCellIterator();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkUnstructuredGrid_GetCellType_118(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  int   temp20;
  temp0 = id0;

  vtkUnstructuredGrid* op = static_cast<vtkUnstructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellType(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkUnstructuredGrid_GetCellSize_119(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  long long   temp20;
  temp0 = id0;

  vtkUnstructuredGrid* op = static_cast<vtkUnstructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellSize(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkUnstructuredGrid_GetCellTypes_120(JNIEnv* env, jobject obj,jobject id0)
{
  vtkCellTypes * temp0;
  temp0 = static_cast<vtkCellTypes*>(vtkJavaGetPointerFromObject(env, id0));

  vtkUnstructuredGrid* op = static_cast<vtkUnstructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetCellTypes(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkUnstructuredGrid_GetDistinctCellTypesArray_121(JNIEnv* env, jobject obj)
{
  vtkUnsignedCharArray * temp20;

  vtkUnstructuredGrid* op = static_cast<vtkUnstructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDistinctCellTypesArray();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkUnstructuredGrid_GetCellTypesArray_122(JNIEnv* env, jobject obj)
{
  vtkUnsignedCharArray * temp20;

  vtkUnstructuredGrid* op = static_cast<vtkUnstructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellTypesArray();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkUnstructuredGrid_Squeeze_123(JNIEnv* env, jobject obj)
{

  vtkUnstructuredGrid* op = static_cast<vtkUnstructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->Squeeze();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkUnstructuredGrid_Initialize_124(JNIEnv* env, jobject obj)
{

  vtkUnstructuredGrid* op = static_cast<vtkUnstructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->Initialize();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkUnstructuredGrid_GetMaxCellSize_125(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkUnstructuredGrid* op = static_cast<vtkUnstructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaxCellSize();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkUnstructuredGrid_GetMaxSpatialDimension_126(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkUnstructuredGrid* op = static_cast<vtkUnstructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaxSpatialDimension();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkUnstructuredGrid_GetMinSpatialDimension_127(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkUnstructuredGrid* op = static_cast<vtkUnstructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMinSpatialDimension();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkUnstructuredGrid_BuildLinks_128(JNIEnv* env, jobject obj)
{

  vtkUnstructuredGrid* op = static_cast<vtkUnstructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->BuildLinks();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkUnstructuredGrid_SetLinks_129(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAbstractCellLinks * temp0;
  temp0 = static_cast<vtkAbstractCellLinks*>(vtkJavaGetPointerFromObject(env, id0));

  vtkUnstructuredGrid* op = static_cast<vtkUnstructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLinks(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkUnstructuredGrid_GetLinks_130(JNIEnv* env, jobject obj)
{
  vtkAbstractCellLinks * temp20;

  vtkUnstructuredGrid* op = static_cast<vtkUnstructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLinks();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkUnstructuredGrid_GetFaceStream_131(JNIEnv* env, jobject obj,jlong id0,jobject id1)
{
  long long   temp0;
  vtkIdList * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id1));

  vtkUnstructuredGrid* op = static_cast<vtkUnstructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetFaceStream(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkUnstructuredGrid_SetCells_132(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
  int   temp0;
  vtkCellArray * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, id1));

  vtkUnstructuredGrid* op = static_cast<vtkUnstructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCells(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkUnstructuredGrid_SetCells_133(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkUnsignedCharArray * temp0;
  vtkCellArray * temp1;
  temp0 = static_cast<vtkUnsignedCharArray*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, id1));

  vtkUnstructuredGrid* op = static_cast<vtkUnstructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCells(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkUnstructuredGrid_SetPolyhedralCells_134(JNIEnv* env, jobject obj,jobject id0,jobject id1,jobject id2,jobject id3)
{
  vtkUnsignedCharArray * temp0;
  vtkCellArray * temp1;
  vtkCellArray * temp2;
  vtkCellArray * temp3;
  temp0 = static_cast<vtkUnsignedCharArray*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, id2));
  temp3 = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, id3));

  vtkUnstructuredGrid* op = static_cast<vtkUnstructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPolyhedralCells(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkUnstructuredGrid_SetCells_135(JNIEnv* env, jobject obj,jobject id0,jobject id1,jobject id2,jobject id3)
{
  vtkUnsignedCharArray * temp0;
  vtkCellArray * temp1;
  vtkIdTypeArray * temp2;
  vtkIdTypeArray * temp3;
  temp0 = static_cast<vtkUnsignedCharArray*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkIdTypeArray*>(vtkJavaGetPointerFromObject(env, id2));
  temp3 = static_cast<vtkIdTypeArray*>(vtkJavaGetPointerFromObject(env, id3));

  vtkUnstructuredGrid* op = static_cast<vtkUnstructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCells(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkUnstructuredGrid_GetCells_136(JNIEnv* env, jobject obj)
{
  vtkCellArray * temp20;

  vtkUnstructuredGrid* op = static_cast<vtkUnstructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCells();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkUnstructuredGrid_GetCellNeighbors_137(JNIEnv* env, jobject obj,jlong id0,jobject id1,jobject id2)
{
  long long   temp0;
  vtkIdList * temp1;
  vtkIdList * temp2;
  temp0 = id0;
  temp1 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id2));

  vtkUnstructuredGrid* op = static_cast<vtkUnstructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetCellNeighbors(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkUnstructuredGrid_RemoveReferenceToCell_138(JNIEnv* env, jobject obj,jlong id0,jlong id1)
{
  long long   temp0;
  long long   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkUnstructuredGrid* op = static_cast<vtkUnstructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveReferenceToCell(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkUnstructuredGrid_AddReferenceToCell_139(JNIEnv* env, jobject obj,jlong id0,jlong id1)
{
  long long   temp0;
  long long   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkUnstructuredGrid* op = static_cast<vtkUnstructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddReferenceToCell(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkUnstructuredGrid_ResizeCellList_140(JNIEnv* env, jobject obj,jlong id0,jint id1)
{
  long long   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkUnstructuredGrid* op = static_cast<vtkUnstructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->ResizeCellList(temp0,temp1);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkUnstructuredGrid_GetPiece_141(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkUnstructuredGrid* op = static_cast<vtkUnstructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPiece();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkUnstructuredGrid_GetNumberOfPieces_142(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkUnstructuredGrid* op = static_cast<vtkUnstructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfPieces();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkUnstructuredGrid_GetGhostLevel_143(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkUnstructuredGrid* op = static_cast<vtkUnstructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGhostLevel();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkUnstructuredGrid_GetActualMemorySize_144(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkUnstructuredGrid* op = static_cast<vtkUnstructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetActualMemorySize();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkUnstructuredGrid_ShallowCopy_145(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkUnstructuredGrid* op = static_cast<vtkUnstructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->ShallowCopy(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkUnstructuredGrid_DeepCopy_146(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkUnstructuredGrid* op = static_cast<vtkUnstructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->DeepCopy(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkUnstructuredGrid_GetIdsOfCellsOfType_147(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
  int   temp0;
  vtkIdTypeArray * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkIdTypeArray*>(vtkJavaGetPointerFromObject(env, id1));

  vtkUnstructuredGrid* op = static_cast<vtkUnstructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetIdsOfCellsOfType(temp0,temp1);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkUnstructuredGrid_IsHomogeneous_148(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkUnstructuredGrid* op = static_cast<vtkUnstructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsHomogeneous();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkUnstructuredGrid_RemoveGhostCells_149(JNIEnv* env, jobject obj)
{

  vtkUnstructuredGrid* op = static_cast<vtkUnstructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveGhostCells();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkUnstructuredGrid_GetData_150(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformation * temp0;
  vtkUnstructuredGrid * temp20;
  temp0 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id0));

  vtkUnstructuredGrid* op = static_cast<vtkUnstructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetData(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkUnstructuredGrid_GetData_151(JNIEnv* env, jobject obj,jobject id0,jint id1)
{
  vtkInformationVector * temp0;
  int   temp1;
  vtkUnstructuredGrid * temp20;
  temp0 = static_cast<vtkInformationVector*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkUnstructuredGrid* op = static_cast<vtkUnstructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetData(temp0,temp1);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkUnstructuredGrid_GetPolyhedronFaces_152(JNIEnv* env, jobject obj,jlong id0,jobject id1)
{
  long long   temp0;
  vtkCellArray * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, id1));

  vtkUnstructuredGrid* op = static_cast<vtkUnstructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetPolyhedronFaces(temp0,temp1);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkUnstructuredGrid_GetFaces_153(JNIEnv* env, jobject obj)
{
  vtkIdTypeArray * temp20;

  vtkUnstructuredGrid* op = static_cast<vtkUnstructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFaces();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkUnstructuredGrid_GetFaceLocations_154(JNIEnv* env, jobject obj)
{
  vtkIdTypeArray * temp20;

  vtkUnstructuredGrid* op = static_cast<vtkUnstructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFaceLocations();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkUnstructuredGrid_GetPolyhedronFaces_155(JNIEnv* env, jobject obj)
{
  vtkCellArray * temp20;

  vtkUnstructuredGrid* op = static_cast<vtkUnstructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPolyhedronFaces();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkUnstructuredGrid_GetPolyhedronFaceLocations_156(JNIEnv* env, jobject obj)
{
  vtkCellArray * temp20;

  vtkUnstructuredGrid* op = static_cast<vtkUnstructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPolyhedronFaceLocations();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkUnstructuredGrid_InitializeFacesRepresentation_157(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  int   temp20;
  temp0 = id0;

  vtkUnstructuredGrid* op = static_cast<vtkUnstructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->InitializeFacesRepresentation(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkUnstructuredGrid_GetMeshMTime_158(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkUnstructuredGrid* op = static_cast<vtkUnstructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMeshMTime();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkUnstructuredGrid_GetCellLocationsArray_159(JNIEnv* env, jobject obj)
{
  vtkIdTypeArray * temp20;

  vtkUnstructuredGrid* op = static_cast<vtkUnstructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellLocationsArray();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkUnstructuredGrid_SetCells_160(JNIEnv* env, jobject obj,jobject id0,jobject id1,jobject id2)
{
  vtkUnsignedCharArray * temp0;
  vtkIdTypeArray * temp1;
  vtkCellArray * temp2;
  temp0 = static_cast<vtkUnsignedCharArray*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkIdTypeArray*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, id2));

  vtkUnstructuredGrid* op = static_cast<vtkUnstructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCells(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkUnstructuredGrid_SetCells_161(JNIEnv* env, jobject obj,jobject id0,jobject id1,jobject id2,jobject id3,jobject id4)
{
  vtkUnsignedCharArray * temp0;
  vtkIdTypeArray * temp1;
  vtkCellArray * temp2;
  vtkIdTypeArray * temp3;
  vtkIdTypeArray * temp4;
  temp0 = static_cast<vtkUnsignedCharArray*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkIdTypeArray*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, id2));
  temp3 = static_cast<vtkIdTypeArray*>(vtkJavaGetPointerFromObject(env, id3));
  temp4 = static_cast<vtkIdTypeArray*>(vtkJavaGetPointerFromObject(env, id4));

  vtkUnstructuredGrid* op = static_cast<vtkUnstructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCells(temp0,temp1,temp2,temp3,temp4);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkUnstructuredGrid_GetCell_162(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2)
{
  int   temp0;
  int   temp1;
  int   temp2;
  vtkCell * temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkUnstructuredGrid* op = static_cast<vtkUnstructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCell(temp0,temp1,temp2);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkUnstructuredGrid_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkUnstructuredGrid::New());
}
