// python wrapper for vtkAnariRenderer
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkAnariRenderer.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkAnariRenderer(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkAnariRenderer_ClassNew(); }


static PyObject *
PyvtkAnariRenderer_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkAnariRenderer::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAnariRenderer_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAnariRenderer *op = static_cast<vtkAnariRenderer *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkAnariRenderer::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAnariRenderer_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkAnariRenderer *tempr = vtkAnariRenderer::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAnariRenderer_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAnariRenderer *op = static_cast<vtkAnariRenderer *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkAnariRenderer *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkAnariRenderer::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAnariRenderer_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkAnariRenderer::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAnariRenderer_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAnariRenderer *op = static_cast<vtkAnariRenderer *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkAnariRenderer::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAnariRenderer_SetSubtype(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSubtype");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAnariRenderer *op = static_cast<vtkAnariRenderer *>(vp);

  const char *temp0 = "default";
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0, 1) &&
      (ap.NoArgsLeft() || ap.GetValue(temp0)))
  {
    if (ap.IsBound())
    {
      op->SetSubtype(temp0);
    }
    else
    {
      op->vtkAnariRenderer::SetSubtype(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAnariRenderer_GetSubtype(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSubtype");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAnariRenderer *op = static_cast<vtkAnariRenderer *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetSubtype() :
      op->vtkAnariRenderer::GetSubtype());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAnariRenderer_SetParameterb(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetParameterb");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAnariRenderer *op = static_cast<vtkAnariRenderer *>(vp);

  const char *temp0 = nullptr;
  bool temp1 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetParameterb(temp0, temp1);
    }
    else
    {
      op->vtkAnariRenderer::SetParameterb(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAnariRenderer_SetParameteri(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetParameteri");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAnariRenderer *op = static_cast<vtkAnariRenderer *>(vp);

  const char *temp0 = nullptr;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetParameteri(temp0, temp1);
    }
    else
    {
      op->vtkAnariRenderer::SetParameteri(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAnariRenderer_SetParameter2i(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetParameter2i");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAnariRenderer *op = static_cast<vtkAnariRenderer *>(vp);

  const char *temp0 = nullptr;
  int temp1;
  int temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetParameter2i(temp0, temp1, temp2);
    }
    else
    {
      op->vtkAnariRenderer::SetParameter2i(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAnariRenderer_SetParameter3i(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetParameter3i");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAnariRenderer *op = static_cast<vtkAnariRenderer *>(vp);

  const char *temp0 = nullptr;
  int temp1;
  int temp2;
  int temp3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3))
  {
    if (ap.IsBound())
    {
      op->SetParameter3i(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkAnariRenderer::SetParameter3i(temp0, temp1, temp2, temp3);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAnariRenderer_SetParameter4i(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetParameter4i");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAnariRenderer *op = static_cast<vtkAnariRenderer *>(vp);

  const char *temp0 = nullptr;
  int temp1;
  int temp2;
  int temp3;
  int temp4;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(5) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3) &&
      ap.GetValue(temp4))
  {
    if (ap.IsBound())
    {
      op->SetParameter4i(temp0, temp1, temp2, temp3, temp4);
    }
    else
    {
      op->vtkAnariRenderer::SetParameter4i(temp0, temp1, temp2, temp3, temp4);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAnariRenderer_SetParameterf(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetParameterf");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAnariRenderer *op = static_cast<vtkAnariRenderer *>(vp);

  const char *temp0 = nullptr;
  float temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetParameterf(temp0, temp1);
    }
    else
    {
      op->vtkAnariRenderer::SetParameterf(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAnariRenderer_SetParameter2f(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetParameter2f");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAnariRenderer *op = static_cast<vtkAnariRenderer *>(vp);

  const char *temp0 = nullptr;
  float temp1;
  float temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetParameter2f(temp0, temp1, temp2);
    }
    else
    {
      op->vtkAnariRenderer::SetParameter2f(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAnariRenderer_SetParameter3f(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetParameter3f");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAnariRenderer *op = static_cast<vtkAnariRenderer *>(vp);

  const char *temp0 = nullptr;
  float temp1;
  float temp2;
  float temp3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3))
  {
    if (ap.IsBound())
    {
      op->SetParameter3f(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkAnariRenderer::SetParameter3f(temp0, temp1, temp2, temp3);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAnariRenderer_SetParameter4f(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetParameter4f");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAnariRenderer *op = static_cast<vtkAnariRenderer *>(vp);

  const char *temp0 = nullptr;
  float temp1;
  float temp2;
  float temp3;
  float temp4;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(5) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3) &&
      ap.GetValue(temp4))
  {
    if (ap.IsBound())
    {
      op->SetParameter4f(temp0, temp1, temp2, temp3, temp4);
    }
    else
    {
      op->vtkAnariRenderer::SetParameter4f(temp0, temp1, temp2, temp3, temp4);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkAnariRenderer_Methods[] = {
  {"IsTypeOf", PyvtkAnariRenderer_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkAnariRenderer_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkAnariRenderer_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkAnariRenderer\nC++: static vtkAnariRenderer *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkAnariRenderer_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkAnariRenderer\nC++: vtkAnariRenderer *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkAnariRenderer_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkAnariRenderer_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetSubtype", PyvtkAnariRenderer_SetSubtype, METH_VARARGS,
   "SetSubtype(self, subtype:str=\"default\") -> None\nC++: void SetSubtype(const char *subtype=\"default\")\n\nSet the underlying subtype of the anari::Renderer. When a\ndifferent subtype is passed from what was already in-use, a new\nanari::Renderer handle will be created and will not keep any\nparameter values set on the previous anari::Renderer. Calling\nthis without having a setup anari::Device will cause a default\nsetup of the anari::Device to be done using the 'environment'\ndevice.\n"},
  {"GetSubtype", PyvtkAnariRenderer_GetSubtype, METH_VARARGS,
   "GetSubtype(self) -> str\nC++: const char *GetSubtype()\n\nGet the subtype of the current underlying anari::Renderer. Empty\nif not yet set.\n"},
  {"SetParameterb", PyvtkAnariRenderer_SetParameterb, METH_VARARGS,
   "SetParameterb(self, param:str, __b:bool) -> None\nC++: void SetParameterb(const char *param, bool)\n\nMethods to set/commit generic parameteters on the underlying\nanari::Renderer object.  These are primarily to support setting\nparameters from Python -- C++ users can also use the ANARI API\ndirectly by using anari::setParameter() and\nanari::commitParameters() directly as it is equivalent.\n"},
  {"SetParameteri", PyvtkAnariRenderer_SetParameteri, METH_VARARGS,
   "SetParameteri(self, param:str, __b:int) -> None\nC++: void SetParameteri(const char *param, int)\n\nMethods to set/commit generic parameteters on the underlying\nanari::Renderer object.  These are primarily to support setting\nparameters from Python -- C++ users can also use the ANARI API\ndirectly by using anari::setParameter() and\nanari::commitParameters() directly as it is equivalent.\n"},
  {"SetParameter2i", PyvtkAnariRenderer_SetParameter2i, METH_VARARGS,
   "SetParameter2i(self, param:str, __b:int, __c:int) -> None\nC++: void SetParameter2i(const char *param, int, int)\n\nMethods to set/commit generic parameteters on the underlying\nanari::Renderer object.  These are primarily to support setting\nparameters from Python -- C++ users can also use the ANARI API\ndirectly by using anari::setParameter() and\nanari::commitParameters() directly as it is equivalent.\n"},
  {"SetParameter3i", PyvtkAnariRenderer_SetParameter3i, METH_VARARGS,
   "SetParameter3i(self, param:str, __b:int, __c:int, __d:int) -> None\nC++: void SetParameter3i(const char *param, int, int, int)\n\nMethods to set/commit generic parameteters on the underlying\nanari::Renderer object.  These are primarily to support setting\nparameters from Python -- C++ users can also use the ANARI API\ndirectly by using anari::setParameter() and\nanari::commitParameters() directly as it is equivalent.\n"},
  {"SetParameter4i", PyvtkAnariRenderer_SetParameter4i, METH_VARARGS,
   "SetParameter4i(self, param:str, __b:int, __c:int, __d:int,\n    __e:int) -> None\nC++: void SetParameter4i(const char *param, int, int, int, int)\n\nMethods to set/commit generic parameteters on the underlying\nanari::Renderer object.  These are primarily to support setting\nparameters from Python -- C++ users can also use the ANARI API\ndirectly by using anari::setParameter() and\nanari::commitParameters() directly as it is equivalent.\n"},
  {"SetParameterf", PyvtkAnariRenderer_SetParameterf, METH_VARARGS,
   "SetParameterf(self, param:str, __b:float) -> None\nC++: void SetParameterf(const char *param, float)\n\nMethods to set/commit generic parameteters on the underlying\nanari::Renderer object.  These are primarily to support setting\nparameters from Python -- C++ users can also use the ANARI API\ndirectly by using anari::setParameter() and\nanari::commitParameters() directly as it is equivalent.\n"},
  {"SetParameter2f", PyvtkAnariRenderer_SetParameter2f, METH_VARARGS,
   "SetParameter2f(self, param:str, __b:float, __c:float) -> None\nC++: void SetParameter2f(const char *param, float, float)\n\nMethods to set/commit generic parameteters on the underlying\nanari::Renderer object.  These are primarily to support setting\nparameters from Python -- C++ users can also use the ANARI API\ndirectly by using anari::setParameter() and\nanari::commitParameters() directly as it is equivalent.\n"},
  {"SetParameter3f", PyvtkAnariRenderer_SetParameter3f, METH_VARARGS,
   "SetParameter3f(self, param:str, __b:float, __c:float, __d:float)\n    -> None\nC++: void SetParameter3f(const char *param, float, float, float)\n\nMethods to set/commit generic parameteters on the underlying\nanari::Renderer object.  These are primarily to support setting\nparameters from Python -- C++ users can also use the ANARI API\ndirectly by using anari::setParameter() and\nanari::commitParameters() directly as it is equivalent.\n"},
  {"SetParameter4f", PyvtkAnariRenderer_SetParameter4f, METH_VARARGS,
   "SetParameter4f(self, param:str, __b:float, __c:float, __d:float,\n    __e:float) -> None\nC++: void SetParameter4f(const char *param, float, float, float,\n    float)\n\nMethods to set/commit generic parameteters on the underlying\nanari::Renderer object.  These are primarily to support setting\nparameters from Python -- C++ users can also use the ANARI API\ndirectly by using anari::setParameter() and\nanari::commitParameters() directly as it is equivalent.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkAnariRenderer_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("subtype"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkAnariRenderer_GetSubtype(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkAnariRenderer_SetSubtype(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkAnariRenderer_SetSubtype(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetSubtype/SetSubtype\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkAnariRenderer_Doc =
  "vtkAnariRenderer - base class to objects which create + manage an\nANARI library, device, and renderer\n\n"
  "Superclass: vtkObject\n\n"
  "This class extends vtkAnariDevice to also manage an instance of an\n"
  "ANARI renderer object, as well as being able to query what renderer\n"
  "subtypes are available and setting parameters on the object. Note\n"
  "that applications which set any 'background' parameters on the handle\n"
  "directly will conflict with vtkAnariRendererNode setting it to\n"
  "whatever the vtkRenderer values are.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkAnariRenderer_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRenderingAnari.vtkAnariRenderer", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkAnariRenderer_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkAnariRenderer_StaticNew()
{
  return vtkAnariRenderer::New();
}

PyObject *PyvtkAnariRenderer_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkAnariRenderer_Type, PyvtkAnariRenderer_Methods,
    "vtkAnariRenderer",
 &PyvtkAnariRenderer_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkObject");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkAnariRenderer_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkAnariRenderer(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkAnariRenderer_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkAnariRenderer", o) != 0)
  {
    Py_DECREF(o);
  }

}

