/* client functions auto-generated by pidl */

#include "includes.h"
#include <tevent.h>
#include "lib/util/tevent_ntstatus.h"
#include "bin/default/librpc/gen_ndr/ndr_gkdi.h"
#include "bin/default/librpc/gen_ndr/ndr_gkdi_c.h"

/* gkdi - client functions generated by pidl */

struct dcerpc_gkdi_GetKey_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_gkdi_GetKey_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_gkdi_GetKey_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct gkdi_GetKey *r)
{
	struct tevent_req *req;
	struct dcerpc_gkdi_GetKey_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_gkdi_GetKey_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_gkdi,
			NDR_GKDI_GETKEY, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_gkdi_GetKey_r_done, req);

	return req;
}

static void dcerpc_gkdi_GetKey_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_gkdi_GetKey_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_gkdi_GetKey_r_state *state =
		tevent_req_data(req,
		struct dcerpc_gkdi_GetKey_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_gkdi_GetKey_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct gkdi_GetKey *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_gkdi,
			NDR_GKDI_GETKEY, mem_ctx, r);

	return status;
}

struct dcerpc_gkdi_GetKey_state {
	struct gkdi_GetKey orig;
	struct gkdi_GetKey tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_gkdi_GetKey_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_gkdi_GetKey_send(TALLOC_CTX *mem_ctx,
					   struct tevent_context *ev,
					   struct dcerpc_binding_handle *h,
					   uint32_t _target_sd_len /* [in]  */,
					   uint8_t *_target_sd /* [in] [ref,size_is(target_sd_len)] */,
					   struct GUID *_root_key_id /* [in] [unique] */,
					   int32_t _l0_key_id /* [in]  */,
					   int32_t _l1_key_id /* [in]  */,
					   int32_t _l2_key_id /* [in]  */,
					   uint32_t *_out_len /* [out] [ref] */,
					   uint8_t **_out /* [out] [ref,size_is(,*out_len)] */)
{
	struct tevent_req *req;
	struct dcerpc_gkdi_GetKey_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_gkdi_GetKey_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.target_sd_len = _target_sd_len;
	state->orig.in.target_sd = _target_sd;
	state->orig.in.root_key_id = _root_key_id;
	state->orig.in.l0_key_id = _l0_key_id;
	state->orig.in.l1_key_id = _l1_key_id;
	state->orig.in.l2_key_id = _l2_key_id;

	/* Out parameters */
	state->orig.out.out_len = _out_len;
	state->orig.out.out = _out;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_gkdi_GetKey_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_gkdi_GetKey_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_gkdi_GetKey_done, req);
	return req;
}

static void dcerpc_gkdi_GetKey_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_gkdi_GetKey_state *state = tevent_req_data(
		req, struct dcerpc_gkdi_GetKey_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_gkdi_GetKey_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.out_len = *state->tmp.out.out_len;
	*state->orig.out.out = *state->tmp.out.out;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_gkdi_GetKey_recv(struct tevent_req *req,
				 TALLOC_CTX *mem_ctx,
				 HRESULT *result)
{
	struct dcerpc_gkdi_GetKey_state *state = tevent_req_data(
		req, struct dcerpc_gkdi_GetKey_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_gkdi_GetKey(struct dcerpc_binding_handle *h,
			    TALLOC_CTX *mem_ctx,
			    uint32_t _target_sd_len /* [in]  */,
			    uint8_t *_target_sd /* [in] [ref,size_is(target_sd_len)] */,
			    struct GUID *_root_key_id /* [in] [unique] */,
			    int32_t _l0_key_id /* [in]  */,
			    int32_t _l1_key_id /* [in]  */,
			    int32_t _l2_key_id /* [in]  */,
			    uint32_t *_out_len /* [out] [ref] */,
			    uint8_t **_out /* [out] [ref,size_is(,*out_len)] */,
			    HRESULT *result)
{
	struct gkdi_GetKey r;
	NTSTATUS status;

	/* In parameters */
	r.in.target_sd_len = _target_sd_len;
	r.in.target_sd = _target_sd;
	r.in.root_key_id = _root_key_id;
	r.in.l0_key_id = _l0_key_id;
	r.in.l1_key_id = _l1_key_id;
	r.in.l2_key_id = _l2_key_id;

	/* Out parameters */
	r.out.out_len = _out_len;
	r.out.out = _out;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_gkdi_GetKey_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_out_len = *r.out.out_len;
	*_out = *r.out.out;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

