// ui/accessibility/mojom/ax_relative_bounds.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_ACCESSIBILITY_MOJOM_AX_RELATIVE_BOUNDS_MOJOM_H_
#define UI_ACCESSIBILITY_MOJOM_AX_RELATIVE_BOUNDS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/accessibility/mojom/ax_relative_bounds.mojom-features.h"  // IWYU pragma: export
#include "ui/accessibility/mojom/ax_relative_bounds.mojom-shared.h"  // IWYU pragma: export
#include "ui/accessibility/mojom/ax_relative_bounds.mojom-forward.h"  // IWYU pragma: export
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "ui/gfx/mojom/transform.mojom.h"
#include <string>
#include <vector>




#include "ui/accessibility/mojom/ax_relative_bounds_mojom_traits.h"




namespace ax::mojom {








class  AXRelativeBounds {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AXRelativeBounds, T>::value>;
  using DataView = AXRelativeBoundsDataView;
  using Data_ = internal::AXRelativeBounds_Data;

  template <typename... Args>
  static AXRelativeBoundsPtr New(Args&&... args) {
    return AXRelativeBoundsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AXRelativeBoundsPtr From(const U& u) {
    return mojo::TypeConverter<AXRelativeBoundsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AXRelativeBounds>::Convert(*this);
  }


  AXRelativeBounds();

  AXRelativeBounds(
      int32_t offset_container_id,
      const ::gfx::RectF& bounds,
      const ::gfx::Transform& transform);


  ~AXRelativeBounds();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AXRelativeBoundsPtr>
  AXRelativeBoundsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AXRelativeBounds::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AXRelativeBounds::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AXRelativeBounds::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AXRelativeBounds::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AXRelativeBounds::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AXRelativeBounds_UnserializedMessageContext<
            UserType, AXRelativeBounds::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AXRelativeBounds::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AXRelativeBounds::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AXRelativeBounds_UnserializedMessageContext<
            UserType, AXRelativeBounds::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AXRelativeBounds::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t offset_container_id;
  
  ::gfx::RectF bounds;
  
  ::gfx::Transform transform;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AXRelativeBounds::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AXRelativeBounds::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AXRelativeBounds::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AXRelativeBounds::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
AXRelativeBoundsPtr AXRelativeBounds::Clone() const {
  return New(
      mojo::Clone(offset_container_id),
      mojo::Clone(bounds),
      mojo::Clone(transform)
  );
}

template <typename T, AXRelativeBounds::EnableIfSame<T>*>
bool AXRelativeBounds::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->offset_container_id, other_struct.offset_container_id))
    return false;
  if (!mojo::Equals(this->bounds, other_struct.bounds))
    return false;
  if (!mojo::Equals(this->transform, other_struct.transform))
    return false;
  return true;
}

template <typename T, AXRelativeBounds::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.offset_container_id < rhs.offset_container_id)
    return true;
  if (rhs.offset_container_id < lhs.offset_container_id)
    return false;
  if (lhs.bounds < rhs.bounds)
    return true;
  if (rhs.bounds < lhs.bounds)
    return false;
  if (lhs.transform < rhs.transform)
    return true;
  if (rhs.transform < lhs.transform)
    return false;
  return false;
}


}  // ax::mojom

namespace mojo {


template <>
struct  StructTraits<::ax::mojom::AXRelativeBounds::DataView,
                                         ::ax::mojom::AXRelativeBoundsPtr> {
  static bool IsNull(const ::ax::mojom::AXRelativeBoundsPtr& input) { return !input; }
  static void SetToNull(::ax::mojom::AXRelativeBoundsPtr* output) { output->reset(); }

  static decltype(::ax::mojom::AXRelativeBounds::offset_container_id) offset_container_id(
      const ::ax::mojom::AXRelativeBoundsPtr& input) {
    return input->offset_container_id;
  }

  static const decltype(::ax::mojom::AXRelativeBounds::bounds)& bounds(
      const ::ax::mojom::AXRelativeBoundsPtr& input) {
    return input->bounds;
  }

  static const decltype(::ax::mojom::AXRelativeBounds::transform)& transform(
      const ::ax::mojom::AXRelativeBoundsPtr& input) {
    return input->transform;
  }

  static bool Read(::ax::mojom::AXRelativeBounds::DataView input, ::ax::mojom::AXRelativeBoundsPtr* output);
};

}  // namespace mojo

#endif  // UI_ACCESSIBILITY_MOJOM_AX_RELATIVE_BOUNDS_MOJOM_H_