// third_party/blink/public/mojom/tokens/tokens.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/tokens/tokens.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/tokens/tokens.mojom-params-data.h"
namespace blink {
namespace mojom {

namespace internal {
// static
bool FrameToken_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const FrameToken_Data* object = static_cast<const FrameToken_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case FrameToken_Tag::kLocalFrameToken: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_local_frame_token, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_local_frame_token, validation_context))
        return false;
      return true;
    }
    case FrameToken_Tag::kRemoteFrameToken: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_remote_frame_token, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_remote_frame_token, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in FrameToken");
      return false;
    }
  }
}
// static
bool WorkerToken_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const WorkerToken_Data* object = static_cast<const WorkerToken_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case WorkerToken_Tag::kDedicatedWorkerToken: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_dedicated_worker_token, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_dedicated_worker_token, validation_context))
        return false;
      return true;
    }
    case WorkerToken_Tag::kServiceWorkerToken: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_service_worker_token, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_service_worker_token, validation_context))
        return false;
      return true;
    }
    case WorkerToken_Tag::kSharedWorkerToken: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_shared_worker_token, 3, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_shared_worker_token, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in WorkerToken");
      return false;
    }
  }
}
// static
bool WorkletToken_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const WorkletToken_Data* object = static_cast<const WorkletToken_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case WorkletToken_Tag::kAnimationWorkletToken: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_animation_worklet_token, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_animation_worklet_token, validation_context))
        return false;
      return true;
    }
    case WorkletToken_Tag::kAudioWorkletToken: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_audio_worklet_token, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_audio_worklet_token, validation_context))
        return false;
      return true;
    }
    case WorkletToken_Tag::kLayoutWorkletToken: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_layout_worklet_token, 3, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_layout_worklet_token, validation_context))
        return false;
      return true;
    }
    case WorkletToken_Tag::kPaintWorkletToken: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_paint_worklet_token, 4, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_paint_worklet_token, validation_context))
        return false;
      return true;
    }
    case WorkletToken_Tag::kSharedStorageWorkletToken: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_shared_storage_worklet_token, 5, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_shared_storage_worklet_token, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in WorkletToken");
      return false;
    }
  }
}
// static
bool ExecutionContextToken_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const ExecutionContextToken_Data* object = static_cast<const ExecutionContextToken_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case ExecutionContextToken_Tag::kLocalFrameToken: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_local_frame_token, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_local_frame_token, validation_context))
        return false;
      return true;
    }
    case ExecutionContextToken_Tag::kDedicatedWorkerToken: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_dedicated_worker_token, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_dedicated_worker_token, validation_context))
        return false;
      return true;
    }
    case ExecutionContextToken_Tag::kServiceWorkerToken: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_service_worker_token, 3, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_service_worker_token, validation_context))
        return false;
      return true;
    }
    case ExecutionContextToken_Tag::kSharedWorkerToken: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_shared_worker_token, 4, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_shared_worker_token, validation_context))
        return false;
      return true;
    }
    case ExecutionContextToken_Tag::kAnimationWorkletToken: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_animation_worklet_token, 5, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_animation_worklet_token, validation_context))
        return false;
      return true;
    }
    case ExecutionContextToken_Tag::kAudioWorkletToken: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_audio_worklet_token, 6, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_audio_worklet_token, validation_context))
        return false;
      return true;
    }
    case ExecutionContextToken_Tag::kLayoutWorkletToken: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_layout_worklet_token, 7, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_layout_worklet_token, validation_context))
        return false;
      return true;
    }
    case ExecutionContextToken_Tag::kPaintWorkletToken: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_paint_worklet_token, 8, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_paint_worklet_token, validation_context))
        return false;
      return true;
    }
    case ExecutionContextToken_Tag::kSharedStorageWorkletToken: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_shared_storage_worklet_token, 9, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_shared_storage_worklet_token, validation_context))
        return false;
      return true;
    }
    case ExecutionContextToken_Tag::kShadowRealmToken: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_shadow_realm_token, 10, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_shadow_realm_token, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in ExecutionContextToken");
      return false;
    }
  }
}
// static
bool WebGPUExecutionContextToken_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const WebGPUExecutionContextToken_Data* object = static_cast<const WebGPUExecutionContextToken_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case WebGPUExecutionContextToken_Tag::kDocumentToken: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_document_token, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_document_token, validation_context))
        return false;
      return true;
    }
    case WebGPUExecutionContextToken_Tag::kDedicatedWorkerToken: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_dedicated_worker_token, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_dedicated_worker_token, validation_context))
        return false;
      return true;
    }
    case WebGPUExecutionContextToken_Tag::kSharedWorkerToken: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_shared_worker_token, 3, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_shared_worker_token, validation_context))
        return false;
      return true;
    }
    case WebGPUExecutionContextToken_Tag::kServiceWorkerToken: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_service_worker_token, 4, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_service_worker_token, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in WebGPUExecutionContextToken");
      return false;
    }
  }
}


// static
bool DocumentToken_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DocumentToken_Data* object =
      static_cast<const DocumentToken_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->value, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->value, validation_context))
    return false;

  return true;
}

DocumentToken_Data::DocumentToken_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocalFrameToken_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocalFrameToken_Data* object =
      static_cast<const LocalFrameToken_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->value, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->value, validation_context))
    return false;

  return true;
}

LocalFrameToken_Data::LocalFrameToken_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RemoteFrameToken_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RemoteFrameToken_Data* object =
      static_cast<const RemoteFrameToken_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->value, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->value, validation_context))
    return false;

  return true;
}

RemoteFrameToken_Data::RemoteFrameToken_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DedicatedWorkerToken_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DedicatedWorkerToken_Data* object =
      static_cast<const DedicatedWorkerToken_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->value, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->value, validation_context))
    return false;

  return true;
}

DedicatedWorkerToken_Data::DedicatedWorkerToken_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ServiceWorkerToken_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ServiceWorkerToken_Data* object =
      static_cast<const ServiceWorkerToken_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->value, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->value, validation_context))
    return false;

  return true;
}

ServiceWorkerToken_Data::ServiceWorkerToken_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SharedWorkerToken_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SharedWorkerToken_Data* object =
      static_cast<const SharedWorkerToken_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->value, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->value, validation_context))
    return false;

  return true;
}

SharedWorkerToken_Data::SharedWorkerToken_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AnimationWorkletToken_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AnimationWorkletToken_Data* object =
      static_cast<const AnimationWorkletToken_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->value, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->value, validation_context))
    return false;

  return true;
}

AnimationWorkletToken_Data::AnimationWorkletToken_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AudioWorkletToken_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AudioWorkletToken_Data* object =
      static_cast<const AudioWorkletToken_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->value, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->value, validation_context))
    return false;

  return true;
}

AudioWorkletToken_Data::AudioWorkletToken_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LayoutWorkletToken_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LayoutWorkletToken_Data* object =
      static_cast<const LayoutWorkletToken_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->value, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->value, validation_context))
    return false;

  return true;
}

LayoutWorkletToken_Data::LayoutWorkletToken_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PaintWorkletToken_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PaintWorkletToken_Data* object =
      static_cast<const PaintWorkletToken_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->value, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->value, validation_context))
    return false;

  return true;
}

PaintWorkletToken_Data::PaintWorkletToken_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SharedStorageWorkletToken_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SharedStorageWorkletToken_Data* object =
      static_cast<const SharedStorageWorkletToken_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->value, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->value, validation_context))
    return false;

  return true;
}

SharedStorageWorkletToken_Data::SharedStorageWorkletToken_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ShadowRealmToken_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ShadowRealmToken_Data* object =
      static_cast<const ShadowRealmToken_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->value, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->value, validation_context))
    return false;

  return true;
}

ShadowRealmToken_Data::ShadowRealmToken_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AttributionSrcToken_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AttributionSrcToken_Data* object =
      static_cast<const AttributionSrcToken_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->value, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->value, validation_context))
    return false;

  return true;
}

AttributionSrcToken_Data::AttributionSrcToken_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ClipboardSequenceNumberToken_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ClipboardSequenceNumberToken_Data* object =
      static_cast<const ClipboardSequenceNumberToken_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->value, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->value, validation_context))
    return false;

  return true;
}

ClipboardSequenceNumberToken_Data::ClipboardSequenceNumberToken_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SameDocNavigationScreenshotDestinationToken_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SameDocNavigationScreenshotDestinationToken_Data* object =
      static_cast<const SameDocNavigationScreenshotDestinationToken_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->value, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->value, validation_context))
    return false;

  return true;
}

SameDocNavigationScreenshotDestinationToken_Data::SameDocNavigationScreenshotDestinationToken_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool V8ContextToken_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const V8ContextToken_Data* object =
      static_cast<const V8ContextToken_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->value, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->value, validation_context))
    return false;

  return true;
}

V8ContextToken_Data::V8ContextToken_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ViewTransitionToken_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ViewTransitionToken_Data* object =
      static_cast<const ViewTransitionToken_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->value, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->value, validation_context))
    return false;

  return true;
}

ViewTransitionToken_Data::ViewTransitionToken_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebNNContextToken_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebNNContextToken_Data* object =
      static_cast<const WebNNContextToken_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->value, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->value, validation_context))
    return false;

  return true;
}

WebNNContextToken_Data::WebNNContextToken_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebNNPendingConstantToken_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebNNPendingConstantToken_Data* object =
      static_cast<const WebNNPendingConstantToken_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->value, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->value, validation_context))
    return false;

  return true;
}

WebNNPendingConstantToken_Data::WebNNPendingConstantToken_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebNNTensorToken_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebNNTensorToken_Data* object =
      static_cast<const WebNNTensorToken_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->value, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->value, validation_context))
    return false;

  return true;
}

WebNNTensorToken_Data::WebNNTensorToken_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink