// third_party/blink/public/mojom/payments/secure_payment_confirmation_service.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAYMENTS_SECURE_PAYMENT_CONFIRMATION_SERVICE_MOJOM_PARAMS_DATA_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAYMENTS_SECURE_PAYMENT_CONFIRMATION_SERVICE_MOJOM_PARAMS_DATA_H_

#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace payments::mojom {
namespace internal {
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) SecurePaymentConfirmationService_StorePaymentCredential_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> credential_id;
  mojo::internal::Pointer<mojo::internal::String_Data> rp_id;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> user_id;

 private:
  friend class mojo::internal::MessageFragment<SecurePaymentConfirmationService_StorePaymentCredential_Params_Data>;

  SecurePaymentConfirmationService_StorePaymentCredential_Params_Data();
  ~SecurePaymentConfirmationService_StorePaymentCredential_Params_Data() = delete;
};
static_assert(sizeof(SecurePaymentConfirmationService_StorePaymentCredential_Params_Data) == 32,
              "Bad sizeof(SecurePaymentConfirmationService_StorePaymentCredential_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) SecurePaymentConfirmationService_StorePaymentCredential_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t status;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<SecurePaymentConfirmationService_StorePaymentCredential_ResponseParams_Data>;

  SecurePaymentConfirmationService_StorePaymentCredential_ResponseParams_Data();
  ~SecurePaymentConfirmationService_StorePaymentCredential_ResponseParams_Data() = delete;
};
static_assert(sizeof(SecurePaymentConfirmationService_StorePaymentCredential_ResponseParams_Data) == 16,
              "Bad sizeof(SecurePaymentConfirmationService_StorePaymentCredential_ResponseParams_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) SecurePaymentConfirmationService_MakePaymentCredential_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::blink::mojom::internal::PublicKeyCredentialCreationOptions_Data> options;

 private:
  friend class mojo::internal::MessageFragment<SecurePaymentConfirmationService_MakePaymentCredential_Params_Data>;

  SecurePaymentConfirmationService_MakePaymentCredential_Params_Data();
  ~SecurePaymentConfirmationService_MakePaymentCredential_Params_Data() = delete;
};
static_assert(sizeof(SecurePaymentConfirmationService_MakePaymentCredential_Params_Data) == 16,
              "Bad sizeof(SecurePaymentConfirmationService_MakePaymentCredential_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) SecurePaymentConfirmationService_MakePaymentCredential_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t status;
  uint8_t pad0_[4];
  mojo::internal::Pointer<::blink::mojom::internal::MakeCredentialAuthenticatorResponse_Data> credential;
  mojo::internal::Pointer<::blink::mojom::internal::WebAuthnDOMExceptionDetails_Data> dom_exception_details;

 private:
  friend class mojo::internal::MessageFragment<SecurePaymentConfirmationService_MakePaymentCredential_ResponseParams_Data>;

  SecurePaymentConfirmationService_MakePaymentCredential_ResponseParams_Data();
  ~SecurePaymentConfirmationService_MakePaymentCredential_ResponseParams_Data() = delete;
};
static_assert(sizeof(SecurePaymentConfirmationService_MakePaymentCredential_ResponseParams_Data) == 32,
              "Bad sizeof(SecurePaymentConfirmationService_MakePaymentCredential_ResponseParams_Data)");

}  // namespace internal


class SecurePaymentConfirmationService_StorePaymentCredential_ParamsDataView {
 public:
  SecurePaymentConfirmationService_StorePaymentCredential_ParamsDataView() = default;

  SecurePaymentConfirmationService_StorePaymentCredential_ParamsDataView(
      internal::SecurePaymentConfirmationService_StorePaymentCredential_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetCredentialIdDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCredentialId(UserType* output) {
    
    auto* pointer = data_->credential_id.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  inline void GetRpIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRpId(UserType* output) {
    
    auto* pointer = data_->rp_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetUserIdDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUserId(UserType* output) {
    
    auto* pointer = data_->user_id.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
 private:
  internal::SecurePaymentConfirmationService_StorePaymentCredential_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SecurePaymentConfirmationService_StorePaymentCredential_ResponseParamsDataView {
 public:
  SecurePaymentConfirmationService_StorePaymentCredential_ResponseParamsDataView() = default;

  SecurePaymentConfirmationService_StorePaymentCredential_ResponseParamsDataView(
      internal::SecurePaymentConfirmationService_StorePaymentCredential_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadStatus(UserType* output) const {
    auto data_value = data_->status;
    return mojo::internal::Deserialize<::payments::mojom::PaymentCredentialStorageStatus>(
        data_value, output);
  }
  PaymentCredentialStorageStatus status() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::payments::mojom::PaymentCredentialStorageStatus>(data_->status));
  }
 private:
  internal::SecurePaymentConfirmationService_StorePaymentCredential_ResponseParams_Data* data_ = nullptr;
};


class SecurePaymentConfirmationService_MakePaymentCredential_ParamsDataView {
 public:
  SecurePaymentConfirmationService_MakePaymentCredential_ParamsDataView() = default;

  SecurePaymentConfirmationService_MakePaymentCredential_ParamsDataView(
      internal::SecurePaymentConfirmationService_MakePaymentCredential_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetOptionsDataView(
      ::blink::mojom::PublicKeyCredentialCreationOptionsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOptions(UserType* output) {
    
    auto* pointer = data_->options.Get();
    return mojo::internal::Deserialize<::blink::mojom::PublicKeyCredentialCreationOptionsDataView>(
        pointer, output, message_);
  }
 private:
  internal::SecurePaymentConfirmationService_MakePaymentCredential_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SecurePaymentConfirmationService_MakePaymentCredential_ResponseParamsDataView {
 public:
  SecurePaymentConfirmationService_MakePaymentCredential_ResponseParamsDataView() = default;

  SecurePaymentConfirmationService_MakePaymentCredential_ResponseParamsDataView(
      internal::SecurePaymentConfirmationService_MakePaymentCredential_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadStatus(UserType* output) const {
    auto data_value = data_->status;
    return mojo::internal::Deserialize<::blink::mojom::AuthenticatorStatus>(
        data_value, output);
  }
  ::blink::mojom::AuthenticatorStatus status() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::AuthenticatorStatus>(data_->status));
  }
  inline void GetCredentialDataView(
      ::blink::mojom::MakeCredentialAuthenticatorResponseDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCredential(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::MakeCredentialAuthenticatorResponseDataView, UserType>(),
    "Attempting to read the optional `credential` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCredential` instead "
    "of `ReadCredential if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->credential.Get();
    return mojo::internal::Deserialize<::blink::mojom::MakeCredentialAuthenticatorResponseDataView>(
        pointer, output, message_);
  }
  inline void GetDomExceptionDetailsDataView(
      ::blink::mojom::WebAuthnDOMExceptionDetailsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDomExceptionDetails(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::WebAuthnDOMExceptionDetailsDataView, UserType>(),
    "Attempting to read the optional `dom_exception_details` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDomExceptionDetails` instead "
    "of `ReadDomExceptionDetails if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->dom_exception_details.Get();
    return mojo::internal::Deserialize<::blink::mojom::WebAuthnDOMExceptionDetailsDataView>(
        pointer, output, message_);
  }
 private:
  internal::SecurePaymentConfirmationService_MakePaymentCredential_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};

inline void SecurePaymentConfirmationService_StorePaymentCredential_ParamsDataView::GetCredentialIdDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->credential_id.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}
inline void SecurePaymentConfirmationService_StorePaymentCredential_ParamsDataView::GetRpIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->rp_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void SecurePaymentConfirmationService_StorePaymentCredential_ParamsDataView::GetUserIdDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->user_id.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}




inline void SecurePaymentConfirmationService_MakePaymentCredential_ParamsDataView::GetOptionsDataView(
    ::blink::mojom::PublicKeyCredentialCreationOptionsDataView* output) {
  auto pointer = data_->options.Get();
  *output = ::blink::mojom::PublicKeyCredentialCreationOptionsDataView(pointer, message_);
}


inline void SecurePaymentConfirmationService_MakePaymentCredential_ResponseParamsDataView::GetCredentialDataView(
    ::blink::mojom::MakeCredentialAuthenticatorResponseDataView* output) {
  auto pointer = data_->credential.Get();
  *output = ::blink::mojom::MakeCredentialAuthenticatorResponseDataView(pointer, message_);
}
inline void SecurePaymentConfirmationService_MakePaymentCredential_ResponseParamsDataView::GetDomExceptionDetailsDataView(
    ::blink::mojom::WebAuthnDOMExceptionDetailsDataView* output) {
  auto pointer = data_->dom_exception_details.Get();
  *output = ::blink::mojom::WebAuthnDOMExceptionDetailsDataView(pointer, message_);
}



}  // payments::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAYMENTS_SECURE_PAYMENT_CONFIRMATION_SERVICE_MOJOM_PARAMS_DATA_H_