// third_party/blink/public/mojom/content_extraction/inner_text.mojom-shared-internal.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_CONTENT_EXTRACTION_INNER_TEXT_MOJOM_SHARED_INTERNAL_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_CONTENT_EXTRACTION_INNER_TEXT_MOJOM_SHARED_INTERNAL_H_
#include "mojo/public/cpp/bindings/lib/array_internal.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/map_data_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/native_enum_data.h"
#include "mojo/public/interfaces/bindings/native_struct.mojom-shared-internal.h"
#include "base/component_export.h"



namespace mojo {
namespace internal {
class ValidationContext;
}
}


namespace blink::mojom {
namespace internal {
class InnerTextFrame_Data;
class InnerTextParams_Data;
class InnerTextSegment_Data;

struct NodeLocationType_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

#pragma pack(push, 1)


class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) InnerTextSegment_Data {
 public:
  // Used to identify Mojom Union Data Classes.
  typedef void MojomUnionDataType;

  InnerTextSegment_Data() = default;
  // Do nothing in the destructor since it won't be called when it is a
  // non-inlined union.
  ~InnerTextSegment_Data() = default;

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context,
                       bool inlined);

  bool is_null() const { return size == 0; }

  void set_null() {
    size = 0U;
    tag = static_cast<InnerTextSegment_Tag>(0);
    data.unknown = 0U;
  }

  // TODO(crbug.com/40731316): SHOUTY_CASE values are being deprecated per C++ code style
  // guidelines (https://google.github.io/styleguide/cppguide.html#Enumerator_Names),
  // please use kCamelCase values instead.  Cleanup NULL_VALUE, BOOL_VALUE, INT_VALUE, etc.
  // generation once codebase is transitioned to kNullValue, kBoolValue, kIntValue, etc.
  enum class InnerTextSegment_Tag : uint32_t {

    
    kNodeLocation,
    
    kText,
    
    kFrame,
  };

  // A note on layout:
  // "Each non-static data member is allocated as if it were the sole member of
  // a struct." - Section 9.5.2 ISO/IEC 14882:2011 (The C++ Spec)
  union MOJO_ALIGNAS(8) Union_ {
    Union_() : unknown(0) {}
    int32_t f_node_location;
    mojo::internal::Pointer<mojo::internal::String_Data> f_text;
    mojo::internal::Pointer<internal::InnerTextFrame_Data> f_frame;
    uint64_t unknown;
  };

  uint32_t size;
  InnerTextSegment_Tag tag;
  Union_ data;
};
static_assert(sizeof(InnerTextSegment_Data) == mojo::internal::kUnionDataSize,
              "Bad sizeof(InnerTextSegment_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) InnerTextFrame_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::blink::mojom::internal::LocalFrameToken_Data> token;
  mojo::internal::Pointer<mojo::internal::Array_Data<internal::InnerTextSegment_Data>> segments;

 private:
  friend class mojo::internal::MessageFragment<InnerTextFrame_Data>;

  InnerTextFrame_Data();
  ~InnerTextFrame_Data() = delete;
};
static_assert(sizeof(InnerTextFrame_Data) == 24,
              "Bad sizeof(InnerTextFrame_Data)");
// Used by InnerTextFrame::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct InnerTextFrame_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  InnerTextFrame_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~InnerTextFrame_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<InnerTextFrame_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    InnerTextFrame_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) InnerTextParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t node_id_$flag : 1;
  uint8_t max_words_per_aggregate_passage_$flag : 1;
  uint8_t greedily_aggregate_sibling_nodes_$flag : 1;
  uint8_t greedily_aggregate_sibling_nodes_$value : 1;
  uint8_t min_words_per_passage_$flag : 1;
  uint8_t pad4_[3];
  int32_t node_id_$value;
  uint32_t max_words_per_aggregate_passage_$value;
  uint32_t max_passages;
  uint32_t min_words_per_passage_$value;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<InnerTextParams_Data>;

  InnerTextParams_Data();
  ~InnerTextParams_Data() = delete;
};
static_assert(sizeof(InnerTextParams_Data) == 32,
              "Bad sizeof(InnerTextParams_Data)");
// Used by InnerTextParams::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct InnerTextParams_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  InnerTextParams_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~InnerTextParams_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<InnerTextParams_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    InnerTextParams_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};

#pragma pack(pop)

}  // namespace internal

}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_CONTENT_EXTRACTION_INNER_TEXT_MOJOM_SHARED_INTERNAL_H_