// services/metrics/public/mojom/ukm_interface.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/metrics/public/mojom/ukm_interface.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/metrics/public/mojom/ukm_interface.mojom-params-data.h"
#include "services/metrics/public/mojom/ukm_interface.mojom-shared-message-ids.h"

#include "services/metrics/public/mojom/ukm_interface.mojom-import-headers.h"
#include "services/metrics/public/mojom/ukm_interface.mojom-test-utils.h"


namespace ukm::mojom {
UkmEntry::UkmEntry()
    : source_id(),
      event_hash(),
      metrics() {}

UkmEntry::UkmEntry(
    int64_t source_id_in,
    uint64_t event_hash_in,
    const base::flat_map<uint64_t, int64_t>& metrics_in)
    : source_id(std::move(source_id_in)),
      event_hash(std::move(event_hash_in)),
      metrics(std::move(metrics_in)) {}

UkmEntry::~UkmEntry() = default;

void UkmEntry::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "source_id"), this->source_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "event_hash"), this->event_hash,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "metrics"), this->metrics,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const base::flat_map<uint64_t, int64_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool UkmEntry::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
UkmRecorderParameters::UkmRecorderParameters()
    : is_enabled(),
      event_hash_bypass_list() {}

UkmRecorderParameters::UkmRecorderParameters(
    bool is_enabled_in,
    std::vector<uint64_t> event_hash_bypass_list_in)
    : is_enabled(std::move(is_enabled_in)),
      event_hash_bypass_list(std::move(event_hash_bypass_list_in)) {}

UkmRecorderParameters::~UkmRecorderParameters() = default;

void UkmRecorderParameters::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_enabled"), this->is_enabled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "event_hash_bypass_list"), this->event_hash_bypass_list,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<uint64_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool UkmRecorderParameters::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char SingularUkmInterface::Name_[] = "ukm.mojom.SingularUkmInterface";

SingularUkmInterface::IPCStableHashFunction SingularUkmInterface::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::SingularUkmInterface>(message.name())) {
    case messages::SingularUkmInterface::kSubmit: {
      return &SingularUkmInterface::Submit_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* SingularUkmInterface::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::SingularUkmInterface>(message.name())) {
      case messages::SingularUkmInterface::kSubmit:
            return "Receive ukm::mojom::SingularUkmInterface::Submit";
    }
  } else {
    switch (static_cast<messages::SingularUkmInterface>(message.name())) {
      case messages::SingularUkmInterface::kSubmit:
            return "Receive reply ukm::mojom::SingularUkmInterface::Submit";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t SingularUkmInterface::Submit_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)ukm::mojom::SingularUkmInterface::Submit");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

SingularUkmInterfaceProxy::SingularUkmInterfaceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SingularUkmInterfaceProxy::Submit(
    UkmEntryPtr in_entry) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send ukm::mojom::SingularUkmInterface::Submit", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("entry"), in_entry,
                        "<value of type UkmEntryPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SingularUkmInterface::kSubmit), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::ukm::mojom::internal::SingularUkmInterface_Submit_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->entry)::BaseType> entry_fragment(
          params.message());
  mojo::internal::Serialize<::ukm::mojom::UkmEntryDataView>(
      in_entry, entry_fragment);
  params->entry.Set(
      entry_fragment.is_null() ? nullptr : entry_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->entry.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null entry in SingularUkmInterface.Submit request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SingularUkmInterface::Name_);
  message.set_method_name("Submit");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool SingularUkmInterfaceStubDispatch::Accept(
    SingularUkmInterface* impl,
    mojo::Message* message) {
  switch (static_cast<messages::SingularUkmInterface>(message->header()->name)) {
    case messages::SingularUkmInterface::kSubmit: {
      DCHECK(message->is_serialized());
      internal::SingularUkmInterface_Submit_Params_Data* params =
          reinterpret_cast<internal::SingularUkmInterface_Submit_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for SingularUkmInterface.0
      bool success = true;
      UkmEntryPtr p_entry{};
      SingularUkmInterface_Submit_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEntry(&p_entry))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SingularUkmInterface::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Submit(        
        std::move(p_entry));
      return true;
    }
  }
  return false;
}

// static
bool SingularUkmInterfaceStubDispatch::AcceptWithResponder(
    SingularUkmInterface* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::SingularUkmInterface>(message->header()->name)) {
    case messages::SingularUkmInterface::kSubmit: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kSingularUkmInterfaceValidationInfo[] = {
    {base::to_underlying(messages::SingularUkmInterface::kSubmit),
     { &internal::SingularUkmInterface_Submit_Params_Data::Validate,
      nullptr /* no response */}},
};

bool SingularUkmInterfaceRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::ukm::mojom::SingularUkmInterface::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kSingularUkmInterfaceValidationInfo);
}

const char UkmRecorderClientInterface::Name_[] = "ukm.mojom.UkmRecorderClientInterface";

UkmRecorderClientInterface::IPCStableHashFunction UkmRecorderClientInterface::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::UkmRecorderClientInterface>(message.name())) {
    case messages::UkmRecorderClientInterface::kSetParameters: {
      return &UkmRecorderClientInterface::SetParameters_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* UkmRecorderClientInterface::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::UkmRecorderClientInterface>(message.name())) {
      case messages::UkmRecorderClientInterface::kSetParameters:
            return "Receive ukm::mojom::UkmRecorderClientInterface::SetParameters";
    }
  } else {
    switch (static_cast<messages::UkmRecorderClientInterface>(message.name())) {
      case messages::UkmRecorderClientInterface::kSetParameters:
            return "Receive reply ukm::mojom::UkmRecorderClientInterface::SetParameters";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t UkmRecorderClientInterface::SetParameters_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)ukm::mojom::UkmRecorderClientInterface::SetParameters");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

UkmRecorderClientInterfaceProxy::UkmRecorderClientInterfaceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void UkmRecorderClientInterfaceProxy::SetParameters(
    UkmRecorderParametersPtr in_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send ukm::mojom::UkmRecorderClientInterface::SetParameters", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type UkmRecorderParametersPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UkmRecorderClientInterface::kSetParameters), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::ukm::mojom::internal::UkmRecorderClientInterface_SetParameters_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  mojo::internal::Serialize<::ukm::mojom::UkmRecorderParametersDataView>(
      in_params, params_fragment);
  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in UkmRecorderClientInterface.SetParameters request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UkmRecorderClientInterface::Name_);
  message.set_method_name("SetParameters");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool UkmRecorderClientInterfaceStubDispatch::Accept(
    UkmRecorderClientInterface* impl,
    mojo::Message* message) {
  switch (static_cast<messages::UkmRecorderClientInterface>(message->header()->name)) {
    case messages::UkmRecorderClientInterface::kSetParameters: {
      DCHECK(message->is_serialized());
      internal::UkmRecorderClientInterface_SetParameters_Params_Data* params =
          reinterpret_cast<internal::UkmRecorderClientInterface_SetParameters_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for UkmRecorderClientInterface.0
      bool success = true;
      UkmRecorderParametersPtr p_params{};
      UkmRecorderClientInterface_SetParameters_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UkmRecorderClientInterface::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetParameters(        
        std::move(p_params));
      return true;
    }
  }
  return false;
}

// static
bool UkmRecorderClientInterfaceStubDispatch::AcceptWithResponder(
    UkmRecorderClientInterface* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::UkmRecorderClientInterface>(message->header()->name)) {
    case messages::UkmRecorderClientInterface::kSetParameters: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kUkmRecorderClientInterfaceValidationInfo[] = {
    {base::to_underlying(messages::UkmRecorderClientInterface::kSetParameters),
     { &internal::UkmRecorderClientInterface_SetParameters_Params_Data::Validate,
      nullptr /* no response */}},
};

bool UkmRecorderClientInterfaceRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::ukm::mojom::UkmRecorderClientInterface::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kUkmRecorderClientInterfaceValidationInfo);
}

const char UkmRecorderInterface::Name_[] = "ukm.mojom.UkmRecorderInterface";

UkmRecorderInterface::IPCStableHashFunction UkmRecorderInterface::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::UkmRecorderInterface>(message.name())) {
    case messages::UkmRecorderInterface::kAddEntry: {
      return &UkmRecorderInterface::AddEntry_Sym::IPCStableHash;
    }
    case messages::UkmRecorderInterface::kUpdateSourceURL: {
      return &UkmRecorderInterface::UpdateSourceURL_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* UkmRecorderInterface::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::UkmRecorderInterface>(message.name())) {
      case messages::UkmRecorderInterface::kAddEntry:
            return "Receive ukm::mojom::UkmRecorderInterface::AddEntry";
      case messages::UkmRecorderInterface::kUpdateSourceURL:
            return "Receive ukm::mojom::UkmRecorderInterface::UpdateSourceURL";
    }
  } else {
    switch (static_cast<messages::UkmRecorderInterface>(message.name())) {
      case messages::UkmRecorderInterface::kAddEntry:
            return "Receive reply ukm::mojom::UkmRecorderInterface::AddEntry";
      case messages::UkmRecorderInterface::kUpdateSourceURL:
            return "Receive reply ukm::mojom::UkmRecorderInterface::UpdateSourceURL";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t UkmRecorderInterface::AddEntry_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)ukm::mojom::UkmRecorderInterface::AddEntry");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t UkmRecorderInterface::UpdateSourceURL_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)ukm::mojom::UkmRecorderInterface::UpdateSourceURL");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

UkmRecorderInterfaceProxy::UkmRecorderInterfaceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void UkmRecorderInterfaceProxy::AddEntry(
    UkmEntryPtr in_entry) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send ukm::mojom::UkmRecorderInterface::AddEntry", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("entry"), in_entry,
                        "<value of type UkmEntryPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UkmRecorderInterface::kAddEntry), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::ukm::mojom::internal::UkmRecorderInterface_AddEntry_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->entry)::BaseType> entry_fragment(
          params.message());
  mojo::internal::Serialize<::ukm::mojom::UkmEntryDataView>(
      in_entry, entry_fragment);
  params->entry.Set(
      entry_fragment.is_null() ? nullptr : entry_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->entry.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null entry in UkmRecorderInterface.AddEntry request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UkmRecorderInterface::Name_);
  message.set_method_name("AddEntry");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void UkmRecorderInterfaceProxy::UpdateSourceURL(
    int64_t in_source_id, const std::string& in_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send ukm::mojom::UkmRecorderInterface::UpdateSourceURL", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source_id"), in_source_id,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UkmRecorderInterface::kUpdateSourceURL), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::ukm::mojom::internal::UkmRecorderInterface_UpdateSourceURL_Params_Data> params(
          message);
  params.Allocate();
  params->source_id = in_source_id;
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_url, url_fragment);
  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in UkmRecorderInterface.UpdateSourceURL request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UkmRecorderInterface::Name_);
  message.set_method_name("UpdateSourceURL");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool UkmRecorderInterfaceStubDispatch::Accept(
    UkmRecorderInterface* impl,
    mojo::Message* message) {
  switch (static_cast<messages::UkmRecorderInterface>(message->header()->name)) {
    case messages::UkmRecorderInterface::kAddEntry: {
      DCHECK(message->is_serialized());
      internal::UkmRecorderInterface_AddEntry_Params_Data* params =
          reinterpret_cast<internal::UkmRecorderInterface_AddEntry_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for UkmRecorderInterface.0
      bool success = true;
      UkmEntryPtr p_entry{};
      UkmRecorderInterface_AddEntry_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEntry(&p_entry))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UkmRecorderInterface::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddEntry(        
        std::move(p_entry));
      return true;
    }
    case messages::UkmRecorderInterface::kUpdateSourceURL: {
      DCHECK(message->is_serialized());
      internal::UkmRecorderInterface_UpdateSourceURL_Params_Data* params =
          reinterpret_cast<internal::UkmRecorderInterface_UpdateSourceURL_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for UkmRecorderInterface.1
      bool success = true;
      int64_t p_source_id{};
      std::string p_url{};
      UkmRecorderInterface_UpdateSourceURL_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_source_id = input_data_view.source_id();
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UkmRecorderInterface::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateSourceURL(        
        std::move(p_source_id), 
        std::move(p_url));
      return true;
    }
  }
  return false;
}

// static
bool UkmRecorderInterfaceStubDispatch::AcceptWithResponder(
    UkmRecorderInterface* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::UkmRecorderInterface>(message->header()->name)) {
    case messages::UkmRecorderInterface::kAddEntry: {
      break;
    }
    case messages::UkmRecorderInterface::kUpdateSourceURL: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kUkmRecorderInterfaceValidationInfo[] = {
    {base::to_underlying(messages::UkmRecorderInterface::kAddEntry),
     { &internal::UkmRecorderInterface_AddEntry_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::UkmRecorderInterface::kUpdateSourceURL),
     { &internal::UkmRecorderInterface_UpdateSourceURL_Params_Data::Validate,
      nullptr /* no response */}},
};

bool UkmRecorderInterfaceRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::ukm::mojom::UkmRecorderInterface::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kUkmRecorderInterfaceValidationInfo);
}

const char UkmRecorderFactory::Name_[] = "ukm.mojom.UkmRecorderFactory";

UkmRecorderFactory::IPCStableHashFunction UkmRecorderFactory::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::UkmRecorderFactory>(message.name())) {
    case messages::UkmRecorderFactory::kCreateUkmRecorder: {
      return &UkmRecorderFactory::CreateUkmRecorder_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* UkmRecorderFactory::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::UkmRecorderFactory>(message.name())) {
      case messages::UkmRecorderFactory::kCreateUkmRecorder:
            return "Receive ukm::mojom::UkmRecorderFactory::CreateUkmRecorder";
    }
  } else {
    switch (static_cast<messages::UkmRecorderFactory>(message.name())) {
      case messages::UkmRecorderFactory::kCreateUkmRecorder:
            return "Receive reply ukm::mojom::UkmRecorderFactory::CreateUkmRecorder";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t UkmRecorderFactory::CreateUkmRecorder_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)ukm::mojom::UkmRecorderFactory::CreateUkmRecorder");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

UkmRecorderFactoryProxy::UkmRecorderFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void UkmRecorderFactoryProxy::CreateUkmRecorder(
    ::mojo::PendingReceiver<UkmRecorderInterface> in_receiver, ::mojo::PendingRemote<UkmRecorderClientInterface> in_client_remote) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send ukm::mojom::UkmRecorderFactory::CreateUkmRecorder", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<UkmRecorderInterface>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client_remote"), in_client_remote,
                        "<value of type ::mojo::PendingRemote<UkmRecorderClientInterface>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UkmRecorderFactory::kCreateUkmRecorder), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::ukm::mojom::internal::UkmRecorderFactory_CreateUkmRecorder_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::ukm::mojom::UkmRecorderInterfaceInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in UkmRecorderFactory.CreateUkmRecorder request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::ukm::mojom::UkmRecorderClientInterfaceInterfaceBase>>(
      in_client_remote, &params->client_remote, &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UkmRecorderFactory::Name_);
  message.set_method_name("CreateUkmRecorder");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool UkmRecorderFactoryStubDispatch::Accept(
    UkmRecorderFactory* impl,
    mojo::Message* message) {
  switch (static_cast<messages::UkmRecorderFactory>(message->header()->name)) {
    case messages::UkmRecorderFactory::kCreateUkmRecorder: {
      DCHECK(message->is_serialized());
      internal::UkmRecorderFactory_CreateUkmRecorder_Params_Data* params =
          reinterpret_cast<internal::UkmRecorderFactory_CreateUkmRecorder_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for UkmRecorderFactory.0
      bool success = true;
      ::mojo::PendingReceiver<UkmRecorderInterface> p_receiver{};
      ::mojo::PendingRemote<UkmRecorderClientInterface> p_client_remote{};
      UkmRecorderFactory_CreateUkmRecorder_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (success) {
        p_client_remote =
            input_data_view.TakeClientRemote<decltype(p_client_remote)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UkmRecorderFactory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateUkmRecorder(        
        std::move(p_receiver), 
        std::move(p_client_remote));
      return true;
    }
  }
  return false;
}

// static
bool UkmRecorderFactoryStubDispatch::AcceptWithResponder(
    UkmRecorderFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::UkmRecorderFactory>(message->header()->name)) {
    case messages::UkmRecorderFactory::kCreateUkmRecorder: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kUkmRecorderFactoryValidationInfo[] = {
    {base::to_underlying(messages::UkmRecorderFactory::kCreateUkmRecorder),
     { &internal::UkmRecorderFactory_CreateUkmRecorder_Params_Data::Validate,
      nullptr /* no response */}},
};

bool UkmRecorderFactoryRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::ukm::mojom::UkmRecorderFactory::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kUkmRecorderFactoryValidationInfo);
}



}  // ukm::mojom


namespace mojo {


// static
bool StructTraits<::ukm::mojom::UkmEntry::DataView, ::ukm::mojom::UkmEntryPtr>::Read(
    ::ukm::mojom::UkmEntry::DataView input,
    ::ukm::mojom::UkmEntryPtr* output) {
  bool success = true;
  ::ukm::mojom::UkmEntryPtr result(::ukm::mojom::UkmEntry::New());
  
      if (success)
        result->source_id = input.source_id();
      if (success)
        result->event_hash = input.event_hash();
      if (success && !input.ReadMetrics(&result->metrics))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::ukm::mojom::UkmRecorderParameters::DataView, ::ukm::mojom::UkmRecorderParametersPtr>::Read(
    ::ukm::mojom::UkmRecorderParameters::DataView input,
    ::ukm::mojom::UkmRecorderParametersPtr* output) {
  bool success = true;
  ::ukm::mojom::UkmRecorderParametersPtr result(::ukm::mojom::UkmRecorderParameters::New());
  
      if (success)
        result->is_enabled = input.is_enabled();
      if (success && !input.ReadEventHashBypassList(&result->event_hash_bypass_list))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace ukm::mojom {


void SingularUkmInterfaceInterceptorForTesting::Submit(UkmEntryPtr entry) {
  GetForwardingInterface()->Submit(
    std::move(entry)
    );
}
SingularUkmInterfaceAsyncWaiter::SingularUkmInterfaceAsyncWaiter(
    SingularUkmInterface* proxy) : proxy_(proxy) {}

SingularUkmInterfaceAsyncWaiter::~SingularUkmInterfaceAsyncWaiter() = default;




void UkmRecorderClientInterfaceInterceptorForTesting::SetParameters(UkmRecorderParametersPtr params) {
  GetForwardingInterface()->SetParameters(
    std::move(params)
    );
}
UkmRecorderClientInterfaceAsyncWaiter::UkmRecorderClientInterfaceAsyncWaiter(
    UkmRecorderClientInterface* proxy) : proxy_(proxy) {}

UkmRecorderClientInterfaceAsyncWaiter::~UkmRecorderClientInterfaceAsyncWaiter() = default;




void UkmRecorderInterfaceInterceptorForTesting::AddEntry(UkmEntryPtr entry) {
  GetForwardingInterface()->AddEntry(
    std::move(entry)
    );
}
void UkmRecorderInterfaceInterceptorForTesting::UpdateSourceURL(int64_t source_id, const std::string& url) {
  GetForwardingInterface()->UpdateSourceURL(
    std::move(source_id)
    , 
    std::move(url)
    );
}
UkmRecorderInterfaceAsyncWaiter::UkmRecorderInterfaceAsyncWaiter(
    UkmRecorderInterface* proxy) : proxy_(proxy) {}

UkmRecorderInterfaceAsyncWaiter::~UkmRecorderInterfaceAsyncWaiter() = default;




void UkmRecorderFactoryInterceptorForTesting::CreateUkmRecorder(::mojo::PendingReceiver<UkmRecorderInterface> receiver, ::mojo::PendingRemote<UkmRecorderClientInterface> client_remote) {
  GetForwardingInterface()->CreateUkmRecorder(
    std::move(receiver)
    , 
    std::move(client_remote)
    );
}
UkmRecorderFactoryAsyncWaiter::UkmRecorderFactoryAsyncWaiter(
    UkmRecorderFactory* proxy) : proxy_(proxy) {}

UkmRecorderFactoryAsyncWaiter::~UkmRecorderFactoryAsyncWaiter() = default;






}  // ukm::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif