// media/mojo/mojom/renderer_extensions.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "media/mojo/mojom/renderer_extensions.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/mojo/mojom/renderer_extensions.mojom-params-data.h"
#include "media/mojo/mojom/renderer_extensions.mojom-shared-message-ids.h"

#include "media/mojo/mojom/renderer_extensions.mojom-blink-import-headers.h"
#include "media/mojo/mojom/renderer_extensions.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace media::mojom::blink {
const char MediaPlayerRendererClientExtension::Name_[] = "media.mojom.MediaPlayerRendererClientExtension";

MediaPlayerRendererClientExtension::IPCStableHashFunction MediaPlayerRendererClientExtension::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::MediaPlayerRendererClientExtension>(message.name())) {
    case messages::MediaPlayerRendererClientExtension::kOnVideoSizeChange: {
      return &MediaPlayerRendererClientExtension::OnVideoSizeChange_Sym::IPCStableHash;
    }
    case messages::MediaPlayerRendererClientExtension::kOnDurationChange: {
      return &MediaPlayerRendererClientExtension::OnDurationChange_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* MediaPlayerRendererClientExtension::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::MediaPlayerRendererClientExtension>(message.name())) {
      case messages::MediaPlayerRendererClientExtension::kOnVideoSizeChange:
            return "Receive media::mojom::MediaPlayerRendererClientExtension::OnVideoSizeChange";
      case messages::MediaPlayerRendererClientExtension::kOnDurationChange:
            return "Receive media::mojom::MediaPlayerRendererClientExtension::OnDurationChange";
    }
  } else {
    switch (static_cast<messages::MediaPlayerRendererClientExtension>(message.name())) {
      case messages::MediaPlayerRendererClientExtension::kOnVideoSizeChange:
            return "Receive reply media::mojom::MediaPlayerRendererClientExtension::OnVideoSizeChange";
      case messages::MediaPlayerRendererClientExtension::kOnDurationChange:
            return "Receive reply media::mojom::MediaPlayerRendererClientExtension::OnDurationChange";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t MediaPlayerRendererClientExtension::OnVideoSizeChange_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)media::mojom::MediaPlayerRendererClientExtension::OnVideoSizeChange");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaPlayerRendererClientExtension::OnDurationChange_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)media::mojom::MediaPlayerRendererClientExtension::OnDurationChange");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

MediaPlayerRendererClientExtensionProxy::MediaPlayerRendererClientExtensionProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void MediaPlayerRendererClientExtensionProxy::OnVideoSizeChange(
    const ::gfx::Size& in_size) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::MediaPlayerRendererClientExtension::OnVideoSizeChange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("size"), in_size,
                        "<value of type const ::gfx::Size&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaPlayerRendererClientExtension::kOnVideoSizeChange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaPlayerRendererClientExtension_OnVideoSizeChange_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->size)::BaseType> size_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_size, size_fragment);
  params->size.Set(
      size_fragment.is_null() ? nullptr : size_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->size.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null size in MediaPlayerRendererClientExtension.OnVideoSizeChange request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaPlayerRendererClientExtension::Name_);
  message.set_method_name("OnVideoSizeChange");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaPlayerRendererClientExtensionProxy::OnDurationChange(
    ::base::TimeDelta in_duration) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::MediaPlayerRendererClientExtension::OnDurationChange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("duration"), in_duration,
                        "<value of type ::base::TimeDelta>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaPlayerRendererClientExtension::kOnDurationChange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaPlayerRendererClientExtension_OnDurationChange_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->duration)::BaseType> duration_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_duration, duration_fragment);
  params->duration.Set(
      duration_fragment.is_null() ? nullptr : duration_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->duration.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null duration in MediaPlayerRendererClientExtension.OnDurationChange request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaPlayerRendererClientExtension::Name_);
  message.set_method_name("OnDurationChange");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool MediaPlayerRendererClientExtensionStubDispatch::Accept(
    MediaPlayerRendererClientExtension* impl,
    mojo::Message* message) {
  switch (static_cast<messages::MediaPlayerRendererClientExtension>(message->header()->name)) {
    case messages::MediaPlayerRendererClientExtension::kOnVideoSizeChange: {
      DCHECK(message->is_serialized());
      internal::MediaPlayerRendererClientExtension_OnVideoSizeChange_Params_Data* params =
          reinterpret_cast<internal::MediaPlayerRendererClientExtension_OnVideoSizeChange_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for MediaPlayerRendererClientExtension.0
      bool success = true;
      ::gfx::Size p_size{};
      MediaPlayerRendererClientExtension_OnVideoSizeChange_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSize(&p_size))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaPlayerRendererClientExtension::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnVideoSizeChange(        
        std::move(p_size));
      return true;
    }
    case messages::MediaPlayerRendererClientExtension::kOnDurationChange: {
      DCHECK(message->is_serialized());
      internal::MediaPlayerRendererClientExtension_OnDurationChange_Params_Data* params =
          reinterpret_cast<internal::MediaPlayerRendererClientExtension_OnDurationChange_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for MediaPlayerRendererClientExtension.1
      bool success = true;
      ::base::TimeDelta p_duration{};
      MediaPlayerRendererClientExtension_OnDurationChange_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDuration(&p_duration))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaPlayerRendererClientExtension::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnDurationChange(        
        std::move(p_duration));
      return true;
    }
  }
  return false;
}

// static
bool MediaPlayerRendererClientExtensionStubDispatch::AcceptWithResponder(
    MediaPlayerRendererClientExtension* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::MediaPlayerRendererClientExtension>(message->header()->name)) {
    case messages::MediaPlayerRendererClientExtension::kOnVideoSizeChange: {
      break;
    }
    case messages::MediaPlayerRendererClientExtension::kOnDurationChange: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kMediaPlayerRendererClientExtensionValidationInfo[] = {
    {base::to_underlying(messages::MediaPlayerRendererClientExtension::kOnVideoSizeChange),
     { &internal::MediaPlayerRendererClientExtension_OnVideoSizeChange_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::MediaPlayerRendererClientExtension::kOnDurationChange),
     { &internal::MediaPlayerRendererClientExtension_OnDurationChange_Params_Data::Validate,
      nullptr /* no response */}},
};

bool MediaPlayerRendererClientExtensionRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::blink::MediaPlayerRendererClientExtension::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kMediaPlayerRendererClientExtensionValidationInfo);
}

const char MediaPlayerRendererExtension::Name_[] = "media.mojom.MediaPlayerRendererExtension";

MediaPlayerRendererExtension::IPCStableHashFunction MediaPlayerRendererExtension::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::MediaPlayerRendererExtension>(message.name())) {
    case messages::MediaPlayerRendererExtension::kInitiateScopedSurfaceRequest: {
      return &MediaPlayerRendererExtension::InitiateScopedSurfaceRequest_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* MediaPlayerRendererExtension::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::MediaPlayerRendererExtension>(message.name())) {
      case messages::MediaPlayerRendererExtension::kInitiateScopedSurfaceRequest:
            return "Receive media::mojom::MediaPlayerRendererExtension::InitiateScopedSurfaceRequest";
    }
  } else {
    switch (static_cast<messages::MediaPlayerRendererExtension>(message.name())) {
      case messages::MediaPlayerRendererExtension::kInitiateScopedSurfaceRequest:
            return "Receive reply media::mojom::MediaPlayerRendererExtension::InitiateScopedSurfaceRequest";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t MediaPlayerRendererExtension::InitiateScopedSurfaceRequest_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)media::mojom::MediaPlayerRendererExtension::InitiateScopedSurfaceRequest");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class MediaPlayerRendererExtension_InitiateScopedSurfaceRequest_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  MediaPlayerRendererExtension_InitiateScopedSurfaceRequest_ForwardToCallback(
      MediaPlayerRendererExtension::InitiateScopedSurfaceRequestCallback callback
      ) : callback_(std::move(callback)) {
  }

  MediaPlayerRendererExtension_InitiateScopedSurfaceRequest_ForwardToCallback(const MediaPlayerRendererExtension_InitiateScopedSurfaceRequest_ForwardToCallback&) = delete;
  MediaPlayerRendererExtension_InitiateScopedSurfaceRequest_ForwardToCallback& operator=(const MediaPlayerRendererExtension_InitiateScopedSurfaceRequest_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  MediaPlayerRendererExtension::InitiateScopedSurfaceRequestCallback callback_;
};

MediaPlayerRendererExtensionProxy::MediaPlayerRendererExtensionProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void MediaPlayerRendererExtensionProxy::InitiateScopedSurfaceRequest(
    InitiateScopedSurfaceRequestCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media::mojom::MediaPlayerRendererExtension::InitiateScopedSurfaceRequest");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaPlayerRendererExtension::kInitiateScopedSurfaceRequest), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaPlayerRendererExtension_InitiateScopedSurfaceRequest_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaPlayerRendererExtension::Name_);
  message.set_method_name("InitiateScopedSurfaceRequest");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new MediaPlayerRendererExtension_InitiateScopedSurfaceRequest_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class MediaPlayerRendererExtension_InitiateScopedSurfaceRequest_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static MediaPlayerRendererExtension::InitiateScopedSurfaceRequestCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<MediaPlayerRendererExtension_InitiateScopedSurfaceRequest_ProxyToResponder> proxy(
        new MediaPlayerRendererExtension_InitiateScopedSurfaceRequest_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&MediaPlayerRendererExtension_InitiateScopedSurfaceRequest_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~MediaPlayerRendererExtension_InitiateScopedSurfaceRequest_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  MediaPlayerRendererExtension_InitiateScopedSurfaceRequest_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "MediaPlayerRendererExtension::InitiateScopedSurfaceRequestCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::base::UnguessableToken& in_request_token);
};

bool MediaPlayerRendererExtension_InitiateScopedSurfaceRequest_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::MediaPlayerRendererExtension_InitiateScopedSurfaceRequest_ResponseParams_Data* params =
      reinterpret_cast<
          internal::MediaPlayerRendererExtension_InitiateScopedSurfaceRequest_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for MediaPlayerRendererExtension.0
  bool success = true;
  ::base::UnguessableToken p_request_token{};
  MediaPlayerRendererExtension_InitiateScopedSurfaceRequest_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadRequestToken(&p_request_token))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        MediaPlayerRendererExtension::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_request_token));
  return true;
}

void MediaPlayerRendererExtension_InitiateScopedSurfaceRequest_ProxyToResponder::Run(
    const ::base::UnguessableToken& in_request_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media::mojom::MediaPlayerRendererExtension::InitiateScopedSurfaceRequest", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_token"), in_request_token,
                        "<value of type const ::base::UnguessableToken&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaPlayerRendererExtension::kInitiateScopedSurfaceRequest), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaPlayerRendererExtension_InitiateScopedSurfaceRequest_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->request_token)::BaseType> request_token_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_request_token, request_token_fragment);
  params->request_token.Set(
      request_token_fragment.is_null() ? nullptr : request_token_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->request_token.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null request_token in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaPlayerRendererExtension::Name_);
  message.set_method_name("InitiateScopedSurfaceRequest");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool MediaPlayerRendererExtensionStubDispatch::Accept(
    MediaPlayerRendererExtension* impl,
    mojo::Message* message) {
  switch (static_cast<messages::MediaPlayerRendererExtension>(message->header()->name)) {
    case messages::MediaPlayerRendererExtension::kInitiateScopedSurfaceRequest: {
      break;
    }
  }
  return false;
}

// static
bool MediaPlayerRendererExtensionStubDispatch::AcceptWithResponder(
    MediaPlayerRendererExtension* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::MediaPlayerRendererExtension>(message->header()->name)) {
    case messages::MediaPlayerRendererExtension::kInitiateScopedSurfaceRequest: {
      internal::MediaPlayerRendererExtension_InitiateScopedSurfaceRequest_Params_Data* params =
          reinterpret_cast<
              internal::MediaPlayerRendererExtension_InitiateScopedSurfaceRequest_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for MediaPlayerRendererExtension.0
      bool success = true;
      MediaPlayerRendererExtension_InitiateScopedSurfaceRequest_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaPlayerRendererExtension::Name_, 0, false);
        return false;
      }
      MediaPlayerRendererExtension::InitiateScopedSurfaceRequestCallback callback =
          MediaPlayerRendererExtension_InitiateScopedSurfaceRequest_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->InitiateScopedSurfaceRequest(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kMediaPlayerRendererExtensionValidationInfo[] = {
    {base::to_underlying(messages::MediaPlayerRendererExtension::kInitiateScopedSurfaceRequest),
     { &internal::MediaPlayerRendererExtension_InitiateScopedSurfaceRequest_Params_Data::Validate,
      &internal::MediaPlayerRendererExtension_InitiateScopedSurfaceRequest_ResponseParams_Data::Validate}},
};

bool MediaPlayerRendererExtensionRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::blink::MediaPlayerRendererExtension::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kMediaPlayerRendererExtensionValidationInfo);
}

bool MediaPlayerRendererExtensionResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::blink::MediaPlayerRendererExtension::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kMediaPlayerRendererExtensionValidationInfo);

}
const char FlingingRendererClientExtension::Name_[] = "media.mojom.FlingingRendererClientExtension";

FlingingRendererClientExtension::IPCStableHashFunction FlingingRendererClientExtension::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::FlingingRendererClientExtension>(message.name())) {
    case messages::FlingingRendererClientExtension::kOnRemotePlayStateChange: {
      return &FlingingRendererClientExtension::OnRemotePlayStateChange_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* FlingingRendererClientExtension::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::FlingingRendererClientExtension>(message.name())) {
      case messages::FlingingRendererClientExtension::kOnRemotePlayStateChange:
            return "Receive media::mojom::FlingingRendererClientExtension::OnRemotePlayStateChange";
    }
  } else {
    switch (static_cast<messages::FlingingRendererClientExtension>(message.name())) {
      case messages::FlingingRendererClientExtension::kOnRemotePlayStateChange:
            return "Receive reply media::mojom::FlingingRendererClientExtension::OnRemotePlayStateChange";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t FlingingRendererClientExtension::OnRemotePlayStateChange_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)media::mojom::FlingingRendererClientExtension::OnRemotePlayStateChange");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

FlingingRendererClientExtensionProxy::FlingingRendererClientExtensionProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FlingingRendererClientExtensionProxy::OnRemotePlayStateChange(
    ::media::mojom::blink::MediaStatusState in_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::FlingingRendererClientExtension::OnRemotePlayStateChange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("state"), in_state,
                        "<value of type ::media::mojom::blink::MediaStatusState>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FlingingRendererClientExtension::kOnRemotePlayStateChange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::FlingingRendererClientExtension_OnRemotePlayStateChange_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::media::mojom::MediaStatusState>(
      in_state, &params->state);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FlingingRendererClientExtension::Name_);
  message.set_method_name("OnRemotePlayStateChange");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool FlingingRendererClientExtensionStubDispatch::Accept(
    FlingingRendererClientExtension* impl,
    mojo::Message* message) {
  switch (static_cast<messages::FlingingRendererClientExtension>(message->header()->name)) {
    case messages::FlingingRendererClientExtension::kOnRemotePlayStateChange: {
      DCHECK(message->is_serialized());
      internal::FlingingRendererClientExtension_OnRemotePlayStateChange_Params_Data* params =
          reinterpret_cast<internal::FlingingRendererClientExtension_OnRemotePlayStateChange_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for FlingingRendererClientExtension.0
      bool success = true;
      ::media::mojom::blink::MediaStatusState p_state{};
      FlingingRendererClientExtension_OnRemotePlayStateChange_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadState(&p_state))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FlingingRendererClientExtension::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnRemotePlayStateChange(        
        std::move(p_state));
      return true;
    }
  }
  return false;
}

// static
bool FlingingRendererClientExtensionStubDispatch::AcceptWithResponder(
    FlingingRendererClientExtension* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::FlingingRendererClientExtension>(message->header()->name)) {
    case messages::FlingingRendererClientExtension::kOnRemotePlayStateChange: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kFlingingRendererClientExtensionValidationInfo[] = {
    {base::to_underlying(messages::FlingingRendererClientExtension::kOnRemotePlayStateChange),
     { &internal::FlingingRendererClientExtension_OnRemotePlayStateChange_Params_Data::Validate,
      nullptr /* no response */}},
};

bool FlingingRendererClientExtensionRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::blink::FlingingRendererClientExtension::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kFlingingRendererClientExtensionValidationInfo);
}

const char MediaFoundationRendererObserver::Name_[] = "media.mojom.MediaFoundationRendererObserver";

MediaFoundationRendererObserver::IPCStableHashFunction MediaFoundationRendererObserver::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* MediaFoundationRendererObserver::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
# endif // !BUILDFLAG(IS_FUCHSIA)

MediaFoundationRendererObserverProxy::MediaFoundationRendererObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

// static
bool MediaFoundationRendererObserverStubDispatch::Accept(
    MediaFoundationRendererObserver* impl,
    mojo::Message* message) {
  return false;
}

// static
bool MediaFoundationRendererObserverStubDispatch::AcceptWithResponder(
    MediaFoundationRendererObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  return false;
}
namespace {
}  // namespace

bool MediaFoundationRendererObserverRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::blink::MediaFoundationRendererObserver::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, {});
}

const char MediaFoundationRendererNotifier::Name_[] = "media.mojom.MediaFoundationRendererNotifier";

MediaFoundationRendererNotifier::IPCStableHashFunction MediaFoundationRendererNotifier::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::MediaFoundationRendererNotifier>(message.name())) {
    case messages::MediaFoundationRendererNotifier::kMediaFoundationRendererCreated: {
      return &MediaFoundationRendererNotifier::MediaFoundationRendererCreated_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* MediaFoundationRendererNotifier::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::MediaFoundationRendererNotifier>(message.name())) {
      case messages::MediaFoundationRendererNotifier::kMediaFoundationRendererCreated:
            return "Receive media::mojom::MediaFoundationRendererNotifier::MediaFoundationRendererCreated";
    }
  } else {
    switch (static_cast<messages::MediaFoundationRendererNotifier>(message.name())) {
      case messages::MediaFoundationRendererNotifier::kMediaFoundationRendererCreated:
            return "Receive reply media::mojom::MediaFoundationRendererNotifier::MediaFoundationRendererCreated";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t MediaFoundationRendererNotifier::MediaFoundationRendererCreated_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)media::mojom::MediaFoundationRendererNotifier::MediaFoundationRendererCreated");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

MediaFoundationRendererNotifierProxy::MediaFoundationRendererNotifierProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void MediaFoundationRendererNotifierProxy::MediaFoundationRendererCreated(
    ::mojo::PendingReceiver<MediaFoundationRendererObserver> in_observer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::MediaFoundationRendererNotifier::MediaFoundationRendererCreated", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer"), in_observer,
                        "<value of type ::mojo::PendingReceiver<MediaFoundationRendererObserver>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaFoundationRendererNotifier::kMediaFoundationRendererCreated), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::MediaFoundationRendererNotifier_MediaFoundationRendererCreated_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media::mojom::MediaFoundationRendererObserverInterfaceBase>>(
      in_observer, &params->observer, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->observer),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid observer in MediaFoundationRendererNotifier.MediaFoundationRendererCreated request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaFoundationRendererNotifier::Name_);
  message.set_method_name("MediaFoundationRendererCreated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool MediaFoundationRendererNotifierStubDispatch::Accept(
    MediaFoundationRendererNotifier* impl,
    mojo::Message* message) {
  switch (static_cast<messages::MediaFoundationRendererNotifier>(message->header()->name)) {
    case messages::MediaFoundationRendererNotifier::kMediaFoundationRendererCreated: {
      DCHECK(message->is_serialized());
      internal::MediaFoundationRendererNotifier_MediaFoundationRendererCreated_Params_Data* params =
          reinterpret_cast<internal::MediaFoundationRendererNotifier_MediaFoundationRendererCreated_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for MediaFoundationRendererNotifier.0
      bool success = true;
      ::mojo::PendingReceiver<MediaFoundationRendererObserver> p_observer{};
      MediaFoundationRendererNotifier_MediaFoundationRendererCreated_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_observer =
            input_data_view.TakeObserver<decltype(p_observer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaFoundationRendererNotifier::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MediaFoundationRendererCreated(        
        std::move(p_observer));
      return true;
    }
  }
  return false;
}

// static
bool MediaFoundationRendererNotifierStubDispatch::AcceptWithResponder(
    MediaFoundationRendererNotifier* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::MediaFoundationRendererNotifier>(message->header()->name)) {
    case messages::MediaFoundationRendererNotifier::kMediaFoundationRendererCreated: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kMediaFoundationRendererNotifierValidationInfo[] = {
    {base::to_underlying(messages::MediaFoundationRendererNotifier::kMediaFoundationRendererCreated),
     { &internal::MediaFoundationRendererNotifier_MediaFoundationRendererCreated_Params_Data::Validate,
      nullptr /* no response */}},
};

bool MediaFoundationRendererNotifierRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::blink::MediaFoundationRendererNotifier::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kMediaFoundationRendererNotifierValidationInfo);
}



}  // media::mojom::blink


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace media::mojom::blink {


void MediaPlayerRendererClientExtensionInterceptorForTesting::OnVideoSizeChange(const ::gfx::Size& size) {
  GetForwardingInterface()->OnVideoSizeChange(
    std::move(size)
    );
}
void MediaPlayerRendererClientExtensionInterceptorForTesting::OnDurationChange(::base::TimeDelta duration) {
  GetForwardingInterface()->OnDurationChange(
    std::move(duration)
    );
}
MediaPlayerRendererClientExtensionAsyncWaiter::MediaPlayerRendererClientExtensionAsyncWaiter(
    MediaPlayerRendererClientExtension* proxy) : proxy_(proxy) {}

MediaPlayerRendererClientExtensionAsyncWaiter::~MediaPlayerRendererClientExtensionAsyncWaiter() = default;




void MediaPlayerRendererExtensionInterceptorForTesting::InitiateScopedSurfaceRequest(InitiateScopedSurfaceRequestCallback callback) {
  GetForwardingInterface()->InitiateScopedSurfaceRequest(std::move(callback));
}
MediaPlayerRendererExtensionAsyncWaiter::MediaPlayerRendererExtensionAsyncWaiter(
    MediaPlayerRendererExtension* proxy) : proxy_(proxy) {}

MediaPlayerRendererExtensionAsyncWaiter::~MediaPlayerRendererExtensionAsyncWaiter() = default;

void MediaPlayerRendererExtensionAsyncWaiter::InitiateScopedSurfaceRequest(
    ::base::UnguessableToken* out_request_token) {
  base::RunLoop loop;
  proxy_->InitiateScopedSurfaceRequest(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::base::UnguessableToken* out_request_token
,
             const ::base::UnguessableToken& request_token) {*out_request_token = std::move(request_token);
            loop->Quit();
          },
          &loop,
          out_request_token));
  loop.Run();
}

::base::UnguessableToken MediaPlayerRendererExtensionAsyncWaiter::InitiateScopedSurfaceRequest(
    ) {
  ::base::UnguessableToken async_wait_result;
  InitiateScopedSurfaceRequest(&async_wait_result);
  return async_wait_result;
}




void FlingingRendererClientExtensionInterceptorForTesting::OnRemotePlayStateChange(::media::mojom::blink::MediaStatusState state) {
  GetForwardingInterface()->OnRemotePlayStateChange(
    std::move(state)
    );
}
FlingingRendererClientExtensionAsyncWaiter::FlingingRendererClientExtensionAsyncWaiter(
    FlingingRendererClientExtension* proxy) : proxy_(proxy) {}

FlingingRendererClientExtensionAsyncWaiter::~FlingingRendererClientExtensionAsyncWaiter() = default;




MediaFoundationRendererObserverAsyncWaiter::MediaFoundationRendererObserverAsyncWaiter(
    MediaFoundationRendererObserver* proxy) : proxy_(proxy) {}

MediaFoundationRendererObserverAsyncWaiter::~MediaFoundationRendererObserverAsyncWaiter() = default;




void MediaFoundationRendererNotifierInterceptorForTesting::MediaFoundationRendererCreated(::mojo::PendingReceiver<MediaFoundationRendererObserver> observer) {
  GetForwardingInterface()->MediaFoundationRendererCreated(
    std::move(observer)
    );
}
MediaFoundationRendererNotifierAsyncWaiter::MediaFoundationRendererNotifierAsyncWaiter(
    MediaFoundationRendererNotifier* proxy) : proxy_(proxy) {}

MediaFoundationRendererNotifierAsyncWaiter::~MediaFoundationRendererNotifierAsyncWaiter() = default;






}  // media::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif