// gpu/ipc/common/client_gmb_interface.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef GPU_IPC_COMMON_CLIENT_GMB_INTERFACE_MOJOM_H_
#define GPU_IPC_COMMON_CLIENT_GMB_INTERFACE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "gpu/ipc/common/client_gmb_interface.mojom-features.h"  // IWYU pragma: export
#include "gpu/ipc/common/client_gmb_interface.mojom-shared.h"  // IWYU pragma: export
#include "gpu/ipc/common/client_gmb_interface.mojom-forward.h"  // IWYU pragma: export
#include "ui/gfx/mojom/buffer_types.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "gpu/ipc/common/surface_handle.mojom.h"
#include "mojo/public/mojom/base/shared_memory.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace gpu::mojom {

class ClientGmbInterfaceProxy;

template <typename ImplRefTraits>
class ClientGmbInterfaceStub;

class ClientGmbInterfaceRequestValidator;
class ClientGmbInterfaceResponseValidator;


class ClientGmbInterface
    : public ClientGmbInterfaceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ClientGmbInterfaceInterfaceBase;
  using Proxy_ = ClientGmbInterfaceProxy;

  template <typename ImplRefTraits>
  using Stub_ = ClientGmbInterfaceStub<ImplRefTraits>;

  using RequestValidator_ = ClientGmbInterfaceRequestValidator;
  using ResponseValidator_ = ClientGmbInterfaceResponseValidator;
  enum MethodMinVersions : uint32_t {
    kCreateGpuMemoryBufferMinVersion = 0,
    kDestroyGpuMemoryBufferMinVersion = 0,
    kCopyGpuMemoryBufferMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreateGpuMemoryBuffer_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DestroyGpuMemoryBuffer_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CopyGpuMemoryBuffer_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ClientGmbInterface() = default;


  using CreateGpuMemoryBufferCallback = base::OnceCallback<void(::gfx::GpuMemoryBufferHandle)>;
  
  virtual void CreateGpuMemoryBuffer(::gfx::GpuMemoryBufferId id, const ::gfx::Size& size, ::gfx::BufferFormat format, ::gfx::BufferUsage usage, ::gpu::SurfaceHandle surface_handle, CreateGpuMemoryBufferCallback callback) = 0;

  
  virtual void DestroyGpuMemoryBuffer(::gfx::GpuMemoryBufferId id) = 0;


  using CopyGpuMemoryBufferCallback = base::OnceCallback<void(bool)>;
  
  virtual void CopyGpuMemoryBuffer(::gfx::GpuMemoryBufferHandle buffer_handle, ::base::UnsafeSharedMemoryRegion shared_memory, CopyGpuMemoryBufferCallback callback) = 0;
};



class  ClientGmbInterfaceProxy
    : public ClientGmbInterface {
 public:
  using InterfaceType = ClientGmbInterface;

  explicit ClientGmbInterfaceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreateGpuMemoryBuffer(::gfx::GpuMemoryBufferId id, const ::gfx::Size& size, ::gfx::BufferFormat format, ::gfx::BufferUsage usage, ::gpu::SurfaceHandle surface_handle, CreateGpuMemoryBufferCallback callback) final;
  
  void DestroyGpuMemoryBuffer(::gfx::GpuMemoryBufferId id) final;
  
  void CopyGpuMemoryBuffer(::gfx::GpuMemoryBufferHandle buffer_handle, ::base::UnsafeSharedMemoryRegion shared_memory, CopyGpuMemoryBufferCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  ClientGmbInterfaceStubDispatch {
 public:
  static bool Accept(ClientGmbInterface* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ClientGmbInterface* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ClientGmbInterface>>
class ClientGmbInterfaceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ClientGmbInterfaceStub() = default;
  ~ClientGmbInterfaceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ClientGmbInterfaceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ClientGmbInterfaceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ClientGmbInterfaceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ClientGmbInterfaceResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // gpu::mojom

namespace mojo {

}  // namespace mojo

#endif  // GPU_IPC_COMMON_CLIENT_GMB_INTERFACE_MOJOM_H_