// components/services/filesystem/public/mojom/directory.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_FILESYSTEM_PUBLIC_MOJOM_DIRECTORY_MOJOM_PARAMS_DATA_H_
#define COMPONENTS_SERVICES_FILESYSTEM_PUBLIC_MOJOM_DIRECTORY_MOJOM_PARAMS_DATA_H_

#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace filesystem::mojom {
namespace internal {
class  Directory_Read_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<Directory_Read_Params_Data>;

  Directory_Read_Params_Data();
  ~Directory_Read_Params_Data() = delete;
};
static_assert(sizeof(Directory_Read_Params_Data) == 8,
              "Bad sizeof(Directory_Read_Params_Data)");
class  Directory_Read_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t error;
  uint8_t pad0_[4];
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<::filesystem::mojom::internal::DirectoryEntry_Data>>> directory_contents;

 private:
  friend class mojo::internal::MessageFragment<Directory_Read_ResponseParams_Data>;

  Directory_Read_ResponseParams_Data();
  ~Directory_Read_ResponseParams_Data() = delete;
};
static_assert(sizeof(Directory_Read_ResponseParams_Data) == 24,
              "Bad sizeof(Directory_Read_ResponseParams_Data)");
class  Directory_OpenFileHandle_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> path;
  uint32_t open_flags;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<Directory_OpenFileHandle_Params_Data>;

  Directory_OpenFileHandle_Params_Data();
  ~Directory_OpenFileHandle_Params_Data() = delete;
};
static_assert(sizeof(Directory_OpenFileHandle_Params_Data) == 24,
              "Bad sizeof(Directory_OpenFileHandle_Params_Data)");
class  Directory_OpenFileHandle_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t error;
  uint8_t pad0_[4];
  mojo::internal::Pointer<::mojo_base::mojom::internal::File_Data> file_handle;

 private:
  friend class mojo::internal::MessageFragment<Directory_OpenFileHandle_ResponseParams_Data>;

  Directory_OpenFileHandle_ResponseParams_Data();
  ~Directory_OpenFileHandle_ResponseParams_Data() = delete;
};
static_assert(sizeof(Directory_OpenFileHandle_ResponseParams_Data) == 24,
              "Bad sizeof(Directory_OpenFileHandle_ResponseParams_Data)");
class  Directory_OpenFileHandles_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::FileOpenDetails_Data>>> files;

 private:
  friend class mojo::internal::MessageFragment<Directory_OpenFileHandles_Params_Data>;

  Directory_OpenFileHandles_Params_Data();
  ~Directory_OpenFileHandles_Params_Data() = delete;
};
static_assert(sizeof(Directory_OpenFileHandles_Params_Data) == 16,
              "Bad sizeof(Directory_OpenFileHandles_Params_Data)");
class  Directory_OpenFileHandles_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::FileOpenResult_Data>>> results;

 private:
  friend class mojo::internal::MessageFragment<Directory_OpenFileHandles_ResponseParams_Data>;

  Directory_OpenFileHandles_ResponseParams_Data();
  ~Directory_OpenFileHandles_ResponseParams_Data() = delete;
};
static_assert(sizeof(Directory_OpenFileHandles_ResponseParams_Data) == 16,
              "Bad sizeof(Directory_OpenFileHandles_ResponseParams_Data)");
class  Directory_OpenDirectory_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> path;
  mojo::internal::Handle_Data directory;
  uint32_t open_flags;

 private:
  friend class mojo::internal::MessageFragment<Directory_OpenDirectory_Params_Data>;

  Directory_OpenDirectory_Params_Data();
  ~Directory_OpenDirectory_Params_Data() = delete;
};
static_assert(sizeof(Directory_OpenDirectory_Params_Data) == 24,
              "Bad sizeof(Directory_OpenDirectory_Params_Data)");
class  Directory_OpenDirectory_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t error;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<Directory_OpenDirectory_ResponseParams_Data>;

  Directory_OpenDirectory_ResponseParams_Data();
  ~Directory_OpenDirectory_ResponseParams_Data() = delete;
};
static_assert(sizeof(Directory_OpenDirectory_ResponseParams_Data) == 16,
              "Bad sizeof(Directory_OpenDirectory_ResponseParams_Data)");
class  Directory_Rename_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> path;
  mojo::internal::Pointer<mojo::internal::String_Data> new_path;

 private:
  friend class mojo::internal::MessageFragment<Directory_Rename_Params_Data>;

  Directory_Rename_Params_Data();
  ~Directory_Rename_Params_Data() = delete;
};
static_assert(sizeof(Directory_Rename_Params_Data) == 24,
              "Bad sizeof(Directory_Rename_Params_Data)");
class  Directory_Rename_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t error;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<Directory_Rename_ResponseParams_Data>;

  Directory_Rename_ResponseParams_Data();
  ~Directory_Rename_ResponseParams_Data() = delete;
};
static_assert(sizeof(Directory_Rename_ResponseParams_Data) == 16,
              "Bad sizeof(Directory_Rename_ResponseParams_Data)");
class  Directory_Replace_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> path;
  mojo::internal::Pointer<mojo::internal::String_Data> new_path;

 private:
  friend class mojo::internal::MessageFragment<Directory_Replace_Params_Data>;

  Directory_Replace_Params_Data();
  ~Directory_Replace_Params_Data() = delete;
};
static_assert(sizeof(Directory_Replace_Params_Data) == 24,
              "Bad sizeof(Directory_Replace_Params_Data)");
class  Directory_Replace_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t error;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<Directory_Replace_ResponseParams_Data>;

  Directory_Replace_ResponseParams_Data();
  ~Directory_Replace_ResponseParams_Data() = delete;
};
static_assert(sizeof(Directory_Replace_ResponseParams_Data) == 16,
              "Bad sizeof(Directory_Replace_ResponseParams_Data)");
class  Directory_Delete_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> path;
  uint32_t delete_flags;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<Directory_Delete_Params_Data>;

  Directory_Delete_Params_Data();
  ~Directory_Delete_Params_Data() = delete;
};
static_assert(sizeof(Directory_Delete_Params_Data) == 24,
              "Bad sizeof(Directory_Delete_Params_Data)");
class  Directory_Delete_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t error;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<Directory_Delete_ResponseParams_Data>;

  Directory_Delete_ResponseParams_Data();
  ~Directory_Delete_ResponseParams_Data() = delete;
};
static_assert(sizeof(Directory_Delete_ResponseParams_Data) == 16,
              "Bad sizeof(Directory_Delete_ResponseParams_Data)");
class  Directory_Exists_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> path;

 private:
  friend class mojo::internal::MessageFragment<Directory_Exists_Params_Data>;

  Directory_Exists_Params_Data();
  ~Directory_Exists_Params_Data() = delete;
};
static_assert(sizeof(Directory_Exists_Params_Data) == 16,
              "Bad sizeof(Directory_Exists_Params_Data)");
class  Directory_Exists_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t error;
  uint8_t exists : 1;
  uint8_t padfinal_[3];

 private:
  friend class mojo::internal::MessageFragment<Directory_Exists_ResponseParams_Data>;

  Directory_Exists_ResponseParams_Data();
  ~Directory_Exists_ResponseParams_Data() = delete;
};
static_assert(sizeof(Directory_Exists_ResponseParams_Data) == 16,
              "Bad sizeof(Directory_Exists_ResponseParams_Data)");
class  Directory_IsWritable_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> path;

 private:
  friend class mojo::internal::MessageFragment<Directory_IsWritable_Params_Data>;

  Directory_IsWritable_Params_Data();
  ~Directory_IsWritable_Params_Data() = delete;
};
static_assert(sizeof(Directory_IsWritable_Params_Data) == 16,
              "Bad sizeof(Directory_IsWritable_Params_Data)");
class  Directory_IsWritable_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t error;
  uint8_t is_writable : 1;
  uint8_t padfinal_[3];

 private:
  friend class mojo::internal::MessageFragment<Directory_IsWritable_ResponseParams_Data>;

  Directory_IsWritable_ResponseParams_Data();
  ~Directory_IsWritable_ResponseParams_Data() = delete;
};
static_assert(sizeof(Directory_IsWritable_ResponseParams_Data) == 16,
              "Bad sizeof(Directory_IsWritable_ResponseParams_Data)");
class  Directory_Flush_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<Directory_Flush_Params_Data>;

  Directory_Flush_Params_Data();
  ~Directory_Flush_Params_Data() = delete;
};
static_assert(sizeof(Directory_Flush_Params_Data) == 8,
              "Bad sizeof(Directory_Flush_Params_Data)");
class  Directory_Flush_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t error;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<Directory_Flush_ResponseParams_Data>;

  Directory_Flush_ResponseParams_Data();
  ~Directory_Flush_ResponseParams_Data() = delete;
};
static_assert(sizeof(Directory_Flush_ResponseParams_Data) == 16,
              "Bad sizeof(Directory_Flush_ResponseParams_Data)");
class  Directory_StatFile_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> path;

 private:
  friend class mojo::internal::MessageFragment<Directory_StatFile_Params_Data>;

  Directory_StatFile_Params_Data();
  ~Directory_StatFile_Params_Data() = delete;
};
static_assert(sizeof(Directory_StatFile_Params_Data) == 16,
              "Bad sizeof(Directory_StatFile_Params_Data)");
class  Directory_StatFile_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t error;
  uint8_t pad0_[4];
  mojo::internal::Pointer<::filesystem::mojom::internal::FileInformation_Data> file_information;

 private:
  friend class mojo::internal::MessageFragment<Directory_StatFile_ResponseParams_Data>;

  Directory_StatFile_ResponseParams_Data();
  ~Directory_StatFile_ResponseParams_Data() = delete;
};
static_assert(sizeof(Directory_StatFile_ResponseParams_Data) == 24,
              "Bad sizeof(Directory_StatFile_ResponseParams_Data)");
class  Directory_Clone_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Handle_Data directory;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<Directory_Clone_Params_Data>;

  Directory_Clone_Params_Data();
  ~Directory_Clone_Params_Data() = delete;
};
static_assert(sizeof(Directory_Clone_Params_Data) == 16,
              "Bad sizeof(Directory_Clone_Params_Data)");
class  Directory_ReadEntireFile_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> path;

 private:
  friend class mojo::internal::MessageFragment<Directory_ReadEntireFile_Params_Data>;

  Directory_ReadEntireFile_Params_Data();
  ~Directory_ReadEntireFile_Params_Data() = delete;
};
static_assert(sizeof(Directory_ReadEntireFile_Params_Data) == 16,
              "Bad sizeof(Directory_ReadEntireFile_Params_Data)");
class  Directory_ReadEntireFile_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t error;
  uint8_t pad0_[4];
  mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> data;

 private:
  friend class mojo::internal::MessageFragment<Directory_ReadEntireFile_ResponseParams_Data>;

  Directory_ReadEntireFile_ResponseParams_Data();
  ~Directory_ReadEntireFile_ResponseParams_Data() = delete;
};
static_assert(sizeof(Directory_ReadEntireFile_ResponseParams_Data) == 24,
              "Bad sizeof(Directory_ReadEntireFile_ResponseParams_Data)");
class  Directory_WriteFile_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> path;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> data;

 private:
  friend class mojo::internal::MessageFragment<Directory_WriteFile_Params_Data>;

  Directory_WriteFile_Params_Data();
  ~Directory_WriteFile_Params_Data() = delete;
};
static_assert(sizeof(Directory_WriteFile_Params_Data) == 24,
              "Bad sizeof(Directory_WriteFile_Params_Data)");
class  Directory_WriteFile_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t error;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<Directory_WriteFile_ResponseParams_Data>;

  Directory_WriteFile_ResponseParams_Data();
  ~Directory_WriteFile_ResponseParams_Data() = delete;
};
static_assert(sizeof(Directory_WriteFile_ResponseParams_Data) == 16,
              "Bad sizeof(Directory_WriteFile_ResponseParams_Data)");

}  // namespace internal


class Directory_Read_ParamsDataView {
 public:
  Directory_Read_ParamsDataView() = default;

  Directory_Read_ParamsDataView(
      internal::Directory_Read_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::Directory_Read_Params_Data* data_ = nullptr;
};


class Directory_Read_ResponseParamsDataView {
 public:
  Directory_Read_ResponseParamsDataView() = default;

  Directory_Read_ResponseParamsDataView(
      internal::Directory_Read_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadError(UserType* output) const {
    auto data_value = data_->error;
    return mojo::internal::Deserialize<::mojo_base::mojom::FileError>(
        data_value, output);
  }
  ::mojo_base::mojom::FileError error() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::mojo_base::mojom::FileError>(data_->error));
  }
  inline void GetDirectoryContentsDataView(
      mojo::ArrayDataView<::filesystem::mojom::DirectoryEntryDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDirectoryContents(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::filesystem::mojom::DirectoryEntryDataView>, UserType>(),
    "Attempting to read the optional `directory_contents` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDirectoryContents` instead "
    "of `ReadDirectoryContents if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->directory_contents.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::filesystem::mojom::DirectoryEntryDataView>>(
        pointer, output, message_);
  }
 private:
  internal::Directory_Read_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Directory_OpenFileHandle_ParamsDataView {
 public:
  Directory_OpenFileHandle_ParamsDataView() = default;

  Directory_OpenFileHandle_ParamsDataView(
      internal::Directory_OpenFileHandle_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPathDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPath(UserType* output) {
    
    auto* pointer = data_->path.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  uint32_t open_flags() const {
    return data_->open_flags;
  }
 private:
  internal::Directory_OpenFileHandle_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Directory_OpenFileHandle_ResponseParamsDataView {
 public:
  Directory_OpenFileHandle_ResponseParamsDataView() = default;

  Directory_OpenFileHandle_ResponseParamsDataView(
      internal::Directory_OpenFileHandle_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadError(UserType* output) const {
    auto data_value = data_->error;
    return mojo::internal::Deserialize<::mojo_base::mojom::FileError>(
        data_value, output);
  }
  ::mojo_base::mojom::FileError error() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::mojo_base::mojom::FileError>(data_->error));
  }
  inline void GetFileHandleDataView(
      ::mojo_base::mojom::FileDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFileHandle(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::FileDataView, UserType>(),
    "Attempting to read the optional `file_handle` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFileHandle` instead "
    "of `ReadFileHandle if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->file_handle.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FileDataView>(
        pointer, output, message_);
  }
 private:
  internal::Directory_OpenFileHandle_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Directory_OpenFileHandles_ParamsDataView {
 public:
  Directory_OpenFileHandles_ParamsDataView() = default;

  Directory_OpenFileHandles_ParamsDataView(
      internal::Directory_OpenFileHandles_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFilesDataView(
      mojo::ArrayDataView<FileOpenDetailsDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFiles(UserType* output) {
    
    auto* pointer = data_->files.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::filesystem::mojom::FileOpenDetailsDataView>>(
        pointer, output, message_);
  }
 private:
  internal::Directory_OpenFileHandles_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Directory_OpenFileHandles_ResponseParamsDataView {
 public:
  Directory_OpenFileHandles_ResponseParamsDataView() = default;

  Directory_OpenFileHandles_ResponseParamsDataView(
      internal::Directory_OpenFileHandles_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetResultsDataView(
      mojo::ArrayDataView<FileOpenResultDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResults(UserType* output) {
    
    auto* pointer = data_->results.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::filesystem::mojom::FileOpenResultDataView>>(
        pointer, output, message_);
  }
 private:
  internal::Directory_OpenFileHandles_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Directory_OpenDirectory_ParamsDataView {
 public:
  Directory_OpenDirectory_ParamsDataView() = default;

  Directory_OpenDirectory_ParamsDataView(
      internal::Directory_OpenDirectory_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPathDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPath(UserType* output) {
    
    auto* pointer = data_->path.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeDirectory() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::filesystem::mojom::DirectoryInterfaceBase>>(
            &data_->directory, &result, message_);
    DCHECK(ret);
    return result;
  }
  uint32_t open_flags() const {
    return data_->open_flags;
  }
 private:
  internal::Directory_OpenDirectory_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Directory_OpenDirectory_ResponseParamsDataView {
 public:
  Directory_OpenDirectory_ResponseParamsDataView() = default;

  Directory_OpenDirectory_ResponseParamsDataView(
      internal::Directory_OpenDirectory_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadError(UserType* output) const {
    auto data_value = data_->error;
    return mojo::internal::Deserialize<::mojo_base::mojom::FileError>(
        data_value, output);
  }
  ::mojo_base::mojom::FileError error() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::mojo_base::mojom::FileError>(data_->error));
  }
 private:
  internal::Directory_OpenDirectory_ResponseParams_Data* data_ = nullptr;
};


class Directory_Rename_ParamsDataView {
 public:
  Directory_Rename_ParamsDataView() = default;

  Directory_Rename_ParamsDataView(
      internal::Directory_Rename_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPathDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPath(UserType* output) {
    
    auto* pointer = data_->path.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetNewPathDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNewPath(UserType* output) {
    
    auto* pointer = data_->new_path.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::Directory_Rename_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Directory_Rename_ResponseParamsDataView {
 public:
  Directory_Rename_ResponseParamsDataView() = default;

  Directory_Rename_ResponseParamsDataView(
      internal::Directory_Rename_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadError(UserType* output) const {
    auto data_value = data_->error;
    return mojo::internal::Deserialize<::mojo_base::mojom::FileError>(
        data_value, output);
  }
  ::mojo_base::mojom::FileError error() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::mojo_base::mojom::FileError>(data_->error));
  }
 private:
  internal::Directory_Rename_ResponseParams_Data* data_ = nullptr;
};


class Directory_Replace_ParamsDataView {
 public:
  Directory_Replace_ParamsDataView() = default;

  Directory_Replace_ParamsDataView(
      internal::Directory_Replace_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPathDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPath(UserType* output) {
    
    auto* pointer = data_->path.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetNewPathDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNewPath(UserType* output) {
    
    auto* pointer = data_->new_path.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::Directory_Replace_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Directory_Replace_ResponseParamsDataView {
 public:
  Directory_Replace_ResponseParamsDataView() = default;

  Directory_Replace_ResponseParamsDataView(
      internal::Directory_Replace_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadError(UserType* output) const {
    auto data_value = data_->error;
    return mojo::internal::Deserialize<::mojo_base::mojom::FileError>(
        data_value, output);
  }
  ::mojo_base::mojom::FileError error() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::mojo_base::mojom::FileError>(data_->error));
  }
 private:
  internal::Directory_Replace_ResponseParams_Data* data_ = nullptr;
};


class Directory_Delete_ParamsDataView {
 public:
  Directory_Delete_ParamsDataView() = default;

  Directory_Delete_ParamsDataView(
      internal::Directory_Delete_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPathDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPath(UserType* output) {
    
    auto* pointer = data_->path.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  uint32_t delete_flags() const {
    return data_->delete_flags;
  }
 private:
  internal::Directory_Delete_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Directory_Delete_ResponseParamsDataView {
 public:
  Directory_Delete_ResponseParamsDataView() = default;

  Directory_Delete_ResponseParamsDataView(
      internal::Directory_Delete_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadError(UserType* output) const {
    auto data_value = data_->error;
    return mojo::internal::Deserialize<::mojo_base::mojom::FileError>(
        data_value, output);
  }
  ::mojo_base::mojom::FileError error() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::mojo_base::mojom::FileError>(data_->error));
  }
 private:
  internal::Directory_Delete_ResponseParams_Data* data_ = nullptr;
};


class Directory_Exists_ParamsDataView {
 public:
  Directory_Exists_ParamsDataView() = default;

  Directory_Exists_ParamsDataView(
      internal::Directory_Exists_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPathDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPath(UserType* output) {
    
    auto* pointer = data_->path.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::Directory_Exists_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Directory_Exists_ResponseParamsDataView {
 public:
  Directory_Exists_ResponseParamsDataView() = default;

  Directory_Exists_ResponseParamsDataView(
      internal::Directory_Exists_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadError(UserType* output) const {
    auto data_value = data_->error;
    return mojo::internal::Deserialize<::mojo_base::mojom::FileError>(
        data_value, output);
  }
  ::mojo_base::mojom::FileError error() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::mojo_base::mojom::FileError>(data_->error));
  }
  bool exists() const {
    return data_->exists;
  }
 private:
  internal::Directory_Exists_ResponseParams_Data* data_ = nullptr;
};


class Directory_IsWritable_ParamsDataView {
 public:
  Directory_IsWritable_ParamsDataView() = default;

  Directory_IsWritable_ParamsDataView(
      internal::Directory_IsWritable_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPathDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPath(UserType* output) {
    
    auto* pointer = data_->path.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::Directory_IsWritable_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Directory_IsWritable_ResponseParamsDataView {
 public:
  Directory_IsWritable_ResponseParamsDataView() = default;

  Directory_IsWritable_ResponseParamsDataView(
      internal::Directory_IsWritable_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadError(UserType* output) const {
    auto data_value = data_->error;
    return mojo::internal::Deserialize<::mojo_base::mojom::FileError>(
        data_value, output);
  }
  ::mojo_base::mojom::FileError error() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::mojo_base::mojom::FileError>(data_->error));
  }
  bool is_writable() const {
    return data_->is_writable;
  }
 private:
  internal::Directory_IsWritable_ResponseParams_Data* data_ = nullptr;
};


class Directory_Flush_ParamsDataView {
 public:
  Directory_Flush_ParamsDataView() = default;

  Directory_Flush_ParamsDataView(
      internal::Directory_Flush_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::Directory_Flush_Params_Data* data_ = nullptr;
};


class Directory_Flush_ResponseParamsDataView {
 public:
  Directory_Flush_ResponseParamsDataView() = default;

  Directory_Flush_ResponseParamsDataView(
      internal::Directory_Flush_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadError(UserType* output) const {
    auto data_value = data_->error;
    return mojo::internal::Deserialize<::mojo_base::mojom::FileError>(
        data_value, output);
  }
  ::mojo_base::mojom::FileError error() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::mojo_base::mojom::FileError>(data_->error));
  }
 private:
  internal::Directory_Flush_ResponseParams_Data* data_ = nullptr;
};


class Directory_StatFile_ParamsDataView {
 public:
  Directory_StatFile_ParamsDataView() = default;

  Directory_StatFile_ParamsDataView(
      internal::Directory_StatFile_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPathDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPath(UserType* output) {
    
    auto* pointer = data_->path.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::Directory_StatFile_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Directory_StatFile_ResponseParamsDataView {
 public:
  Directory_StatFile_ResponseParamsDataView() = default;

  Directory_StatFile_ResponseParamsDataView(
      internal::Directory_StatFile_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadError(UserType* output) const {
    auto data_value = data_->error;
    return mojo::internal::Deserialize<::mojo_base::mojom::FileError>(
        data_value, output);
  }
  ::mojo_base::mojom::FileError error() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::mojo_base::mojom::FileError>(data_->error));
  }
  inline void GetFileInformationDataView(
      ::filesystem::mojom::FileInformationDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFileInformation(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::filesystem::mojom::FileInformationDataView, UserType>(),
    "Attempting to read the optional `file_information` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFileInformation` instead "
    "of `ReadFileInformation if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->file_information.Get();
    return mojo::internal::Deserialize<::filesystem::mojom::FileInformationDataView>(
        pointer, output, message_);
  }
 private:
  internal::Directory_StatFile_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Directory_Clone_ParamsDataView {
 public:
  Directory_Clone_ParamsDataView() = default;

  Directory_Clone_ParamsDataView(
      internal::Directory_Clone_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeDirectory() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::filesystem::mojom::DirectoryInterfaceBase>>(
            &data_->directory, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::Directory_Clone_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Directory_ReadEntireFile_ParamsDataView {
 public:
  Directory_ReadEntireFile_ParamsDataView() = default;

  Directory_ReadEntireFile_ParamsDataView(
      internal::Directory_ReadEntireFile_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPathDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPath(UserType* output) {
    
    auto* pointer = data_->path.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::Directory_ReadEntireFile_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Directory_ReadEntireFile_ResponseParamsDataView {
 public:
  Directory_ReadEntireFile_ResponseParamsDataView() = default;

  Directory_ReadEntireFile_ResponseParamsDataView(
      internal::Directory_ReadEntireFile_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadError(UserType* output) const {
    auto data_value = data_->error;
    return mojo::internal::Deserialize<::mojo_base::mojom::FileError>(
        data_value, output);
  }
  ::mojo_base::mojom::FileError error() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::mojo_base::mojom::FileError>(data_->error));
  }
  inline void GetDataDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadData(UserType* output) {
    
    auto* pointer = data_->data.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
 private:
  internal::Directory_ReadEntireFile_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Directory_WriteFile_ParamsDataView {
 public:
  Directory_WriteFile_ParamsDataView() = default;

  Directory_WriteFile_ParamsDataView(
      internal::Directory_WriteFile_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPathDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPath(UserType* output) {
    
    auto* pointer = data_->path.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDataDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadData(UserType* output) {
    
    auto* pointer = data_->data.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
 private:
  internal::Directory_WriteFile_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Directory_WriteFile_ResponseParamsDataView {
 public:
  Directory_WriteFile_ResponseParamsDataView() = default;

  Directory_WriteFile_ResponseParamsDataView(
      internal::Directory_WriteFile_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadError(UserType* output) const {
    auto data_value = data_->error;
    return mojo::internal::Deserialize<::mojo_base::mojom::FileError>(
        data_value, output);
  }
  ::mojo_base::mojom::FileError error() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::mojo_base::mojom::FileError>(data_->error));
  }
 private:
  internal::Directory_WriteFile_ResponseParams_Data* data_ = nullptr;
};



inline void Directory_Read_ResponseParamsDataView::GetDirectoryContentsDataView(
    mojo::ArrayDataView<::filesystem::mojom::DirectoryEntryDataView>* output) {
  auto pointer = data_->directory_contents.Get();
  *output = mojo::ArrayDataView<::filesystem::mojom::DirectoryEntryDataView>(pointer, message_);
}


inline void Directory_OpenFileHandle_ParamsDataView::GetPathDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->path.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void Directory_OpenFileHandle_ResponseParamsDataView::GetFileHandleDataView(
    ::mojo_base::mojom::FileDataView* output) {
  auto pointer = data_->file_handle.Get();
  *output = ::mojo_base::mojom::FileDataView(pointer, message_);
}


inline void Directory_OpenFileHandles_ParamsDataView::GetFilesDataView(
    mojo::ArrayDataView<FileOpenDetailsDataView>* output) {
  auto pointer = data_->files.Get();
  *output = mojo::ArrayDataView<FileOpenDetailsDataView>(pointer, message_);
}


inline void Directory_OpenFileHandles_ResponseParamsDataView::GetResultsDataView(
    mojo::ArrayDataView<FileOpenResultDataView>* output) {
  auto pointer = data_->results.Get();
  *output = mojo::ArrayDataView<FileOpenResultDataView>(pointer, message_);
}


inline void Directory_OpenDirectory_ParamsDataView::GetPathDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->path.Get();
  *output = mojo::StringDataView(pointer, message_);
}




inline void Directory_Rename_ParamsDataView::GetPathDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->path.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void Directory_Rename_ParamsDataView::GetNewPathDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->new_path.Get();
  *output = mojo::StringDataView(pointer, message_);
}




inline void Directory_Replace_ParamsDataView::GetPathDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->path.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void Directory_Replace_ParamsDataView::GetNewPathDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->new_path.Get();
  *output = mojo::StringDataView(pointer, message_);
}




inline void Directory_Delete_ParamsDataView::GetPathDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->path.Get();
  *output = mojo::StringDataView(pointer, message_);
}




inline void Directory_Exists_ParamsDataView::GetPathDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->path.Get();
  *output = mojo::StringDataView(pointer, message_);
}




inline void Directory_IsWritable_ParamsDataView::GetPathDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->path.Get();
  *output = mojo::StringDataView(pointer, message_);
}








inline void Directory_StatFile_ParamsDataView::GetPathDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->path.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void Directory_StatFile_ResponseParamsDataView::GetFileInformationDataView(
    ::filesystem::mojom::FileInformationDataView* output) {
  auto pointer = data_->file_information.Get();
  *output = ::filesystem::mojom::FileInformationDataView(pointer, message_);
}




inline void Directory_ReadEntireFile_ParamsDataView::GetPathDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->path.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void Directory_ReadEntireFile_ResponseParamsDataView::GetDataDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->data.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}


inline void Directory_WriteFile_ParamsDataView::GetPathDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->path.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void Directory_WriteFile_ParamsDataView::GetDataDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->data.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}





}  // filesystem::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // COMPONENTS_SERVICES_FILESYSTEM_PUBLIC_MOJOM_DIRECTORY_MOJOM_PARAMS_DATA_H_